
import { systemConfig } from '../config/serverConfig';
import { getEnterprise } from '../data/db/qyfw';
import { qyfwTableData } from '../data/table/qyfwData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../dataPackage/out';

/*                            企业服务                    */

export async function getData(req, res) {
    let dbData = await getEnterprise();
    let excelData = qyfwTableData();

    let ret:any = {};

    let qyjbqkPackageData = keyValuePackage(excelData['企业基本情况'].dataList);
    ret['qyjbqk'] = getKeyValueOut('企业基本情况', qyjbqkPackageData);
                    
    let bhqsfxPackageData = onceYBarChartPackage( excelData['变化趋势分析'], '','');
    ret['bhqsfx'] = getOnceYBarChartOut('变化趋势分析', bhqsfxPackageData);
                    
    let rfszfbPackageData = keyValuePackage(excelData['入孵时长分布'].dataList);
    ret['rfszfb'] = getKeyValueOut('入孵时长分布', rfszfbPackageData);
                    
    let fhqyhylyzbPackageData = keyValuePackage(excelData['孵化企业行业领域占比'].dataList);
    ret['fhqyhylyzb'] = getKeyValueOut('孵化企业行业领域占比', fhqyhylyzbPackageData);
                    
    let qyrcPackageData = onceYBarChartPackage( excelData['企业人才'], '','');
    ret['qyrc'] = getOnceYBarChartOut('企业人才', qyrcPackageData);
                    
    let qyfwhzsjPackageData = keyValuePackage(excelData['企业服务汇总数据'].dataList);
    ret['qyfwhzsj'] = getKeyValueOut('企业服务汇总数据', qyfwhzsjPackageData);
                    
    let qyxqdtPackageData = keyValuePackage(excelData['企业需求动态'].dataList);
    ret['qyxqdt'] = getKeyValueOut('企业需求动态', qyxqdtPackageData);
                    
    // let qyxqdtxxTableData = tablePackage(excelData["企业需求动态详细"].headerList[0], excelData["企业需求动态详细"].bodyList);
    
    // let itemDataList = []
    // qyxqdtxxTableData.dataList.forEach(info => {
    //     info.eId = "xxxx";
    //     itemDataList.push(info);
    // });
    // qyxqdtxxTableData.dataList = itemDataList;
    // ret['qyxqdtxx'] = getTableOut( '企业需求动态详细', qyxqdtxxTableData);
    
    let qyxqdtxxTableData = tablePackage(dbData["企业需求动态详细"].headerList[0], dbData["企业需求动态详细"].bodyList);
    ret['qyxqdtxx'] = getTableOut( '企业需求动态详细', qyxqdtxxTableData);
                    
    let dtTableData = tablePackage(excelData["地图"].headerList[0], excelData["地图"].bodyList);
    let dt = {dataList:[], titleList:dtTableData.titleList};
    dtTableData.dataList.forEach(info => {
        let {D} = info;
        let imgUrl = `${systemConfig.imgPath}/${D}`;
        info["D"] = imgUrl;
        dt.dataList.push(info);
    })
    ret['dt'] = getTableOut( '地图', dt);
                    
    let qybhqkPackageData = keyValuePackage(excelData['企业变化情况'].dataList);
    ret['qybhqk'] = getKeyValueOut('企业变化情况', qybhqkPackageData);
                    
    let bhqsPackageData = onceYBarChartPackage( excelData['变化趋势'], '家','');
    ret['bhqs'] = getOnceYBarChartOut('变化趋势', bhqsPackageData);
                    
    let jrfwPackageData = keyValuePackage(excelData['金融服务'].dataList);
    ret['jrfw'] = getKeyValueOut('金融服务', jrfwPackageData);
                    
    let byrzqyPackageData = onceYBarChartPackage( excelData['本月融资企业'], '','');
    ret['byrzqy'] = getOnceYBarChartOut('本月融资企业', byrzqyPackageData);
                    
    let byrzjePackageData = onceYBarChartPackage( excelData['本月融资金额'], '','');
    ret['byrzje'] = getOnceYBarChartOut('本月融资金额', byrzjePackageData);
                    
    let zfqyzysPackageData = keyValuePackage(excelData['在孵企业总营收'].dataList);
    ret['zfqyzys'] = getKeyValueOut('在孵企业总营收', zfqyzysPackageData);
                    
    let jrfwqyTableData = tablePackage(excelData["金融服务企业"].headerList[0], excelData["金融服务企业"].bodyList);
    ret['jrfwqy'] = getTableOut( '金融服务企业', jrfwqyTableData);
                    
    let zscqPackageData = keyValuePackage(excelData['知识产权'].dataList);
    ret['zscq'] = getKeyValueOut('知识产权', zscqPackageData);
                    
    let zscqbtPackageData = keyValuePackage(excelData['知识产权饼图'].dataList);
    ret['zscqbt'] = getKeyValueOut('知识产权饼图', zscqbtPackageData);
                    
    let zscqxqTableData = tablePackage(excelData["知识产权详情"].headerList[0], excelData["知识产权详情"].bodyList);
    ret['zscqxq'] = getTableOut( '知识产权详情', zscqxqTableData);
                    
    let qyzzflPackageData = keyValuePackage(excelData['企业资质分类'].dataList);
    ret['qyzzfl'] = getKeyValueOut('企业资质分类', qyzzflPackageData);
                    
    let qyzzfl_xjrTableData = tablePackage(excelData["企业资质分类_小巨人"].headerList[0], excelData["企业资质分类_小巨人"].bodyList);
    ret['qyzzfl_xjr'] = getTableOut( '企业资质分类_小巨人', qyzzfl_xjrTableData);
                    
    let qyzzfl_gxqyTableData = tablePackage(excelData["企业资质分类_高新企业"].headerList[0], excelData["企业资质分类_高新企业"].bodyList);
    ret['qyzzfl_gxqy'] = getTableOut( '企业资质分类_高新企业', qyzzfl_gxqyTableData);
                    
    let qyzzfl_zjtxTableData = tablePackage(excelData["企业资质分类_专精特新"].headerList[0], excelData["企业资质分类_专精特新"].bodyList);
    ret['qyzzfl_zjtx'] = getTableOut( '企业资质分类_专精特新', qyzzfl_zjtxTableData);
                    
    let qyzzfl_gqpyTableData = tablePackage(excelData["企业资质分类_高企培育"].headerList[0], excelData["企业资质分类_高企培育"].bodyList);
    ret['qyzzfl_gqpy'] = getTableOut( '企业资质分类_高企培育', qyzzfl_gqpyTableData);
                     
    res.send(ret);
} 