/**创业团队 */

import { CreateTeamConfig } from "../../config/eccParamConfig";
import { DEGREE, OPERATIONALDATATYPE, RALENTTYPE, TABLENAME } from "../../config/enum";
import { operationalData } from "../../data/db/operationalData";
import { eccEnumValue } from "../../tools/eccEnum";
import { eccFormParam } from "../../tools/eccParam";
import { generateSystemId, getFileType, getMySqlMs } from "../../tools/systemTools";


/**
 * 添加人才信息
 * @param userInfo 
 * @param param 
 * @returns 
 */
export async function addTeamTalent(userInfo, param) {
    const FuncName = "添加创业团队人才信息";
    eccFormParam(FuncName, CreateTeamConfig, param);
    eccEnumValue(FuncName, "degree", DEGREE, param.degree);
    eccEnumValue(FuncName, "talentType", RALENTTYPE, param.talentType);

    param.tId = generateSystemId(TABLENAME.创业团队, userInfo.userId);
    param.uploadTime = getMySqlMs();
    param.dataMonth = getMySqlMs(param.dataMonth);
    param.fileType = getFileType(param.fileName);
    param.fileName = JSON.stringify(param.fileName);
    
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.创业团队, param, {} );

    return {isSuccess:true};
}


export async function updateTeamTalentInfo() {
    
}









