"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getZhyy = void 0;
const moment = require("moment");
const enum_1 = require("../../config/enum");
const operationalData_1 = require("./operationalData");
const eccEnum_1 = require("../../tools/eccEnum");
async function getZhyy() {
    // let zhyy = {
    //     在孵企业数据:{dataList:[], titleList:['key', 'value']},
    //     入驻企业变化趋势:[],
    //     入驻企业行业类型:{dataList:[], titleList:['key', 'value']},
    //     孵化运营:{dataList:[], titleList:['key', 'value']},
    //     智慧运营汇总数据:{dataList:[], titleList:['key', 'value']},
    //     企业服务:{dataList:[], titleList:['key', 'value']},
    //     企业服务类型:{dataList:[], titleList:['key', 'value']},
    // };
    let fhColumn = ["industry", "eId"];
    //获取所有企业孵化信息
    let manyTableInfo = {};
    manyTableInfo[enum_1.TABLENAME.企业孵化信息] = { column: ["fId", "eId", "startTime", "endTime", "state"], where: { state: enum_1.FUHUASTATE.实体孵化 } };
    manyTableInfo[enum_1.TABLENAME.租赁信息] = { column: ["area"], where: {} };
    let fhdbList = await operationalData_1.selectManyTableData(enum_1.OPERATIONALDATATYPE.多表联查, enum_1.TABLENAME.企业基础信息表, {}, fhColumn, manyTableInfo);
    //入驻企业变化趋势
    let industryMap = {};
    let ruZhuMap = {};
    let ruZhuCount = 0;
    let areaCount = 0;
    let enterpriseCount = 0;
    let firstDayMsOfMonth = moment().startOf('month').valueOf();
    let checlTimeMs = moment(firstDayMsOfMonth).subtract(8, 'months').valueOf();
    fhdbList.forEach(info => {
        let { industry, enterprise_fuhuas, enterprise_leases } = info;
        let startTime = enterprise_fuhuas[0].startTime;
        if (!startTime)
            return;
        let startTimeMs = new Date(startTime).valueOf();
        if (startTimeMs >= checlTimeMs) {
            let timeStr = moment(startTime).format("YY/MM");
            if (!ruZhuMap[timeStr])
                ruZhuMap[timeStr] = 0;
            ruZhuMap[timeStr] += 1;
            ruZhuCount += 1;
        }
        //行业领域分布
        if (industry) {
            let industryStr = eccEnum_1.changeEnumValue(enum_1.INDUSTRY, JSON.parse(industry)[0]);
            if (!industryMap[industryStr])
                industryMap[industryStr] = 0;
            industryMap[industryStr] += 1;
        }
        let area = enterprise_leases[0].area || 0;
        if (area)
            areaCount += parseFloat(area);
        enterpriseCount += 1;
    });
    let 入驻企业变化趋势 = [];
    for (let key in ruZhuMap) {
        入驻企业变化趋势.push({ key, value: ruZhuMap[key] });
    }
    入驻企业变化趋势.sort((a, b) => { return parseInt(a.key) - parseInt(b.key); });
    //行业领域
    let 行业领域 = [];
    for (let key in industryMap) {
        行业领域.push({ key, value: industryMap[key] });
    }
    let biYeOutCount = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询数据量, enum_1.TABLENAME.企业孵化信息, { state: enum_1.FUHUASTATE.迁出, moveOutType: enum_1.MOVEOUTTYPE.毕业迁出 }, null);
    let qianChuCount = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询数据量, enum_1.TABLENAME.企业孵化信息, { state: enum_1.FUHUASTATE.迁出 }, null);
    let rongZiList = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询多个, enum_1.TABLENAME.企业融资, {}, null);
    let rongZiMap = {};
    rongZiList.forEach(info => {
        let { eId } = info;
        if (!rongZiMap[eId])
            rongZiMap[eId] = 0;
        rongZiMap[eId] += 1;
    });
    let rongZiQiYeCount = Object.keys(rongZiMap).length;
    let fuWuCount = 0; //服务数
    let fuWuQiYeCountMap = {}; //服务覆盖企业
    let fuWuQiYeTypeMap = {}; //
    let fuWuList = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询多个, enum_1.TABLENAME.企业服务表, {}, null);
    // //添加日志输出以调试
    // console.log("fuWuList:", fuWuList);
    fuWuList.forEach(info => {
        let { followUpStatus, eId, needCategory } = info;
        // console.log(`Processing service record:`, info); // 记录每一条服务记录
        if (followUpStatus == enum_1.FOLLOWUPSTATUS.已完成) {
            fuWuCount += 1;
            if (!fuWuQiYeCountMap[eId]) {
                fuWuQiYeCountMap[eId] = 0;
            }
            fuWuQiYeCountMap[eId] += 1;
            // console.log(`Service count for enterprise ${eId} incremented to: ${fuWuQiYeCountMap[eId]}`); // 记录企业服务数变化
            let needCategoryStr = eccEnum_1.changeEnumValue(enum_1.NEEDCATEGORY, needCategory);
            // console.log(`Converted needCategory ${needCategory} to ${needCategoryStr}`); // 记录枚举值转换
            if (!fuWuQiYeTypeMap[needCategoryStr])
                fuWuQiYeTypeMap[needCategoryStr] = 0;
            fuWuQiYeTypeMap[needCategoryStr] += 1;
        }
    });
    let fuWuQiYeCount = Object.keys(fuWuQiYeCountMap).length; //服务覆盖企业
    // console.log("fuWuQiYeCountMap:", fuWuQiYeCountMap);
    // console.log("fuWuQiYeTypeMap:", fuWuQiYeTypeMap);
    let fuWuQiYeTypeList = [];
    // 遍历 NEEDCATEGORY 枚举
    const allNeedCategories = Object.values(enum_1.NEEDCATEGORY);
    allNeedCategories.forEach(category => {
        const categoryStr = eccEnum_1.changeEnumValue(enum_1.NEEDCATEGORY, category);
        if (fuWuQiYeTypeMap[categoryStr]) {
            // console.log(`Found category ${categoryStr}: ${fuWuQiYeTypeMap[categoryStr]}`);
            fuWuQiYeTypeList.push({
                key: categoryStr,
                value: fuWuQiYeTypeMap[categoryStr] || 0
            });
        }
    });
    // // 添加日志输出以调试
    // console.log("fuWuQiYeTypeList:", fuWuQiYeTypeList);
    let 在孵企业数据 = [
        { key: "在孵企业面积占比", value: "3%" },
        { key: "入驻", value: `${ruZhuCount}家` },
        { key: "迁出", value: `${qianChuCount}家` },
        { key: "到期退租", value: "3家" },
        { key: "违约退租", value: "10家" }
    ];
    let 孵化运营 = [
        { key: "孵化面积", value: `${areaCount}㎡` },
        { key: "在孵企业", value: `${ruZhuCount}家` },
        { key: "毕业企业", value: `${biYeOutCount}家` },
        { key: "融资企业", value: `${rongZiQiYeCount}家` },
    ];
    let 智慧运营汇总数据 = [
        { key: "配套服务", value: `3项` },
        { key: "第三方供应商", value: `3家` },
        { key: "累计服务企业", value: `${fuWuQiYeCount}次` },
    ];
    let 企业服务 = [
        { key: "服务数", value: fuWuCount },
        { key: "服务覆盖企业", value: fuWuQiYeCount },
    ];
    let zhyy = {
        在孵企业数据: { dataList: 在孵企业数据, titleList: ['key', 'value'] },
        入驻企业变化趋势: [{ name: "入驻企业变化趋势", data: 入驻企业变化趋势 }],
        入驻企业行业类型: { dataList: 行业领域, titleList: ['key', 'value'] },
        孵化运营: { dataList: 孵化运营, titleList: ['key', 'value'] },
        智慧运营汇总数据: { dataList: 智慧运营汇总数据, titleList: ['key', 'value'] },
        企业服务: { dataList: 企业服务, titleList: ['key', 'value'] },
        企业服务类型: { dataList: fuWuQiYeTypeList, titleList: ['key', 'value'] },
    };
    return zhyy;
}
exports.getZhyy = getZhyy;
//# sourceMappingURL=zhyy.js.map