"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectManyTableData = exports.selectData = exports.operationalData = void 0;
const enum_1 = require("../../config/enum");
const errorEnum_1 = require("../../config/errorEnum");
const serverConfig_1 = require("../../config/serverConfig");
const bizError_1 = require("../../util/bizError");
const request_1 = require("../../util/request");
/**
 * 操作数据库 新增  修改  删除
 * @param url url地址 根据枚举获取值
 * @param tableName 表名
 * @param data 数据
 * @param param 条件
 */
async function operationalData(url, tableName, data, param) {
    let header = { table: tableName, sign: serverConfig_1.systemConfig.sign };
    let queray = {};
    if (url == enum_1.OPERATIONALDATATYPE.增加) {
        queray.data = data;
    }
    else if (url == enum_1.OPERATIONALDATATYPE.修改) {
        queray.data = data;
        queray.param = param;
    }
    else if (url == enum_1.OPERATIONALDATATYPE.删除) {
        queray.param = param;
    }
    else {
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.该方法仅可进行数据操作, '使用操作数据库的方法进行查询调用');
    }
    let result = await request_1.post(`${serverConfig_1.systemConfig.dbPath}${url}`, queray, header);
    if (result.code != 200)
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.数据操作失败, result.code);
    if (!result.data || !result.data.isSuccess)
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.数据操作失败, JSON.stringify(result.data));
    return true;
}
exports.operationalData = operationalData;
/**
 * 查询
 * @param url url地址 根据枚举获取值
 * @param tableName 表名
 * @param param 条件
 * @param pageNumber 分页传入的页数  非分页可不传
 * @param pageSize 分页传入的单页大小  非分页可不传
 */
async function selectData(url, tableName, param, column, pageNumber, pageSize) {
    if (url != enum_1.OPERATIONALDATATYPE.查询单个 && url != enum_1.OPERATIONALDATATYPE.查询多个 && url != enum_1.OPERATIONALDATATYPE.查询数据量 && url != enum_1.OPERATIONALDATATYPE.分页查询) {
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.该方法仅可进行查询操作, '该方法仅可进行查询操作');
    }
    let header = { table: tableName, sign: serverConfig_1.systemConfig.sign };
    let queray = { param };
    if (column && column.length) {
        queray.column = column;
    }
    if (url == enum_1.OPERATIONALDATATYPE.分页查询) {
        if (!pageNumber)
            throw new bizError_1.BizError(errorEnum_1.ERRORENUM.分页请设置当前页数, `pageNumber:${pageNumber};pageSize:${pageSize}`);
        queray.pageNumber = pageNumber;
        queray.pageSize = pageSize || 10;
    }
    let result = await request_1.post(`${serverConfig_1.systemConfig.dbPath}${url}`, queray, header);
    if (result.code != 200)
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.数据查询失败, result.code);
    if (!result.data || result.data.data == null || result.data.data == undefined)
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.数据查询失败, JSON.stringify(result.data));
    return result.data.data;
}
exports.selectData = selectData;
/**
 * 多表联查
 * @param url
 * @param tableName
 * @param param
 * @param column
 * @param includeConf
 * @param pageNumber
 * @param pageSize
 * @returns
 */
async function selectManyTableData(url, tableName, param, column, includeConf, pageNumber, pageSize) {
    if (url != enum_1.OPERATIONALDATATYPE.多表联查 && url != enum_1.OPERATIONALDATATYPE.多表分页 && url != enum_1.OPERATIONALDATATYPE.多表单个) {
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.该方法仅可进行联合查询操作, '该方法仅可进行联合查询操作');
    }
    let header = { table: tableName, sign: serverConfig_1.systemConfig.sign };
    let queray = { param, includeConf };
    if (column && column.length) {
        queray.column = column;
    }
    if (url == enum_1.OPERATIONALDATATYPE.多表分页) {
        if (!pageNumber)
            throw new bizError_1.BizError(errorEnum_1.ERRORENUM.分页请设置当前页数, `pageNumber:${pageNumber};pageSize:${pageSize}`);
        queray.pageNumber = pageNumber;
        queray.pageSize = pageSize || 10;
    }
    let result = await request_1.post(`${serverConfig_1.systemConfig.dbPath}${url}`, queray, header);
    if (result.code != 200)
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.数据联合查询失败, result.code);
    if (!result.data || !result.data.data)
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.数据联合查询失败, JSON.stringify(result.data));
    return result.data.data;
}
exports.selectManyTableData = selectManyTableData;
//# sourceMappingURL=operationalData.js.map