"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interfaceAnalysis_1 = require("../../dataPackage/interfaceAnalysis");
const bizError_1 = require("../../util/bizError");
const cronJob_1 = require("./cronJob");
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);
        if ((type == "array" && !dataIsArray) || (type == "object" && dataIsArray) ||
            (type == "object" && fileType != "object") || (type != "array" && fileType != type)) {
            throw new bizError_1.BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }
        let onceData;
        switch (operationsType) {
            case "object_ToList":
                onceData = interfaceAnalysis_1.changeObjectToList(fileData, reflect);
                break;
            case "object_changeKey":
                onceData = interfaceAnalysis_1.changeObjectKey(fileData, reflect);
                break;
            case "list_changeKey":
                onceData = interfaceAnalysis_1.changeListObjectToListByReflect(fileData, reflect);
                break;
        }
        if (unitInfo)
            onceData = interfaceAnalysis_1.designativListKeyAddUnit(onceData, unitInfo);
        result[dataName] = onceData;
    }
    return result;
}
function wmkqyszhxInterfaceData() {
    let wmkqyszhxinterfaceName = "维迈科企业数字画像";
    let wmkqyszhxData = cronJob_1.getInterfaceByInterfaceName(wmkqyszhxinterfaceName);
    /*
     qyjbqk = 企业基本情况 ;
     qyjbsj = 企业基本数据 ;
     qybq = 企业标签 ;
     zscq = 知识产权 ;
     qyyghx = 企业员工画像 ;
     lnrczpqkzprs = 历年人才招聘情况招聘人数 ;
     qyhzsj = 企业汇总数据 ;
     xjr = 小巨人 ;
     gxqy = 高新企业 ;
     zjtx = 专精特新 ;
     ysqk = 营收情况 ;
     ysbhqsyysr = 营收变化趋势营业收入 ;
     ysbhqsyftr = 营收变化趋势研发投入 ;
     ysbhqsnsje = 营收变化趋势纳税金额 ;
     qydt = 企业动态 ;
     fwxq = 服务需求 ;
     hdbhqsfxrze = 活动变化趋势分析融资额 ;
     hdbhqsfxrzsj = 活动变化趋势分析融资事件 ;
     fwjl-kjfw = 服务记录-空间服务 ;
     fwjl-gsfw = 服务记录-工商服务 ;
     fwjl-rzfw = 服务记录-融资服务 ;
     fwjl = 服务记录 ;
     yqtz = 园区通知 ;
     yqtzxq = 园区通知详情 ;
     yqhd = 园区活动 ;
     yqhdmx = 园区活动明细 ;
    
    */
    let config = { "qyjbqk": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qyjbsj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qybq": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "zscq": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qyyghx": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "lnrczpqkzprs": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyhzsj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "xjr": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "gxqy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "zjtx": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "ysqk": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "ysbhqsyysr": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "ysbhqsyftr": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "ysbhqsnsje": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qydt": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "fwxq": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "hdbhqsfxrze": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "hdbhqsfxrzsj": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "fwjl-kjfw": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "fwjl-gsfw": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "fwjl-rzfw": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "fwjl": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "yqtz": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "yqtzxq": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "yqhd": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "yqhdmx": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} } };
    let interfaceData = Object.assign({}, wmkqyszhxData);
    let changeData = changeDataProcess('维迈科企业数字画像', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了
}
//# sourceMappingURL=wmkqyszhxData.js.map