"use strict";
/**
 * 企业服务
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnterprise = void 0;
const enum_1 = require("../../config/enum");
const operationalData_1 = require("./operationalData");
async function getEnterprise() {
    let qyfw = {
        qyjbqk: { dataList: [], titleList: ['key', 'value'] },
        bhqsfx: [],
        rfscfb: { dataList: [], titleList: ['key', 'value'] },
        fhqyhylyzb: { dataList: [], titleList: ['key', 'value'] },
        qyrc: [],
    };
    let nowTime = new Date().valueOf();
    let selectParam = { "endTime": { "%gt%": nowTime } };
    let zlColumn = ["eId", "area", "unitPrice", "isDeposit", "startTime", "endTime", "rentFreeStart", "rentFreeEnd", "roomNumber",
        "rent", "notes", "leaseContract", "entryPlan", "businessLicense", "agreement"];
    /**在孵：获取租赁结束时间大于当前时间的租赁信息 */
    let zldbList = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询多个, enum_1.TABLENAME.租赁信息, selectParam, zlColumn);
    let qyjbqk = {
        "孵化面积": 0,
        "在孵企业": 0,
        "毕业企业": 0
    };
    zldbList.forEach(item => {
        qyjbqk.孵化面积 += parseInt(item.area);
    });
    let fhColumn = ["fId", "eId", "startTime", "endTime", "state", "virtualCause", "virtualCauseDes", "moveOutType",
        "moveOutTrace", "moveOutCause", "moveOutTime", "graduationTime"];
    //获取所有企业孵化信息
    let fhdbList = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询多个, enum_1.TABLENAME.企业孵化信息, {}, fhColumn);
    //获取在孵企业
    let 在孵dbList = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询多个, enum_1.TABLENAME.企业孵化信息, { "endTime": { "%gt%": nowTime } }, fhColumn);
    //获取毕业企业
    let 毕业dbList = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询多个, enum_1.TABLENAME.企业孵化信息, { "moveOutType": enum_1.MOVEOUTTYPE.毕业迁出 }, fhColumn);
    //获取所有企业孵化表联查企业信息表
    let 孵化企业includeConf = {};
    let 孵化企业Clumn = ["enterpriseName", "industry"];
    孵化企业includeConf[enum_1.TABLENAME.企业基础信息表] = { cloum: 孵化企业Clumn, where: {} };
    let 孵化企业dbList = await operationalData_1.selectManyTableData(enum_1.OPERATIONALDATATYPE.多表联查, enum_1.TABLENAME.企业孵化信息, {}, fhColumn, 孵化企业includeConf);
    qyjbqk.在孵企业 = 在孵dbList.length;
    qyjbqk.毕业企业 = 毕业dbList.length;
    qyfw.qyjbqk.dataList = getKeyValue(qyjbqk);
    let bhqsfx = {
        "在孵": [],
        "毕业": []
    };
    //todo 变化趋势分析 需要日志表
    bhqsfx["在孵"] = [
        { key: "2019", value: 4 },
        { key: "2020", value: 4 },
    ];
    bhqsfx["毕业"] = [
        { key: "2019", value: 4 },
        { key: "2020", value: 4 },
    ];
    fhdbList.forEach(item => {
    });
    //入孵时长分布
    // let rfscfb = getRfscfx(fhdbList);
    //孵化企业行业领域占比
    for (let key in enum_1.INDUSTRY) {
        let anyKey = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let industry = enum_1.INDUSTRY[key];
            let count = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询数据量, enum_1.TABLENAME.企业基础信息表, { industry }, null);
            qyfw.fhqyhylyzb.dataList.push({ key: keyStr, value: count });
        }
    }
    let year = ["2019", "2020", "2021", "2022", "2023", "2024"];
    let qyrc = {
        "就业人数": [],
        "创业团队分布": []
    };
    for (let i = 0; i < year.length; i++) {
        let dbData = await operationalData_1.selectData(enum_1.OPERATIONALDATATYPE.查询多个, enum_1.TABLENAME.参保记录, { annual: year[i] }, null);
        let count = 0;
        dbData.forEach(info => {
            let { zhuanKe, benKe, yanJiuSheng, boShi, qiTa } = info;
            count += zhuanKe;
            count += benKe;
            count += yanJiuSheng;
            count += boShi;
            count += qiTa;
        });
        qyrc["就业人数"].push({ key: year[i], value: count });
    }
    return qyfw;
}
exports.getEnterprise = getEnterprise;
/**
 * 入孵时长分布
 * @param data
 */
function getRfscfx(data) {
    let nowTime = new Date().valueOf();
    let result = [];
    let rfscfx = {
        "即将到期": 0,
        "1年以内": 0,
        "1-2年": 0,
        "2-3年": 0,
        "3-4年": 0
    };
    data.forEach(item => {
        let endTimeYear = item.endTime.getFullYear();
        let endTimeMonth = item.endTime.getMonth();
        if (item.endTime) { }
    });
}
function getKeyValue(data) {
    let result = [];
    for (let key in data) {
        result.push({ key, value: data[key] });
    }
    return result;
}
//# sourceMappingURL=qyfw.js.map