import moment = require("moment");

export function getKeyValue(data) {
    let result = [];
    for (let key in data) {
        result.push({key, value:data[key]});
    }

    return result;
}


export function getChart(data) {
    let result = [];
    for(let key in data) {
        result.push({name:key, data:data[key]})
    }

    return result;
}


export function getMonthList() {
    // 获取当前时间
    const currentTime = moment();
    
    // 获取6个月前的时间
    const sixMonthsAgo = currentTime.clone().subtract(6, 'months');
    
    // 创建一个数组来存储每个月份的第一天
    const monthsArray = [];
    
    // 使用moment的range函数（如果可用）或者手动循环来遍历月份
    // 注意：moment.js的官方库中并没有直接的range函数用于月份遍历，
    // 但我们可以使用.month()和.date(1)结合循环来实现。
    
    // 由于moment没有内置的range函数用于月份，我们需要手动处理
    let currentMonth = sixMonthsAgo.clone();
    while (currentMonth.isBefore(currentTime) || currentMonth.isSame(currentTime, 'month')) {
        // 获取当前循环月份的第一天
        const firstDayOfMonth = currentMonth.clone().date(1);
        
        // 将月份添加到数组中
        monthsArray.push(moment(firstDayOfMonth.clone().toDate()).format("YY/MM")); // 如果你需要Date对象
        // monthsArray.push(firstDayOfMonth.format('YYYY-MM-DD')); // 如果你需要格式化字符串
        
        // 移动到下一个月
        currentMonth.add(1, 'months');
    }

    return monthsArray;
}


export function getYearList() {
    // 获取当前年份
    const currentTime = moment();
    const sixMonthsAgo = currentTime.clone().subtract(6, 'year');
    const currentYear = new Date().getFullYear();
    
    // 初始化一个空数组来存储年份
    const years = [];
    
    // 使用一个循环来添加当前年份到6年后的每一个年份到数组中
    for (let i = 0; i <= 6; i++) {
        years.push(currentYear - i);
    }

    years.sort((a, b) => {
        return a - b;
    })

    return years;
}
