
import { systemConfig } from '../config/serverConfig';
import { getZhyy } from '../data/db/zhyy';
import { zhyyTableData } from '../data/table/zhyyData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../dataPackage/out';

/*                            智慧运营                    */

export async function getData(req, res) {
    let excelData = zhyyTableData();
    let dbData = await getZhyy();
    
    let ret:any = {};

    let yqgkPackageData = keyValuePackage(dbData['园区概况'].dataList);
    ret['yqgk'] = getKeyValueOut('园区概况', yqgkPackageData);

    let zfqysjPackageData = keyValuePackage(dbData['在孵企业数据'].dataList);
    ret['zfqysj'] = getKeyValueOut('在孵企业数据', zfqysjPackageData);
                    
    let rzqybhqsPackageData = onceYBarChartPackage( dbData['入驻企业变化趋势'], '','');
    ret['rzqybhqs'] = getOnceYBarChartOut('入驻企业变化趋势', rzqybhqsPackageData);
                    
    let rzqyhylxPackageData = keyValuePackage(dbData['入驻企业行业类型'].dataList);
    ret['rzqyhylx'] = getKeyValueOut('入驻企业行业类型', rzqyhylxPackageData);
                    
    let fhyyPackageData = keyValuePackage(dbData['孵化运营'].dataList);
    ret['fhyy'] = getKeyValueOut('孵化运营', fhyyPackageData);
                    
    let fhmjbhqsPackageData = onceYBarChartPackage( dbData['孵化面积变化趋势'], '','');
    ret['fhmjbhqs'] = getOnceYBarChartOut('孵化面积变化趋势', fhmjbhqsPackageData);
                    
    // let zfqybhqsPackageData = onceYBarChartPackage( excelData['在孵企业变化趋势'], '','');
    let zfqybhqsPackageData = onceYBarChartPackage( dbData["在孵企业变化趋势"], '','');
    ret['zfqybhqs'] = getOnceYBarChartOut('在孵企业变化趋势', zfqybhqsPackageData);
                    
    let byqybhqsPackageData = onceYBarChartPackage( excelData['毕业企业变化趋势'], '','');
    ret['byqybhqs'] = getOnceYBarChartOut('毕业企业变化趋势', byqybhqsPackageData);
                    
    let rzqyPackageData = onceYBarChartPackage( dbData['融资企业变化趋势'], '','');
    ret['rzqy'] = getOnceYBarChartOut('融资企业变化趋势', rzqyPackageData);
                    
    let ryzzPackageData = keyValuePackage(dbData['荣誉资质'].dataList);
    ret['ryzz'] = getKeyValueOut('荣誉资质', ryzzPackageData);
                    
    let zhyyhzsjPackageData = keyValuePackage(dbData['智慧运营汇总数据'].dataList);
    ret['zhyyhzsj'] = getKeyValueOut('智慧运营汇总数据', zhyyhzsjPackageData);
                    
    let dtTableData = tablePackage(excelData["地图"].headerList[0], excelData["地图"].bodyList);
    let dt = {dataList:[], titleList:dtTableData.titleList};
    dtTableData.dataList.forEach(info => {
        let {D} = info;
        let imgUrl = `${systemConfig.imgPath}/${D}`;
        info["D"] = imgUrl;
        dt.dataList.push(info);
    })
    ret['dt'] = getTableOut( '地图', dt);
                    
    let jyfxPackageData = keyValuePackage(excelData['就业分析'].dataList);
    ret['jyfx'] = getKeyValueOut('就业分析', jyfxPackageData);
                    
    let jdjyrsqsfxPackageData = onceYBarChartPackage( dbData['年度就业人数趋势分析'], '','');
    ret['jdjyrsqsfx'] = getOnceYBarChartOut('年度就业人数趋势分析', jdjyrsqsfxPackageData);
                    
    let cygmfxPackageData = keyValuePackage(excelData['产业规模分析'].dataList);
    ret['cygmfx'] = getKeyValueOut('产业规模分析', cygmfxPackageData);
                    
    let zfqyyszbPackageData = keyValuePackage(dbData['在孵企业营收占比'].dataList);
    ret['zfqyyszb'] = getKeyValueOut('在孵企业营收占比', zfqyyszbPackageData);
                    
    let qyfwPackageData = keyValuePackage(dbData['企业服务'].dataList);
    ret['qyfw'] = getKeyValueOut('企业服务', qyfwPackageData);
                    
    let qyfwlxPackageData = keyValuePackage(dbData['企业服务类型'].dataList);
    ret['qyfwlx'] = getKeyValueOut('企业服务类型', qyfwlxPackageData);
                    
    let fwzlTableData = tablePackage(excelData["服务质量"].headerList[0], excelData["服务质量"].bodyList);//todo111
    ret['fwzl'] = getTableOut( '服务质量', fwzlTableData);
                    
    let yysrqsPackageData = onceYBarChartPackage( excelData['运营收入趋势'], '','');
    ret['yysrqs'] = getOnceYBarChartOut('运营收入趋势', yysrqsPackageData);
                    
    let cyzcPackageData = keyValuePackage(excelData['产业政策'].dataList);
    ret['cyzc'] = getKeyValueOut('产业政策', cyzcPackageData);
                    
    let cyzcxxPackageData = keyValuePackage(excelData['产业政策详细'].dataList);
    ret['cyzcxx'] = getKeyValueOut('产业政策详细', cyzcxxPackageData);
                    
    let yqhdPackageData = keyValuePackage(excelData['园区活动'].dataList);
    let yqhd = [];
    yqhdPackageData.forEach( info => {
        let {key, value} = info;
        info.value = `${systemConfig.imgPath}/${value}`;
        yqhd.push(info);
    })
    ret['yqhd'] = getKeyValueOut('园区活动', yqhd);
                    
    let yqxwPackageData = keyValuePackage(excelData['园区新闻'].dataList);
    let yqxw = [];
    yqxwPackageData.forEach( info => {
        let {key, value} = info;
        info.value = `${systemConfig.imgPath}/${value}`;
        yqxw.push(info);
    })
    ret['yqxw'] = getKeyValueOut('园区新闻', yqxw);
                     
    res.send(ret);
} 