
import { qyszhxTableData } from '../data/table/qyszhxData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, stringListPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getStringOut, getTableOut } from '../dataPackage/out';
import { systemConfig } from '../config/serverConfig';
import { getQyszhx } from '../data/db/qyszhx';

/*                            企业数字画像                    */

export async function getData(req, res) {
    let eId = req.body.eId;

    let dbData = await getQyszhx(eId);
    let excelData = qyszhxTableData();

    let ret:any = {};

    let qyjbqkPackageData = keyValuePackage(dbData['企业基本情况'].dataList);
    let qyjbqk = [];
    qyjbqkPackageData.forEach( info => {
        let {key, value} = info;
        if (key == "企业图片") {
            info.value = `${systemConfig.imgPath}/${value}`;
        }
        qyjbqk.push(info);
    })
    ret['qyjbqk'] = getKeyValueOut('企业基本情况', qyjbqk);
    
    let qyjbsjPackageData = keyValuePackage(dbData['企业基本数据'].dataList, "false");
    ret['qyjbsj'] = getKeyValueOut('企业基本数据', qyjbsjPackageData);
                    
    let qybqPackageData = stringListPackage(dbData['企业标签'].dataList);
    ret['qybq'] = getStringOut('企业标签', qybqPackageData);
                    
    let zscqPackageData = keyValuePackage(dbData['知识产权'].dataList);
    ret['zscq'] = getKeyValueOut('知识产权', zscqPackageData);

    let qyyghxPackageData = keyValuePackage(dbData['企业员工画像'].dataList);
    ret['qyyghx'] = getKeyValueOut('企业员工画像', qyyghxPackageData);

    let lnrczpqkPackageData = onceYBarChartPackage( excelData['历年人才招聘情况'], '','');
    ret['lnrczpqk'] = getOnceYBarChartOut('历年人才招聘情况', lnrczpqkPackageData);
    
    let qyhzsjPackageData = keyValuePackage(dbData['企业汇总数据'].dataList);
    ret['qyhzsj'] = getKeyValueOut('企业汇总数据', qyhzsjPackageData);
    
    let xjrTableData = tablePackage(excelData["小巨人"].headerList[0], excelData["小巨人"].bodyList);
    ret['xjr'] = getTableOut( '小巨人', xjrTableData);
    
    let gxqyTableData = tablePackage(excelData["高新企业"].headerList[0], excelData["高新企业"].bodyList);
    ret['gxqy'] = getTableOut( '高新企业', gxqyTableData);
                    
    let zjtxTableData = tablePackage(excelData["专精特新"].headerList[0], excelData["专精特新"].bodyList);
    ret['zjtx'] = getTableOut( '专精特新', zjtxTableData);
                    
    let ysqkPackageData = keyValuePackage(dbData['营收情况'].dataList);
    ret['ysqk'] = getKeyValueOut('营收情况', ysqkPackageData);
                    
    let ysbhqsPackageData = onceYBarChartPackage( dbData['营收变化趋势'], '','');
    ret['ysbhqs'] = getOnceYBarChartOut('营收变化趋势', ysbhqsPackageData);
                    
    let qydtTableData = tablePackage(dbData["企业动态"].headerList[0], dbData["企业动态"].bodyList);
    // let qydt = {dataList:[], titleList:qydtTableData.titleList};
    // qydtTableData.dataList.forEach(info => {
    //     let {A} = info;
    //     let imgUrl = ;
    //     info["A"] = imgUrl;
    //     qydt.dataList.push(info);
    // })
    ret['qydt'] = getTableOut( '企业动态', qydtTableData);
                    
    let fwxqPackageData = keyValuePackage(dbData['服务需求'].dataList, "false");
    ret['fwxq'] = getKeyValueOut('服务需求', fwxqPackageData);
                    
    let hdbhqsfxPackageData = onceYBarChartPackage( dbData['活动变化趋势分析'], '','');
    ret['hdbhqsfx'] = getOnceYBarChartOut('活动变化趋势分析', hdbhqsfxPackageData);
                    
    let fwjl_kjfwTableData = tablePackage(dbData["服务记录_空间服务"].headerList[0], dbData["服务记录_空间服务"].bodyList);
    ret['fwjl_kjfw'] = getTableOut( '服务记录_空间服务', fwjl_kjfwTableData);
                    
    let fwjl_gsfwTableData = tablePackage(dbData["服务记录_工商服务"].headerList[0], dbData["服务记录_工商服务"].bodyList);
    ret['fwjl_gsfw'] = getTableOut( '服务记录_工商服务', fwjl_gsfwTableData);
                    
    let fwjl_rzfwTableData = tablePackage(dbData["服务记录_融资服务"].headerList[0], dbData["服务记录_融资服务"].bodyList);
    ret['fwjl_rzfw'] = getTableOut( '服务记录_融资服务', fwjl_rzfwTableData);
                    
    let fwjlPackageData = keyValuePackage(dbData['服务记录'].dataList);
    ret['fwjl'] = getKeyValueOut('服务记录', fwjlPackageData);
                    
    let yqtzPackageData = keyValuePackage(excelData['园区通知'].dataList);
    ret['yqtz'] = getKeyValueOut('园区通知', yqtzPackageData);
                    
    let yqtzxqTableData = tablePackage(excelData["园区通知详情"].headerList[0], excelData["园区通知详情"].bodyList);
    let yqtzxq = {dataList:[], titleList:yqtzxqTableData.titleList};
    yqtzxqTableData.dataList.forEach(info => {
        let {A} = info;
        let imgUrl = `${systemConfig.imgPath}/${A}`;
        info["A"] = imgUrl;
        yqtzxq.dataList.push(info);
    })
    ret['yqtzxq'] = getTableOut( '园区通知详情', yqtzxq);
                    
    let yqhdPackageData = keyValuePackage(excelData['园区活动'].dataList);
    ret['yqhd'] = getKeyValueOut('园区活动', yqhdPackageData);
                    
    let yqhdmxTableData = tablePackage(excelData["园区活动明细"].headerList[0], excelData["园区活动明细"].bodyList);
    ret['yqhdmx'] = getTableOut( '园区活动明细', yqhdmxTableData);
                     
    res.send(ret);
}



export async function getData备份(req, res) {
    let eId = req.body.eId;

    let excelData = qyszhxTableData();

    let ret:any = {};

    let qyjbqkPackageData = keyValuePackage(excelData['企业基本情况'].dataList);
    let qyjbqk = [];
    qyjbqkPackageData.forEach( info => {
        let {key, value} = info;
        if (key == "企业图片") {
            info.value = `${systemConfig.imgPath}/${value}`;
        }
        qyjbqk.push(info);
    })
    ret['qyjbqk'] = getKeyValueOut('企业基本情况', qyjbqk);
                    
    let qyjbsjPackageData = keyValuePackage(excelData['企业基本数据'].dataList, "false");
    ret['qyjbsj'] = getKeyValueOut('企业基本数据', qyjbsjPackageData);
                    
    let qybqPackageData = stringListPackage(excelData['企业标签'].dataList);
    ret['qybq'] = getStringOut('企业标签', qybqPackageData);
                    
    let zscqPackageData = keyValuePackage(excelData['知识产权'].dataList);
    ret['zscq'] = getKeyValueOut('知识产权', zscqPackageData);
                    
    let qyyghxPackageData = keyValuePackage(excelData['企业员工画像'].dataList);
    ret['qyyghx'] = getKeyValueOut('企业员工画像', qyyghxPackageData);
                    
    let lnrczpqkPackageData = onceYBarChartPackage( excelData['历年人才招聘情况'], '','');
    ret['lnrczpqk'] = getOnceYBarChartOut('历年人才招聘情况', lnrczpqkPackageData);
                    
    let qyhzsjPackageData = keyValuePackage(excelData['企业汇总数据'].dataList);
    ret['qyhzsj'] = getKeyValueOut('企业汇总数据', qyhzsjPackageData);
                    
    let xjrTableData = tablePackage(excelData["小巨人"].headerList[0], excelData["小巨人"].bodyList);
    ret['xjr'] = getTableOut( '小巨人', xjrTableData);
                    
    let gxqyTableData = tablePackage(excelData["高新企业"].headerList[0], excelData["高新企业"].bodyList);
    ret['gxqy'] = getTableOut( '高新企业', gxqyTableData);
                    
    let zjtxTableData = tablePackage(excelData["专精特新"].headerList[0], excelData["专精特新"].bodyList);
    ret['zjtx'] = getTableOut( '专精特新', zjtxTableData);
                    
    let ysqkPackageData = keyValuePackage(excelData['营收情况'].dataList);
    ret['ysqk'] = getKeyValueOut('营收情况', ysqkPackageData);
                    
    let ysbhqsPackageData = onceYBarChartPackage( excelData['营收变化趋势'], '','');
    ret['ysbhqs'] = getOnceYBarChartOut('营收变化趋势', ysbhqsPackageData);
                    
    let qydtTableData = tablePackage(excelData["企业动态"].headerList[0], excelData["企业动态"].bodyList);
    let qydt = {dataList:[], titleList:qydtTableData.titleList};
    qydtTableData.dataList.forEach(info => {
        let {A} = info;
        let imgUrl = `${systemConfig.imgPath}/${A}`;
        info["A"] = imgUrl;
        qydt.dataList.push(info);
    })
    ret['qydt'] = getTableOut( '企业动态', qydt);
                    
    let fwxqPackageData = keyValuePackage(excelData['服务需求'].dataList, "false");
    ret['fwxq'] = getKeyValueOut('服务需求', fwxqPackageData);
                    
    let hdbhqsfxPackageData = onceYBarChartPackage( excelData['活动变化趋势分析'], '','');
    ret['hdbhqsfx'] = getOnceYBarChartOut('活动变化趋势分析', hdbhqsfxPackageData);
                    
    let fwjl_kjfwTableData = tablePackage(excelData["服务记录_空间服务"].headerList[0], excelData["服务记录_空间服务"].bodyList);
    ret['fwjl_kjfw'] = getTableOut( '服务记录_空间服务', fwjl_kjfwTableData);
                    
    let fwjl_gsfwTableData = tablePackage(excelData["服务记录_工商服务"].headerList[0], excelData["服务记录_工商服务"].bodyList);
    ret['fwjl_gsfw'] = getTableOut( '服务记录_工商服务', fwjl_gsfwTableData);
                    
    let fwjl_rzfwTableData = tablePackage(excelData["服务记录_融资服务"].headerList[0], excelData["服务记录_融资服务"].bodyList);
    ret['fwjl_rzfw'] = getTableOut( '服务记录_融资服务', fwjl_rzfwTableData);
                    
    let fwjlPackageData = keyValuePackage(excelData['服务记录'].dataList);
    ret['fwjl'] = getKeyValueOut('服务记录', fwjlPackageData);
                    
    let yqtzPackageData = keyValuePackage(excelData['园区通知'].dataList);
    ret['yqtz'] = getKeyValueOut('园区通知', yqtzPackageData);
                    
    let yqtzxqTableData = tablePackage(excelData["园区通知详情"].headerList[0], excelData["园区通知详情"].bodyList);
    let yqtzxq = {dataList:[], titleList:yqtzxqTableData.titleList};
    yqtzxqTableData.dataList.forEach(info => {
        let {A} = info;
        let imgUrl = `${systemConfig.imgPath}/${A}`;
        info["A"] = imgUrl;
        yqtzxq.dataList.push(info);
    })
    ret['yqtzxq'] = getTableOut( '园区通知详情', yqtzxq);
                    
    let yqhdPackageData = keyValuePackage(excelData['园区活动'].dataList);
    ret['yqhd'] = getKeyValueOut('园区活动', yqhdPackageData);
                    
    let yqhdmxTableData = tablePackage(excelData["园区活动明细"].headerList[0], excelData["园区活动明细"].bodyList);
    ret['yqhdmx'] = getTableOut( '园区活动明细', yqhdmxTableData);
                     
    res.send(ret);
}