"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initConfig = exports.systemConfig = void 0;
const path = require('path');
const fs = require("fs");
const bizError_1 = require("../util/bizError");
const myXML_1 = require("../util/myXML");
const systemClass_1 = require("../config/systemClass");
exports.systemConfig = new systemClass_1.ServerConfig;
const ConfigName = "serverConfig.xml";
async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0, __dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo = await myXML_1.analysisXml(configStr);
        if (!configInfo || !configInfo.config)
            throw new bizError_1.BizError('xml中无配置');
        else {
            let { port, dbHost, dbPort, sign, imgPath } = configInfo.config;
            exports.systemConfig.port = parseInt(port[0]);
            exports.systemConfig.dbPath = analysisDBPathStr(dbHost[0], dbPort[0]);
            exports.systemConfig.sign = sign[0];
            exports.systemConfig.imgPath = imgPath[0];
        }
        console.log("config init success");
    }
    catch (err) {
        console.log('ERROR => 服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确');
        console.log(err);
        throw new bizError_1.BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}
exports.initConfig = initConfig;
function analysisDBPathStr(host, port) {
    let str = `http://${host}:${port}`;
    console.log("请确认，数据中心地址:", str);
    return str;
}
//# sourceMappingURL=serverConfig.js.map