"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const serverConfig_1 = require("../config/serverConfig");
const zhyy_1 = require("../data/db/zhyy");
const zhyyData_1 = require("../data/table/zhyyData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
/*                            智慧运营                    */
async function getData(req, res) {
    let excelData = zhyyData_1.zhyyTableData();
    let dbData = await zhyy_1.getZhyy();
    for (let key in dbData) {
        excelData[key] = dbData[key];
    }
    let ret = {};
    let yqgkPackageData = inFrontOut_1.keyValuePackage(excelData['园区概况'].dataList);
    ret['yqgk'] = out_1.getKeyValueOut('园区概况', yqgkPackageData);
    let zfqysjPackageData = inFrontOut_1.keyValuePackage(excelData['在孵企业数据'].dataList);
    ret['zfqysj'] = out_1.getKeyValueOut('在孵企业数据', zfqysjPackageData);
    let rzqybhqsPackageData = inFrontOut_1.onceYBarChartPackage(excelData['入驻企业变化趋势'], '', '');
    ret['rzqybhqs'] = out_1.getOnceYBarChartOut('入驻企业变化趋势', rzqybhqsPackageData);
    let rzqyhylxPackageData = inFrontOut_1.keyValuePackage(excelData['入驻企业行业类型'].dataList);
    ret['rzqyhylx'] = out_1.getKeyValueOut('入驻企业行业类型', rzqyhylxPackageData);
    let fhyyPackageData = inFrontOut_1.keyValuePackage(excelData['孵化运营'].dataList);
    ret['fhyy'] = out_1.getKeyValueOut('孵化运营', fhyyPackageData);
    let fhmjbhqsPackageData = inFrontOut_1.onceYBarChartPackage(excelData['孵化面积变化趋势'], '', '');
    ret['fhmjbhqs'] = out_1.getOnceYBarChartOut('孵化面积变化趋势', fhmjbhqsPackageData);
    let zfqybhqsPackageData = inFrontOut_1.onceYBarChartPackage(excelData['在孵企业变化趋势'], '', '');
    ret['zfqybhqs'] = out_1.getOnceYBarChartOut('在孵企业变化趋势', zfqybhqsPackageData);
    let byqybhqsPackageData = inFrontOut_1.onceYBarChartPackage(excelData['毕业企业变化趋势'], '', '');
    ret['byqybhqs'] = out_1.getOnceYBarChartOut('毕业企业变化趋势', byqybhqsPackageData);
    let rzqyPackageData = inFrontOut_1.onceYBarChartPackage(excelData['融资企业变化趋势'], '', '');
    ret['rzqy'] = out_1.getOnceYBarChartOut('融资企业变化趋势', rzqyPackageData);
    let ryzzPackageData = inFrontOut_1.keyValuePackage(excelData['荣誉资质'].dataList);
    ret['ryzz'] = out_1.getKeyValueOut('荣誉资质', ryzzPackageData);
    let zhyyhzsjPackageData = inFrontOut_1.keyValuePackage(excelData['智慧运营汇总数据'].dataList);
    ret['zhyyhzsj'] = out_1.getKeyValueOut('智慧运营汇总数据', zhyyhzsjPackageData);
    let dtTableData = inFrontOut_1.tablePackage(excelData["地图"].headerList[0], excelData["地图"].bodyList);
    let dt = { dataList: [], titleList: dtTableData.titleList };
    dtTableData.dataList.forEach(info => {
        let { D } = info;
        let imgUrl = `${serverConfig_1.systemConfig.imgPath}/${D}`;
        info["D"] = imgUrl;
        dt.dataList.push(info);
    });
    ret['dt'] = out_1.getTableOut('地图', dt);
    let jyfxPackageData = inFrontOut_1.keyValuePackage(excelData['就业分析'].dataList);
    ret['jyfx'] = out_1.getKeyValueOut('就业分析', jyfxPackageData);
    let jdjyrsqsfxPackageData = inFrontOut_1.onceYBarChartPackage(excelData['季度就业人数趋势分析'], '', '');
    ret['jdjyrsqsfx'] = out_1.getOnceYBarChartOut('季度就业人数趋势分析', jdjyrsqsfxPackageData);
    let cygmfxPackageData = inFrontOut_1.keyValuePackage(excelData['产业规模分析'].dataList);
    ret['cygmfx'] = out_1.getKeyValueOut('产业规模分析', cygmfxPackageData);
    let zfqyyszbPackageData = inFrontOut_1.keyValuePackage(excelData['在孵企业营收占比'].dataList);
    ret['zfqyyszb'] = out_1.getKeyValueOut('在孵企业营收占比', zfqyyszbPackageData);
    let qyfwPackageData = inFrontOut_1.keyValuePackage(excelData['企业服务'].dataList);
    ret['qyfw'] = out_1.getKeyValueOut('企业服务', qyfwPackageData);
    let qyfwlxPackageData = inFrontOut_1.keyValuePackage(excelData['企业服务类型'].dataList);
    ret['qyfwlx'] = out_1.getKeyValueOut('企业服务类型', qyfwlxPackageData);
    let fwzlTableData = inFrontOut_1.tablePackage(excelData["服务质量"].headerList[0], excelData["服务质量"].bodyList);
    ret['fwzl'] = out_1.getTableOut('服务质量', fwzlTableData);
    let yysrqsPackageData = inFrontOut_1.onceYBarChartPackage(excelData['运营收入趋势'], '', '');
    ret['yysrqs'] = out_1.getOnceYBarChartOut('运营收入趋势', yysrqsPackageData);
    let cyzcPackageData = inFrontOut_1.keyValuePackage(excelData['产业政策'].dataList);
    ret['cyzc'] = out_1.getKeyValueOut('产业政策', cyzcPackageData);
    let cyzcxxPackageData = inFrontOut_1.keyValuePackage(excelData['产业政策详细'].dataList);
    ret['cyzcxx'] = out_1.getKeyValueOut('产业政策详细', cyzcxxPackageData);
    let yqhdPackageData = inFrontOut_1.keyValuePackage(excelData['园区活动'].dataList);
    let yqhd = [];
    yqhdPackageData.forEach(info => {
        let { key, value } = info;
        info.value = `${serverConfig_1.systemConfig.imgPath}/${value}`;
        yqhd.push(info);
    });
    ret['yqhd'] = out_1.getKeyValueOut('园区活动', yqhd);
    let yqxwPackageData = inFrontOut_1.keyValuePackage(excelData['园区新闻'].dataList);
    let yqxw = [];
    yqxwPackageData.forEach(info => {
        let { key, value } = info;
        info.value = `${serverConfig_1.systemConfig.imgPath}/${value}`;
        yqxw.push(info);
    });
    ret['yqxw'] = out_1.getKeyValueOut('园区新闻', yqxw);
    res.send(ret);
}
exports.getData = getData;
//# sourceMappingURL=zhyy.js.map