
import * as asyncHandler from 'express-async-handler'
import * as addBiz from '../biz/addData';
import * as delBiz from '../biz/delData';
import * as updateBiz from '../biz/updateData';
import * as findBiz from '../biz/findData';

import { checkMySqlSign } from '../middleware/user';
import { eccReqParamater } from '../tools/eccParam';
import { BizError } from '../util/bizError';
import { ERRORENUM } from '../config/errorEnum';

export function setRouter(httpServer){
    httpServer.post('/yfs/dataserver/mysql/table/add', checkMySqlSign, asyncHandler(addTableData));
    httpServer.post('/yfs/dataserver/mysql/table/delete', checkMySqlSign, asyncHandler(deleteData));
    httpServer.post('/yfs/dataserver/mysql/table/update', checkMySqlSign, asyncHandler(updateManyData));
    httpServer.post('/yfs/dataserver/mysql/table/find/one', checkMySqlSign, asyncHandler(findOneData));
    httpServer.post('/yfs/dataserver/mysql/table/find/many', checkMySqlSign, asyncHandler(findManyData));
    httpServer.post('/yfs/dataserver/mysql/table/find/manytopage', checkMySqlSign, asyncHandler(findManyToPageData));
    httpServer.post('/yfs/dataserver/mysql/table/find/count', checkMySqlSign, asyncHandler(findCountData));
    httpServer.post('/yfs/dataserver/mysql/table/find/aggragate', checkMySqlSign, asyncHandler(findAggragateData));
    httpServer.post('/yfs/dataserver/mysql/table/find/aggragatetopage', checkMySqlSign, asyncHandler(findAggragateDataToPage));
    httpServer.post('/yfs/dataserver/mysql/table/find/aggragateone', checkMySqlSign, asyncHandler(selectOneDataToTableAssociation));
    
}


async function addTableData(req, res) {
    let table = req.tableModel;

    let reqConf = {data: 'Object' };
    let { data } = eccReqParamater(reqConf, req.body);

    if (!Object.keys(data).length) throw new BizError(ERRORENUM.添加时数据对象为空);

    let result = await addBiz.addData(table, data);
    res.success(result);
}


async function deleteData(req, res) {
    let table = req.tableModel;

    let reqConf = {param: 'Object' };
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await delBiz.delData(table, param);
    res.success(result);
}


async function updateManyData(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object', data: 'Object' };
    let { param, data } = eccReqParamater(reqConf, req.body);

    if (!Object.keys(data).length) throw new BizError(ERRORENUM.修改时数据对象为空);

    let result = await updateBiz.updateManyData(table, param, data);
    res.success(result);
}


async function findOneData(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object', column:"[String]"};
    let { param, column } = eccReqParamater(reqConf, req.body, ["column"]);

    let result = await findBiz.selectOneDataByParam(table, param, column);
    res.success(result);
}


async function findManyData(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object', column:"[String]"};
    let { param, column } = eccReqParamater(reqConf, req.body, ["column"]);

    let result = await findBiz.selectDataListByParam(table, param, column);
    res.success(result);
}


async function findManyToPageData(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object', pageNumber:'Number', pageSize:'Number', column:"[String]"};
    let { param, pageNumber, pageSize, column } = eccReqParamater(reqConf, req.body, ["column"] );

    let result = await findBiz.selectDataListToPageByParam(table, param, column, pageNumber, pageSize);
    res.success(result);
}


async function findCountData(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object'};
    let { param } = eccReqParamater(reqConf, req.body);

    let result = await findBiz.selectDataCountByParam(table, param);
    res.success(result);
}


async function findAggragateData(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object', includeConf:'Object', column:"[String]" };
    let { param, includeConf, column  } = eccReqParamater(reqConf, req.body, ["column"]);

    let result = await findBiz.selectDataToTableAssociation(table, includeConf, param, column);
    res.success(result);
}


async function findAggragateDataToPage(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object', includeConf:'Object', column:"[String]", pageNumber:'Number', pageSize:'Number', };
    let { param, includeConf, column, pageNumber, pageSize  } = eccReqParamater(reqConf, req.body, ["column"]);

    let result = await findBiz.selectDataToTableAssociationToPage(table, includeConf, param, column, pageNumber, pageSize);
    res.success(result);
}


async function selectOneDataToTableAssociation(req, res) {
    let table = req.tableModel;

    let reqConf = {param:'Object', includeConf:'Object', column:"[String]" };
    let { param, includeConf, column  } = eccReqParamater(reqConf, req.body, ["column"]);

    let result = await findBiz.selectOneDataToTableAssociation(table, includeConf, param, column);
    res.success(result);
}

