const Sequelize = require('sequelize');

export const TablesConfig = [
    {
        tableNameCn:'企业孵化信息',
        tableName:'enterprise_fuhua',
        schema:{
            fId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            startTime: {type:Sequelize.DATE}, //孵化开始日期
            endTime: {type:Sequelize.DATE}, //孵化结束日期
            state: {type:Sequelize.STRING(50)}, //孵化状态
            virtualCause: {type:Sequelize.STRING(255)}, //虚拟孵化原因
            virtualCauseDes: {type:Sequelize.STRING(255)}, //虚拟孵化描述
            moveOutType: {type:Sequelize.STRING(50)}, //迁出类型
            moveOutTrace: {type:Sequelize.STRING(255)}, //迁出去向
            moveOutCause: {type:Sequelize.STRING(255)}, //迁出原因
            moveOutTime: {type:Sequelize.DATE}, //迁出时间
            graduationTime: {type:Sequelize.DATE}, //毕业时间
        },
        association: []
    },
    {
        tableNameCn:'租赁信息',
        tableName:'enterprise_lease',
        schema:{
            leaseId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            area: {type:Sequelize.DECIMAL(10, 2)}, //租赁面积
            unitPrice: {type:Sequelize.DECIMAL(10, 2)}, //出租单价
            isDeposit: {type:Sequelize.DECIMAL(18, 2)}, //是否已收入孵押金金额
            startTime: {type:Sequelize.DATE}, //租赁开始日期
            endTime: {type:Sequelize.DATE}, //租赁结束日期
            rentFreeStart: {type:Sequelize.DATE}, //免租期开始
            rentFreeEnd: {type:Sequelize.DATE}, //免租期结束
            roomNumber: {type:Sequelize.STRING(50)}, //室号
            rent: {type:Sequelize.DECIMAL(18, 2)}, //每月租金
            notes: {type:Sequelize.STRING(255)}, //备注
            leaseContract: {type:Sequelize.STRING(255)}, //房屋租赁合同链接
            entryPlan: {type:Sequelize.STRING(255)}, //入驻计划复印件链接
            businessLicense: {type:Sequelize.STRING(255)}, //营业执照复印件链接
            agreement: {type:Sequelize.STRING(255)}, //孵化协议链接

        },
        association: []
    },
    {
        tableNameCn:'企业用户表',
        tableName:'enterprise_user',
        schema:{
            uId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            userName: {type:Sequelize.STRING(50), allowNull:false}, //用户名称
            phone: {type:Sequelize.STRING(11), allowNull:false}, //手机号
            pwd: {type:Sequelize.STRING(255), allowNull:false}, //密码
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            token: {type:Sequelize.STRING(255), allowNull:true}, //token
            tokenMs:{ type:Sequelize.DATE, allowNull:true}
        },
        association: []
    },
    {
        tableNameCn:'企业融资',
        tableName:'enterprise_financing',
        schema:{
            rId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            financingAmount: {type:Sequelize.DECIMAL(18, 2)}, //融资金额（万元）
            financingRounds: {type:Sequelize.STRING(50)}, //融资轮次
            fuHuaQiInvestment: {type:Sequelize.BOOLEAN}, //孵化器是否参与投资（1表示是，0表示否）
            fuHuaQiInvestmentStyle: {type:Sequelize.STRING(50)}, //孵化器投资方式
            fuHuaQiInvestmentAmount: {type:Sequelize.DECIMAL(18, 2)}, //孵化器投资金额
            investmentDate: {type:Sequelize.DATE}, //获得投资时间
            investmentInstitutionsName: {type:Sequelize.STRING(255)}, //投资机构名称
            valuation: {type:Sequelize.DECIMAL(18, 2)}, //估值
        },
        association: []
    },
    {
        tableNameCn:'企业荣誉',
        tableName:'enterprise_honor',
        schema:{
            hId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            awardName: {type:Sequelize.STRING(255)}, //奖项名称
            awardingUnit: {type:Sequelize.STRING(255)}, //颁奖单位
            awardTime: {type:Sequelize.DATE}, //获奖日期
            awardLevel: {type:Sequelize.STRING(50)}, //奖项等级
            awardImg: {type:Sequelize.STRING(255)}, //关联图片
        },
        association: []
    },
    {
        tableNameCn:'企业经营信息',
        tableName:'enterprise_manage',
        schema:{
            mId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            annual: {type:Sequelize.DATE}, //年度
            BI: {type:Sequelize.DECIMAL(18, 2)}, //营收（万元）
            TXP: {type:Sequelize.DECIMAL(18, 2)}, //纳税（万元）
            RD: {type:Sequelize.DECIMAL(18, 2)}, //研发投入（万元）
            createTime: {type:Sequelize.DATE}, //填写时间
        },
        association: []
    },
    {
        tableNameCn:'企业资质',
        tableName:'enterprise_qualification',
        schema:{
            qId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            kxTime: {type:Sequelize.DATE}, //科小认定时间
            zjtxTime: {type:Sequelize.DATE}, //专精特新认定时间
            xjrTime: {type:Sequelize.DATE}, //小巨人认定时间
            xjrPyTime: {type:Sequelize.DATE}, //小巨人培育认定时间
            goPublicTime: {type:Sequelize.DATE}, //上市时间
            goPublicSector: {type:Sequelize.STRING(50)}, //上市板块
        },
        association: []
    },
    {
        tableNameCn:'参保记录',
        tableName:'enterprise_canbao',
        schema:{
            cId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            annual: {type:Sequelize.DATE}, //所属年报
            degree: {type:Sequelize.STRING(50)}, //学历
            number: {type:Sequelize.INTEGER}, //人数
        },
        association: []
    },
    {
        tableNameCn:'创业团队',
        tableName:'enterprise_team',
        schema:{
            tId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            teamName: {type:Sequelize.STRING(50)}, //姓名
            sex: {type:Sequelize.STRING(1)}, //性别 0:男，1:女
            birth: {type:Sequelize.DATE}, //出生年月
            degree: {type:Sequelize.INTEGER}, //最高学历【枚举】
            graduationSchool: {type:Sequelize.STRING(255)}, //毕业学校
            talentType: {type:Sequelize.INTEGER}, //人才类型【枚举】
            des: {type:Sequelize.STRING(255)}, //履历描述
        },
        association: []
    },
    {
        tableNameCn:'知识产权',
        tableName:'enterprise_ipr',
        schema:{
            iprId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            year: {type:Sequelize.DATE}, //认定时间（年）
            number: {type:Sequelize.INTEGER}, //个数
        },
        association: []
    },
    {
        tableNameCn:'法人信息表',
        tableName:'enterprise_legal_person',
        schema:{
            legalId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            name: {type:Sequelize.STRING(100)}, //姓名
            idCard: {type:Sequelize.STRING(18)}, //身份证
            domicile: {type:Sequelize.STRING(255)}, //户籍
            degree: {type:Sequelize.STRING(50)}, //学历
            politicalStatus: {type:Sequelize.STRING(50)}, //政治面貌
            phone: {type:Sequelize.STRING(11)}, //手机号码
        },
        association: []
    },
    {
        tableNameCn:'企业专利表',
        tableName:'enterprise_patent',
        schema:{
            pId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            year: {type:Sequelize.DATE}, //认定时间（年）
            lv: {type:Sequelize.STRING(50)}, //专利级别
            number: {type:Sequelize.INTEGER}, //个数
        },
        association: []
    },
    {
        tableNameCn:'园区通知表',
        tableName:'garden_notice',
        schema:{
            gnId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            title: {type:Sequelize.STRING(255), allowNull:false}, //标题
            content: {type:Sequelize.STRING(255)}, //内容
            isPublished: {type:Sequelize.BOOLEAN}, //是否发布（1：是，0：否）
            publishTime: {type:Sequelize.DATE}, //发布时间
            relatedEnterprise: {type:Sequelize.STRING(255)}, //关联企业
        },
        association: []
    },
    {
        tableNameCn:'园区活动表',
        tableName:'garden_activity',
        schema:{
            gaId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            activityTitle: {type:Sequelize.STRING(255), allowNull:false}, //标题
            activityContent: {type:Sequelize.STRING(255)}, //内容
            activityTime: {type:Sequelize.DATE}, //发布时间
            activityAddress: {type:Sequelize.STRING(255)}, //关联企业
            isPublished: {type:Sequelize.BOOLEAN}, //是否发布（1：是，0：否）
        },
        association: []
    },
    {
        tableNameCn:'企业服务表',
        tableName:'enterprise_service',
        schema:{
            esId: {
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(20), allowNull:false}, //关联企业id
            requestingEnterprise: {type:Sequelize.STRING(255), allowNull:false}, //申请企业
            needCategory: {type:Sequelize.INTEGER}, //需求类别
            needContent: {type:Sequelize.STRING(255)}, //需求内容
            applyTime: {type:Sequelize.DATE}, //申请时间
            followUpStatus: {type:Sequelize.INTEGER}, //跟进状态
            resolveTime: {type:Sequelize.DATE}, //解决时间
        },
        association: []
    },
    {
        tableNameCn:'企业基础信息表',
        tableName:'enterprise',
        schema:{
            eId:{
                type:Sequelize.STRING(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            enterpriseName: {type:Sequelize.STRING(255), allowNull:false}, //企业名称
            uscc: {type:Sequelize.STRING(18), allowNull:false}, //统一信用代码
            zhuCeHao:{type:Sequelize.STRING(100)},//注册号
            zuZhiJiGouDaiMa: {type:Sequelize.STRING(18)}, //组织机构代码
            gengDuoDianHua: {type:Sequelize.STRING(255)}, //更多电话
            mainBusiness: {type:Sequelize.STRING(255)}, //主营业务
            logonTime: {type:Sequelize.DATE}, //注册日期
            mail: {type:Sequelize.STRING(255)}, //邮箱
            isNaturalPersonHolding: {type:Sequelize.BOOLEAN}, //是否自然人控股企业（1表示是，0表示否）
            industry: {type:Sequelize.STRING(255)}, //领域
            moreMail: {type:Sequelize.STRING(255)}, //更多邮箱
            // dianHua: {type:Sequelize.STRING(100)}, //电话
            logonAddress: {type:Sequelize.STRING(255)}, //注册地址
            tongXinDiZhi: {type:Sequelize.STRING(255)}, //通信地址
            liaison: {type:Sequelize.STRING(50)}, //联系人
            liaisonPhone: {type:Sequelize.STRING(11)}, //联系电话
            dengJiJiGuan: {type:Sequelize.STRING(255)}, //登记机关
            qiYeGuiMo: {type:Sequelize.STRING(50)}, //企业规模
            RAS: {type:Sequelize.STRING(50)}, //登记状态
            guanWang: {type:Sequelize.STRING(255)}, //官网地址
            yingYeQiXian: {type:Sequelize.STRING(50)}, //营业期限
            logOffMS: {type:Sequelize.DATE}, //注销时间
            shijiaoziben: {type:Sequelize.STRING(255)}, //实缴资本
            enterpriseType: {type:Sequelize.STRING(50)}, //企业机构类型
            jianJie: {type:Sequelize.STRING(255)}, //简介
            zhuceziben: {type:Sequelize.STRING(255)}, //注册资本
            naShuiRenZiZhi: {type:Sequelize.STRING(50)}, //纳税人资质
            operatingAddress: {type:Sequelize.STRING(255)}, //经营地址
            oldLogonAddress: {type:Sequelize.STRING(255)},//迁入前注册地址
        },
        association: [
            {type: "hasMany", check: "enterprise_fuhua", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_lease", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_user", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_financing", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_honor", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_manage", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_qualification", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_canbao", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_team", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_ipr", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_legal_person", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_patent", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_service", foreignKey:"eId"}
        ]
    },

]; 