const Sequelize = require('sequelize');

export const TablesConfig = [
    {
        tableNameCn:'张江羽翼孵化器信息',
        tableName:'system_yuyi',
        schema:{
            yId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            operateName: {type:Sequelize.STRING(255)}, //运营名称
            name: {type:Sequelize.STRING(255)}, //孵化器名称
            uscc: {type:Sequelize.STRING(255)}, //统一社会信用代码
            registerTime: {type:Sequelize.STRING(255)}, //注册时间
            incubateLv: {type:Sequelize.STRING(255)}, //孵化级别
            incubateTime: {type:Sequelize.STRING(255)}, //孵化器认定时间
            incubateField: {type:Sequelize.STRING(255)}, //孵化领域
            natureInstitution: {type:Sequelize.STRING(255)}, //机构性质
            fundedReserve: {type:Sequelize.STRING(255)}, //是否成立投资基金 0:否，1:是
            contacts: {type:Sequelize.STRING(255)}, //联系人
            personCharge: {type:Sequelize.STRING(255)}, //负责人
            phone: {type:Sequelize.STRING(255)}, //手机号码
            synopsis: {type:Sequelize.STRING(255)}, //简介
            totalArea: {type:Sequelize.STRING(255)}, //总面积
            zaifuArea: {type:Sequelize.STRING(255)}, //在孵面积
            rentRate: {type:Sequelize.STRING(255)},//后台填报-出租率
            ziyonArea: {type:Sequelize.STRING(255)}, //自用面积
            parkArea: {type:Sequelize.STRING(255)},//新增园区面积
            enterpriseNum: {type:Sequelize.INTEGER},//新增企业数量
            industrialScale: {type:Sequelize.STRING(255)},//新增产业规模
            totalAssetInvestmentAmount:{type:Sequelize.STRING(255)},//新增总资产投入金额
            numberOfInstitutionsIntroduced:{type:Sequelize.STRING(255)},//新增引入机构数量
            introduceInstitutionalInvestment:{type:Sequelize.STRING(255)}//新增引入机构投资
        },
        association: []
    },
    {
        tableNameCn:'企业孵化信息',
        tableName:'enterprise_fuhua',
        schema:{
            fId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            startTime: {type:Sequelize.DATE}, //孵化开始日期
            endTime: {type:Sequelize.DATE}, //孵化结束日期
            state: {type:Sequelize.INTEGER}, //孵化状态 【枚举】
            virtualCause: {type:Sequelize.STRING(255)}, //虚拟孵化原因
            virtualCauseDes: {type:Sequelize.STRING(255)}, //虚拟孵化描述
            moveOutType: {type:Sequelize.INTEGER}, //迁出类型 毕业迁出，非毕业迁出
            moveOutTrace: {type:Sequelize.STRING(255)}, //迁出去向
            moveOutCause: {type:Sequelize.STRING(255)}, //迁出原因
            moveOutTime: {type:Sequelize.DATE}, //迁出时间
            graduationTime: {type:Sequelize.DATE}, //毕业时间
            jiShuHeTongJiaoYi:{type:Sequelize.INTEGER}, //技术合同交易数
        },
        association: []
    },
    {
        tableNameCn:'租赁信息',
        tableName:'enterprise_lease',
        schema:{
            leaseId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            area: {type:Sequelize.DECIMAL(10, 2)}, //租赁面积
            unitPrice: {type:Sequelize.DECIMAL(10, 2)}, //出租单价
            isDeposit: {type:Sequelize.DECIMAL(18, 2)}, //是否已收入孵押金金额
            startTime: {type:Sequelize.DATE}, //租赁开始日期
            endTime: {type:Sequelize.DATE}, //租赁结束日期
            rentFreeStart: {type:Sequelize.DATE}, //免租期开始
            rentFreeEnd: {type:Sequelize.DATE}, //免租期结束
            building: {type:Sequelize.STRING(50)}, //楼号
            roomNumber: {type:Sequelize.STRING(50)}, //室号
            rent: {type:Sequelize.DECIMAL(18, 2)}, //每月租金
            notes: {type:Sequelize.STRING(255)}, //备注
            leaseContract: {type:Sequelize.STRING(255)}, //房屋租赁合同链接
            entryPlan: {type:Sequelize.STRING(255)}, //入驻计划复印件链接
            businessLicense: {type:Sequelize.STRING(255)}, //营业执照复印件链接
            agreement: {type:Sequelize.STRING(255)}, //孵化协议链接
            bankName:{type:Sequelize.STRING(255)}, //银行
            totalPrice: {type:Sequelize.DECIMAL(18, 2)}, //总价
        },
        association: []
    },
    {
        tableNameCn:'企业用户表',
        tableName:'enterprise_user',
        schema:{
            uId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            userName: {type:Sequelize.STRING(50), allowNull:false}, //用户名称
            phone: {type:Sequelize.STRING(255), allowNull:false}, //手机号
            pwd: {type:Sequelize.STRING(255), allowNull:false}, //密码
            eId: {type:Sequelize.STRING(255), allowNull:true}, //关联企业id
            token: {type:Sequelize.STRING(255), allowNull:true}, //token
            tokenMs: { type:Sequelize.DATE, allowNull:true},
            email: {type:Sequelize.STRING(255), allowNull:true}, //新增邮箱
            code: {type:Sequelize.STRING(255), allowNull:true}, //验证码
            codeMs: { type:Sequelize.DATE, allowNull:true}, //验证码时间
        },
        association: []
    },
    {
        tableNameCn:'企业融资',
        tableName:'enterprise_financing',
        schema:{
            rId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            financingAmount: {type:Sequelize.DECIMAL(18, 2)}, //融资金额（万元）
            financingRounds: {type:Sequelize.INTEGER}, //融资轮次【枚举】
            fuHuaQiInvestment: {type:Sequelize.INTEGER}, //孵化器是否参与投资 【枚举】
            fuHuaQiInvestmentStyle: {type:Sequelize.INTEGER}, //孵化器投资方式
            fuHuaQiInvestmentAmount: {type:Sequelize.DECIMAL(18, 2)}, //孵化器投资金额
            investmentDate: {type:Sequelize.DATE}, //获得投资时间
            investmentInstitutionsName: {type:Sequelize.STRING(255)}, //投资机构名称
            valuation: {type:Sequelize.STRING(50)}, //估值
        },
        association: [] 
    },
    {
        tableNameCn:'企业荣誉',
        tableName:'enterprise_honor',
        schema:{
            hId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            awardName: {type:Sequelize.STRING(255)}, //奖项名称
            awardingUnit: {type:Sequelize.STRING(255)}, //颁奖单位
            awardTime: {type:Sequelize.DATE}, //获奖日期
            awardLevel: {type:Sequelize.INTEGER}, //奖项等级  【枚举】
            awardImg: {type:Sequelize.STRING(255)}, //关联图片
        },
        association: []
    },
    {
        tableNameCn:'企业经营信息',
        tableName:'enterprise_manage',
        schema:{
            mId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            annual: {type:Sequelize.DATE}, //年度
            quarter:{type:Sequelize.INTEGER},//新增季度 1：第一季度 2：第二季度 3：第三季度 4：第四季度
            BI: {type:Sequelize.DECIMAL(18, 2)}, //营收（万元）
            TXP: {type:Sequelize.DECIMAL(18, 2)}, //纳税（万元）
            RD: {type:Sequelize.DECIMAL(18, 2)}, //研发投入（万元）
            createTime: {type:Sequelize.DATE}, //填写时间
            isUpdate:{type:Sequelize.INTEGER},//更新状态 0=否 1=是
            isSubmit:{type:Sequelize.INTEGER},//是否提交 0=否 1=是
            state:{type:Sequelize.INTEGER}//审核状态 0=否 1=是
        },
        association: []
    },
    {
        tableNameCn:'企业资质',
        tableName:'enterprise_qualification',
        schema:{
            qId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            // qualificationType:{type:Sequelize.INTEGER}, //资质类型 【枚举】
            // qualificationTime: {type:Sequelize.STRING(255)}, //认定时间
            // qualificationNum: {type:Sequelize.STRING(255)}, //上传编号（只有科小有这个数据）
            // qualificationImg: {type:Sequelize.STRING(255)}, //上传证书
            // goPublicTime: {type:Sequelize.DATE}, //上市时间
            // goPublicSector: {type:Sequelize.STRING(255)}, //上市板块 【枚举】
            // other: {type:Sequelize.STRING(255)},//新增其他
            
            kxTime: {type:Sequelize.DATE}, //科小认定时间
            kxNumber: {type:Sequelize.STRING(255)}, //新增科小上传编号
            kxImg: {type:Sequelize.STRING(255)}, //科小证书
            zjtxTime: {type:Sequelize.DATE}, //专精特新认定时间
            zjtxImg: {type:Sequelize.STRING(255)}, //专精特新证书
            xjrTime: {type:Sequelize.DATE}, //小巨人认定时间
            xjrImg: {type:Sequelize.STRING(255)}, //小巨人证书
            xjrPyTime: {type:Sequelize.DATE}, //小巨人培育认定时间
            xjrPyImg: {type:Sequelize.STRING(255)}, //小巨人培育证书
            gaoXinJiShuTime: {type:Sequelize.DATE}, //高新技术认定时间
            gaoXinJiShuImg: {type:Sequelize.STRING(255)}, //高新技术证书
            goPublicTime: {type:Sequelize.DATE}, //上市时间
            goPublicSector: {type:Sequelize.STRING(255)}, //上市板块 【枚举】
            other: {type:Sequelize.STRING(255)},//新增其他
            kxState: {type:Sequelize.INTEGER}, //科小是否认定
            zjtxState: {type:Sequelize.INTEGER},//专精特新是否认定
            xjrState: {type:Sequelize.INTEGER}, //小巨人是否认定
            xjrPyState: {type:Sequelize.INTEGER},//小巨人培育是否认定
            gxjsState: {type:Sequelize.INTEGER},//高新技术是否认定
            listedState: {type:Sequelize.INTEGER},//上市是否认定
        },
        association: []
    },
    {
        tableNameCn:'参保记录',
        tableName:'enterprise_canbao',
        schema:{
            cId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            annual: {type:Sequelize.DATE}, //所属年报
            zhuanKe:{type:Sequelize.INTEGER},//专科
            benKe:{type:Sequelize.INTEGER},//本科
            // yanJiuSheng:{type:Sequelize.INTEGER},//研究生
            shuoshi:{type:Sequelize.INTEGER}, //硕士
            boShi:{type:Sequelize.INTEGER},//博士
            boshiyishang:{type:Sequelize.INTEGER},//博士以上
            qiTa:{type:Sequelize.INTEGER},//其他
        },
        association: []
    },
    {
        tableNameCn:'创业团队',
        tableName:'enterprise_team',
        schema:{
            tId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            name: {type:Sequelize.STRING(50)}, //姓名
            sex: {type:Sequelize.INTEGER}, //性别 0:男，1:女 【枚举】
            birth: {type:Sequelize.DATE}, //出生年月
            degree: {type:Sequelize.INTEGER}, //最高学历【枚举】
            graduationSchool: {type:Sequelize.STRING(255)}, //毕业学校
            talentType: {type:Sequelize.INTEGER}, //人才类型【枚举】
            des: {type:Sequelize.STRING(255)}, //履历描述
            certificateImg: {type:Sequelize.STRING(500)}, //新增证书图片字段
        },
        association: []
    },
    {
        tableNameCn:'知识产权',
        tableName:'enterprise_ipr',
        schema:{
            iprId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            year: {type:Sequelize.DATE}, //认定时间（年）
            number: {type:Sequelize.INTEGER}, //个数
            iprType: {type:Sequelize.INTEGER},  // 新增知识产权类型: 软件著作,发明专利,海外专利,植物新品种,集成电路布图,【枚举】
            selectedValue: {type:Sequelize.INTEGER},//新增选中的值 没有用到这个字段
            iprName: {type:Sequelize.STRING(255)}, // 新增名称
            iprUrl: {type:Sequelize.STRING(255)},//新增证明材料
            category: {type:Sequelize.STRING(255)},//类别
            // softwareCopyrightCount:{type:Sequelize.INTEGER} ,//新增软件著作数量
            // inventionPatentCount:{type:Sequelize.INTEGER} ,//新增发明专利数量
            // overseasPatentCount:{type:Sequelize.INTEGER},//新增海外专利数量
            // plantVarietyCount:{type:Sequelize.INTEGER} ,//新增植物新品种数量
            // icLayoutCount: {type:Sequelize.INTEGER}//新增集成电路布图数量
        },
        association: []
    },
    {
        tableNameCn:'法人信息表',
        tableName:'enterprise_legal_person',
        schema:{
            legalId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            name: {type:Sequelize.STRING(100)}, //姓名
            idCard: {type:Sequelize.STRING(255)}, //身份证
            domicile: {type:Sequelize.STRING(255)}, //户籍
            degree: {type:Sequelize.INTEGER}, //学历  【枚举】
            politicalStatus: {type:Sequelize.INTEGER}, //政治面貌
            phone: {type:Sequelize.STRING(255)}, //手机号码
        },
        association: []
    },
    {
        tableNameCn:'企业专利表', //没有使用到
        tableName:'enterprise_patent',
        schema:{
            pId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            year: {type:Sequelize.DATE}, //认定时间（年）
            alienPatent: {type:Sequelize.INTEGER}, //海外专利个数
            classIPatent: {type:Sequelize.INTEGER}, //一类专利个数
            secondClassPatent: {type:Sequelize.INTEGER}, //二级专利个数
            thirdPentent: {type:Sequelize.INTEGER}, //三级专利个数
        },
        association: []
    },
    {
        tableNameCn:'园区通知表',
        tableName:'garden_notice',
        schema:{
            gnId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            title: {type:Sequelize.STRING(255), allowNull:false}, //标题
            content: {type:Sequelize.STRING(255)}, //内容
            isPublished: {type:Sequelize.INTEGER}, //是否发布（1：是，0：否） 【枚举】
            publishTime: {type:Sequelize.DATE}, //发布时间
            relatedEnterprise: {type:Sequelize.STRING(255)}, //关联企业
        },
        association: []
    },
    {
        tableNameCn:'园区活动表',
        tableName:'garden_activity',
        schema:{
            gaId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            activityTitle: {type:Sequelize.STRING(255), allowNull:false}, //标题
            activityContent: {type:Sequelize.STRING(255)}, //内容
            activityTime: {type:Sequelize.DATE}, //发布时间
            activityAddress: {type:Sequelize.STRING(255)}, //关联企业
            isPublished: {type:Sequelize.INTEGER}, //是否发布（1：是，0：否） 【枚举】
        },
        association: []
    },
    {
        tableNameCn:'企业服务表',
        tableName:'enterprise_service',
        schema:{
            esId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            needCategory: {type:Sequelize.INTEGER}, //需求类别
            needContent: {type:Sequelize.STRING(255)}, //需求内容
            applyTime: {type:Sequelize.DATE}, //申请时间
            followUpStatus: {type:Sequelize.INTEGER}, //跟进状态 【枚举】
            resolveTime: {type:Sequelize.DATE}, //解决时间
            fangKui:{type:Sequelize.STRING(255)}, //反馈
            shouLiTime:{type:Sequelize.DATE},//反馈时间
            outcome:{type:Sequelize.INTEGER},//结果
            desc:{type:Sequelize.STRING(255)}, //备注
        },
        association: []
    },
    {
        tableNameCn:'政策表',
        tableName:'policy',
        schema:{
            poId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            title:{type:Sequelize.STRING(255)},//标题
            desc:{type:Sequelize.STRING(255)},//内容
            source:{type:Sequelize.STRING(255)},//来源
            createTimeMs:{type:Sequelize.DATE},//创建时间
            coverImg:{type:Sequelize.STRING(255)},//图片
            target:{type:Sequelize.STRING(255)},//标签
            closeTimeMs:{type:Sequelize.DATE},//关闭时间
            isPermanent:{type:Sequelize.INTEGER},//是否永久有效 0=否 1=是
            policyType:{type:Sequelize.INTEGER},//类型 1=财政补贴 2=资质申报 3=政策扶持
        },
        association: []
    },
    {
        tableNamecn:'入孵申请审批表',
        tableName:'approval_history',
        schema:{
            approvalId:{
                type:Sequelize.STRING(255),//表示属性的数据类型
                allowNul1:false,//表示当前列是否允许为空，false表示该列不能为空
                primaryKey:true,//表示主键
                unique:true ,//表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255),allowNull:false},//关联企业id
            changeType:{type:Sequelize.INTEGER},//审批类型:1=入申请 2=入孵材料上传
            changestate:{type:Sequelize.INTEGER},//操作审核状态 =否 1=是 2-驳回 3=重新提交
            createTimeMs :{type:Sequelize.DATE},//日志时间
        },
        association:[]
    },
    {
        tableNameCn:'企业基础信息表',
        tableName:'enterprise',
        schema:{
            eId:{
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            enterpriseName: {type:Sequelize.STRING(255), allowNull:false}, //企业名称
            uscc: {type:Sequelize.STRING(18), allowNull:false}, //统一信用代码
            zhuCeHao:{type:Sequelize.STRING(100)},//注册号
            zuZhiJiGouDaiMa: {type:Sequelize.STRING(18)}, //组织机构代码
            gengDuoDianHua: {type:Sequelize.STRING(255)}, //更多电话
            mainBusiness: {type:Sequelize.TEXT}, //主营业务
            logonTime: {type:Sequelize.DATE}, //注册日期
            mail: {type:Sequelize.STRING(255)}, //邮箱
            isNaturalPersonHolding: {type:Sequelize.INTEGER}, //是否自然人控股企业（1表示是，0表示否） 【枚举】
            industry: {type:Sequelize.STRING(255)}, //领域
            moreMail: {type:Sequelize.STRING(255)}, //更多邮箱
            // dianHua: {type:Sequelize.STRING(100)}, //电话
            logonAddress: {type:Sequelize.STRING(255)}, //注册地址
            tongXinDiZhi: {type:Sequelize.STRING(255)}, //通信地址
            liaison: {type:Sequelize.STRING(50)}, //联系人
            liaisonPhone: {type:Sequelize.STRING(255)}, //联系电话
            dengJiJiGuan: {type:Sequelize.STRING(255)}, //登记机关
            qiYeGuiMo: {type:Sequelize.STRING(50)}, //企业规模
            RAS: {type:Sequelize.STRING(50)}, //登记状态
            guanWang: {type:Sequelize.STRING(255)}, //官网地址
            yingYeQiXian: {type:Sequelize.STRING(50)}, //营业期限
            logOffMS: {type:Sequelize.DATE}, //注销时间
            shijiaoziben: {type:Sequelize.STRING(255)}, //实缴资本
            enterpriseType: {type:Sequelize.STRING(50)}, //企业机构类型
            jianJie: {type:Sequelize.TEXT}, //简介
            zhuceziben: {type:Sequelize.STRING(255)}, //注册资本
            naShuiRenZiZhi: {type:Sequelize.STRING(50)}, //纳税人资质
            operatingAddress: {type:Sequelize.STRING(255)}, //经营地址
            oldLogonAddress: {type:Sequelize.STRING(255)},//迁入前注册地址
            shuiHao:{type:Sequelize.STRING(255)},//税号
            shuiWuJu:{type:Sequelize.STRING(255)},//税务局
            jingYingFanWei:{type:Sequelize.TEXT},//经营范围
            //状态标识
            register:{type:Sequelize.INTEGER},//入孵申请状态  0=否 1=是 2=驳回
            state:{type:Sequelize.INTEGER},//入孵材料审核状态 0=否 1=是 2=驳回
            //临时填充信息用的验证码
            randomCode:{type:Sequelize.STRING(255)}
        },
        association: [
            {type: "hasMany", check: "enterprise_fuhua", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_lease", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_user", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_financing", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_honor", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_manage", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_qualification", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_canbao", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_team", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_ipr", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_legal_person", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_patent", foreignKey:"eId"},
            {type: "hasMany", check: "enterprise_service", foreignKey:"eId"},
            //新加
            {type:"hasMany", check:"info_update", goreignKey:"eId"},
            {type:"hasMany", check:"enterprise_label", goreignKey:"eId"},
            {type:"hasMany", check:"ownership", goreignKey:"eId"},
            {type:"hasMany", check:"enterprise_industry", goreignKey:"eId"},
            {type:"hasMany", check:"employees", goreignKey:"eId"},
            {type:"hasMany", check:"branches", goreignKey:"eId"},
            {type:"hasMany", check:"license", goreignKey:"eId"},
            {type:"hasMany", check:"empty", goreignKey:"eId"},
            {type:"hasMany", check:"enterprise_risk", goreignKey:"eId"},
            {type:"hasMany", check:"enterprise_stem", goreignKey:"eId"},
            {type:"hasMany", check:"certification", goreignKey:"eId"},
            {type:"hasMany", check:"dishonesty", goreignKey:"eId"},
            {type:"hasMany", check:"break_the_law", goreignKey:"eId"},
            {type:"hasMany", check:"overseas_investment", goreignKey:"eId"},
            {type:"hasMany", check:"approval_history", goreignKey:"eId"},
            {type:"hasMany", check:"info_enter", goreignKey:"eId"},
            {type:"hasMany", check:"info_operation_promotion", goreignKey:"eId"},
        ]
    },
    //孵化器入驻信息表
    {
        tableNameCn: '入驻信息表',
        tableName: 'info_enter',
        schema: {
            info_enterId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            building: {type: Sequelize.STRING(255)},//楼号(1,3,4)
            occupancyRate: {type: Sequelize.STRING(255)},//入驻率
            enteredEnterprises: {type: Sequelize.STRING(255)},//入驻企业
        },
        association: []
    },
    //运营推广信息表
    {
        tableNameCn: '运营推广信息表',
        tableName: 'info_operation_promotion',
        schema: {
            opId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            onlinePromotion:{type: Sequelize.STRING(255)},//线上推广
            tiktok:{type: Sequelize.STRING(255)},//抖音
            theLittleRedBook:{type: Sequelize.STRING(255)},//小红书
            videoNumber:{type: Sequelize.STRING(255)},//视频号
            offlinePromotion:{type: Sequelize.STRING(255)},//线下推广
            eventPromotion:{type: Sequelize.STRING(255)},//活动宣讲
            tripartiteInstitutionalCooperation:{type: Sequelize.STRING(255)},//三方机构合作
        },
        association: []
    },
    //新加表
    {
        tableNameCn:'变更信息表',
        tableName:'info_update',
        schema:{
            updateId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            afterContent: {type:Sequelize.STRING(255)}, //变更前
            beforeContent: {type:Sequelize.STRING(255)}, //变更后
            changeDate: {type:Sequelize.DATE}, //变更时间
            projectName :{type:Sequelize.STRING(255)},//变更类型
        },
        association: []
    },
    {
        tableNameCn:'企业标签表',
        tableName:'enterprise_label',
        schema:{
            elId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255)}, //关联企业id
            type:{type:Sequelize.STRING(255)}, //类型
            labelName:{type:Sequelize.STRING(255)}, //标签名字
        },
        association: []
    },
    {
        tableNameCn:'股权结构',
        tableName:'ownership',
        schema:{
            owId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255)}, //关联企业id
            name:{type:Sequelize.STRING(255)}, //名称
            finalBenefitPercent:{type:Sequelize.STRING(255)}, //最终受益股份
            stockPercent:{type:Sequelize.STRING(255)}, //持股比例
            stockType:{type:Sequelize.STRING(255)}, //投资人类型
            realCapi:{type:Sequelize.STRING(255)}, //实缴出资额
            paidUpCapitalUnit:{type:Sequelize.STRING(255)}, //实缴出资额单位
            capiDate:{type:Sequelize.DATE}, //实缴时间
            subscribedCapital:{type:Sequelize.STRING(255)}, //认缴出资额数额
            subscribedCapitalUnit:{type:Sequelize.STRING(255)}, //认缴出资额单位
            shoudDate:{type:Sequelize.DATE}, //认缴出资时间
        },
        association: []
    },
    {
        tableNameCn:'行业信息分类',
        tableName:'enterprise_industry',
        schema:{
            eiId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            industryCode:{type:Sequelize.STRING(255), allowNull:false},//行业门类code
            industry:{type:Sequelize.STRING(255), allowNull:false},//行业门类描述
            subIndustryCode:{type:Sequelize.STRING(255), allowNull:false},//行业大类code
            subIndustry:{type:Sequelize.STRING(255), allowNull:false},//行业大类描述
            middleCategoryCode:{type:Sequelize.STRING(255), allowNull:false},//行业中类code
            middleCategory:{type:Sequelize.STRING(255), allowNull:false},//行业中类描述
            smallCategoryCode:{type:Sequelize.STRING(255), allowNull:false},//行业小类code
            smallCategory:{type:Sequelize.STRING(255), allowNull:false},//行业小类描述
        },
        association: []
    },
    {
        tableNameCn:'主要人员',
        tableName:'employees',
        schema:{
            emId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId: {type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            job:{type:Sequelize.STRING(255), allowNull:false},//职务
            name:{type:Sequelize.STRING(255), allowNull:false},//姓名
        },
        association: []
    },
    {
        tableNameCn:'分支机构',
        tableName:'branches',
        schema:{
            brId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            name:{type:Sequelize.STRING(255), allowNull:false},//机构名称
            status:{type:Sequelize.STRING(255), allowNull:false},//状态
            employeesName:{type:Sequelize.STRING(255), allowNull:false},//负责人
        },
        association: []
    },
    {
        tableNameCn:'行政许可核查',
        tableName:'license',
        schema:{
            liId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            source:{type:Sequelize.STRING(255)},// 来源
            licenseNo:{type:Sequelize.STRING(255)},// 决定文书/许可编号（两者同时存在，则优先显示决定文书号）
            licenseName:{type:Sequelize.STRING(255)},// 决定文书/许可证书名称（两者同时存在，则优先显示许可证书名称）
            validityFrom:{type:Sequelize.DATE},// 有效期自，精确到天，如“2021-01-01”
            validityTo:{type:Sequelize.DATE},// 有效期至，精确到天，如“2021-01-01”
            licensOffice:{type:Sequelize.STRING(255)},// 许可机关
            licensContent:{type:Sequelize.STRING(255)},// 许可内容
            documentNo:{type:Sequelize.STRING(255)},// 决定文书号
            permissionNo:{type:Sequelize.STRING(255)},// 许可编号
        },
        association: []
    },
    {
        tableNameCn:'空壳扫描',
        tableName:'empty',
        schema:{
            emptyId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            title:{type:Sequelize.STRING(255)},//标题
            description:{type:Sequelize.STRING(255)},//描述
        },
        association: []
    },
    {
        tableNameCn:'风险',
        tableName:'enterprise_risk',
        schema:{
            riskId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            title:{type:Sequelize.STRING(255)},//标题
            description:{type:Sequelize.STRING(255)},//描述
            passage:{type:Sequelize.STRING(255)},//红黄绿通道
            riskType:{type:Sequelize.STRING(255)},//风险类别(法律风险，行政处罚风险，经营合规性风险，国别风险，关联企业风险，经营稳定性风险)
            typeCode:{type:Sequelize.INTEGER},//详情分类
        },
        association: []
    },
    {
        tableNameCn:'科创分',
        tableName:'enterprise_stem',
        schema:{
            stemId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            industry:{type:Sequelize.STRING(255)}, //一级行业
            subIndustry:{type:Sequelize.STRING(255)}, //二级行业
            industryRanking:{type:Sequelize.STRING(255)}, //行业位置，百分比（在同行中处于前多少）
            score:{type:Sequelize.INTEGER}, //分数
        },
        association: []
    },
    {
        tableNameCn:'资质证书',
        tableName:'certification',
        schema:{
            cerId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255)}, //关联企业id
            name:{type:Sequelize.STRING(255)},//产品名称或者资质类别及等级
            type:{type:Sequelize.STRING(255)},//证书类型
            startDate:{type:Sequelize.DATE},//证书生效时间
            endDate:{type:Sequelize.DATE},//证书截止日期
            no:{type:Sequelize.STRING(255)},//证书编号
            typeDesc:{type:Sequelize.STRING(255)},//证书类型
            institutionList:{type:Sequelize.STRING(255)},//发证机构
            status:{type:Sequelize.STRING(255)},//证书状态
           
        },
        association: []
    },
    {
        tableNameCn:'失信核查',
        tableName:'dishonesty',
        schema:{
            disId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            liandate:{type:Sequelize.DATE},//立案日期，精确到天，如“2022-01-01”
            anno:{type:Sequelize.STRING(255)},//案号
            executegov:{type:Sequelize.STRING(255)},//执行法院
            executestatus:{type:Sequelize.STRING(255)},//被执行人的履行情况
            publicdate:{type:Sequelize.DATE},//发布日期，精确到天，如“2022-01-01”
            executeno:{type:Sequelize.STRING(255)},//执行依据文号
            actionRemark:{type:Sequelize.STRING(255)},//失信行为
            amount:{type:Sequelize.STRING(255)},//涉案金额(元)
        },
        association: []
    },
    {
        tableNameCn:'严重违法犯罪',
        tableName:'break_the_law',
        schema:{
            btlId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            Type:{type:Sequelize.STRING(255)},//类型（保留字段）
            AddReason:{type:Sequelize.STRING(255)},//列入原因
            AddDate:{type:Sequelize.DATE},//列入时间
            AddOffice:{type:Sequelize.STRING(255)},//列入决定机关
            RemoveReason:{type:Sequelize.STRING(255)},//移除原因（保留字段）
            RemoveDate:{type:Sequelize.DATE},//移除时间（保留字段）
            RemoveOffice:{type:Sequelize.STRING(255)},//移除决定机关（保留字段）
        },
        association: []
    },
    {
        tableNameCn:'对外投资',
        tableName:'overseas_investment',
        schema:{
            oilId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
            name:{type:Sequelize.STRING(255)},//被投资企业名称
            registCapi:{type:Sequelize.STRING(255)},//被投资企业注册资本
            registeredCapital:{type:Sequelize.STRING(255)},//被投资企业注册资本数额
            registeredCapitalUnit:{type:Sequelize.STRING(255)},//被投资企业注册资本单位
            registeredCapitalCCY:{type:Sequelize.STRING(255)},//被投资企业注册资本币种
            fundedRatio:{type:Sequelize.STRING(255)},//持股比例
            shouldCapi:{type:Sequelize.STRING(255)},//认缴出资额
            subscribedCapital:{type:Sequelize.STRING(255)},//认缴出资额数额
            subscribedCapitalUnit:{type:Sequelize.STRING(255)},//认缴出资额单位
            subscribedCapitalCCY:{type:Sequelize.STRING(255)},//认缴出资额币种
            startDate:{type:Sequelize.DATE},//成立日期，精确到天，如“2022-01-01"
            status:{type:Sequelize.STRING(255)},//企业状态
            investDate:{type:Sequelize.DATE},//投资日期，精确到天，如“2022-01-01'
            operName:{type:Sequelize.STRING(255)},//被投资法定代表人
        },
        association: []
    },
    // {
    //     tableNameCn:'招投标信息',// todo
    //     tableName:'tendering ',
    //     schema:{
    //         tenderId: {
    //             type:Sequelize.STRING(255), //表示属性的数据类型
    //             allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
    //             primaryKey:true, //表示主键
    //             unique:true //表示该列的值必须唯一
    //         },
    //         eId:{type:Sequelize.STRING(255), allowNull:false}, //关联企业id
          
    //     },
    //     association: []
    // },
    {
        tableNameCn:'管理后台用户',
        tableName:'adminUser',
        schema:{
            aId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            loginId: {type:Sequelize.STRING(255), allowNull:false}, //用户
            pwd: {type:Sequelize.STRING(255)}, //密码
            token: {type:Sequelize.STRING(255)}, //token
            tokenMs: {type:Sequelize.DATE}, //token的时间
            name:{type:Sequelize.STRING(255)},//用户名称
        },
        association: []
    },
]; 