/**
 * 零碎的通用工具
 */

import moment = require("moment");
import { changeEnumManyValue, changeEnumValue } from "./verificationEnum";


/**
 * 匹配新旧对象变化
 * 将newObj 与 oldObj 比对，将newObj中发生变化的key返回
 * 使用前需要校验对象中的内容
 * @param newObj 新对象
 * @param oldObj 旧对象
 * @returns [key] 发生变化的key
 */
export function checkChange(newObj, oldObj) {
    let changeKeyList:string[] = [];
    for (let newKey in newObj) {
        if (`${newObj[newKey]}` != `${oldObj[newKey]}`) changeKeyList.push(newKey);
    }
    return changeKeyList;
}

/**
 * 根据conf截取data中的数据
 * @param conf 
 * @param data 
 * @returns 
 */
export function extractData(conf, data) {
    let result = {};
    for (let key in conf) {
        let confInfo = conf[key];
        if (confInfo.changeDate) {
            result[key] = data[key] || 0;
        } else if (confInfo.isAdd) {
            let addStr = "";
            data[key].forEach(str => {
                addStr += str;
            });
            result[key] = addStr;
        } else if (confInfo.changeManyEnum) {
            result[key] = changeEnumManyValue(confInfo.changeManyEnum, data[key]);
        } else if (confInfo.changeEnum) {
            result[key] = changeEnumValue(confInfo.changeManyEnum, data[key]);
        }else {
            result[key] = data[key];
            if (typeof result[key] == 'string' && !result[key]) result[key] = '';
        }
    }
    return result;
}


export function changeAdd(list) {
    let addStr = "";
    if (!list) return ""
    list.forEach(str => {
        addStr += str;
    });
    return addStr;
}

/**
 * 校验数据对象是否有空
 * @param data 
 * @param sensitive  敏感校验  true时  0 和 ""会校验失败  false时 校验成功
 * @returns true/false true = 有空值   false=无空值
 */
export function checkDataHaveNull(data:object, sensitive:boolean) {
    if (Array.isArray(data)) return data.length == 0;
    if (Object.keys(data).length == 0) return true;
    
    let success = false;
    for (let key in data) {
        if (data[key] == null || data[key] == undefined) success = true;
        if (sensitive) {
            if (data[key] === 0 || data[key] === "" ) success = true;
        }
    }
    return success;
}