/**
 * 系统中使用的工具
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");
import pinyin from 'pinyin';
const md5 = require("md5");

/**
 * 返回编辑正确的结果
 * @returns 
 */
 export function successResult() {
    return {success:true}
}



/**
 * 生成任务草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}



/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}


/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 校验uscc是否合法
 * @param uscc 
 * @returns true/false 
 */
export function eccUscc(uscc:string) {
    let isSuccess = false;
    if (uscc.search(/^[A-Za-z0-9]{16}$/) > -1) isSuccess = true;
    else if (uscc.search(/^[A-Za-z0-9]{18}$/) > -1) isSuccess = true;
    return isSuccess;
}


export function randomId(tableName:string) {
    let randomStr = `${new Date().valueOf()}_${Math.ceil(Math.random()*100000)}`;
    return `${tableName}_${md5(randomStr)}`;
}

export function getMySqlMs(time?) {
    time = time || new Date().valueOf();
    return moment(time).format("YYYY-MM-DD HH:mm:ss");
    // return moment(time).format("YYYY");
}

export function randomCode() {
    return `${Math.ceil(Math.random()*10000)}`
}



/**
 * 转换名称为拼音首字母
 * @param name 
 * @returns 
 */
export function getPinyinInitials(name) {
    // const result = pinyin(name, {
    //   style: pinyin.STYLE_FIRST_LETTER, // 只获取首字母
    //   heteronym: false                 // 不启用多音字模式
    // });
    
    // // 将二维数组转换为一维字符串，如 "阿里巴巴" -> "albb"
    // return result.map(item => item[0].charAt(0)).join('').toUpperCase();

    let keepNumber = true; //是否保留数字
    let keepSymbol = true; //是否保留符号
  
    return name.split('')
        .map(char => {
        if (/[\u4e00-\u9fa5]/.test(char)) {
            return pinyin(char, { style: pinyin.STYLE_FIRST_LETTER })[0][0].toUpperCase();
        } else if (/[a-zA-Z]/.test(char)) {
            return char.toUpperCase();
        } else if (/\d/.test(char) && keepNumber) { // 保留数字
            return char;
        } else if (keepSymbol) { // 保留符号
            return char;
        } else {
            return '';
        }
        })
    .join('');
}

