/**
 * 请求工具
 */

import * as request from 'request';
import { BizError } from './bizError';

/**
 * 请求接口（get）
 * @param url 路由
 * @param query 请求参数
 * @param headers 请求头
 * @returns 
 */
export function get(url:string, query?, headers?) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject)=>{
        let paramater:any = { url, json:true };
        if (query) paramater.qs = query;
        if (headers) paramater.headers = headers;
        request.get(paramater, function (err, r, body) {
            if (err) return reject(err);
            if (r && r.statusCode != 200) return reject(new Error('httpError:'+r.statusCode));
            resolve(body);
        });
    })
}


export function getQcc(url:string, query?, headers?) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject)=>{
        let paramater:any = { url, json:true };
        if (query) paramater.qs = query;
        if (headers) paramater.headers = headers;
        request.get(paramater, function (err, r, body) {
            if (err) return reject(err);
            if (body) {
                if (body.Status == 200) return resolve(body.Result);
                else if (body.Status == 201) return resolve({});
            }
            return reject(new Error('httpError:'+r.statusCode));
        });
    })
}

export function post(url, body, headers) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    let header = {"content-type": "application/json"};  
    return new Promise((resolve, reject)=>{
        request({
            url: url,
            method: "POST",
            json: true,
            headers: Object.assign(header, headers),
            body: body
        }, function(error, response, resBody) {
            if (!error && response.statusCode == 200) {
                resolve(resBody);
            }
            else {
                reject(error);
            }
        });
    })
}

export function postForm(url, body, headers) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject)=>{
        request({
            url: url,
            method: "POST",
            json: true,
            form:body
        }, function(error, response, res) {
            if (!error) {
                resolve(res);
            }
            else {
                reject(error)
            }
        });
    })
}

export function cozePost(url, body, headers) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    let header = {"content-type": "application/json"};  
    return new Promise((resolve, reject)=>{
        request({
            url: url,
            method: "POST",
            json: true,
            headers: Object.assign(header, headers),
            body: body
        }, function(error, response, resBody) {
            if (!error) {
                resolve(resBody);
            }
            else {
                resolve(error);
            }
        });
    })
}


export function cozeGet(url:string, query?, headers?) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject)=>{
        let paramater:any = { url, json:true };
        if (query) paramater.qs = query;
        if (headers) paramater.headers = headers;
        request.get(paramater, function (err, r, body) {
            if (!err) {
                resolve(body);
            }
            else {
                resolve(err);
            }
        });
    })
}
