/**
 * 企业网页填报入孵申请
 */

import * as asyncHandler from 'express-async-handler';
import * as userRuFuBiz from '../biz/userRuFu';

export function setRouter(httpServer) {
    httpServer.post('/admin/enterprise/rufu/register', asyncHandler(register));
    httpServer.post('/admin/enterprise/rufu/login', asyncHandler(login));
    httpServer.post('/admin/enterprise/rufu/rufustate', asyncHandler(ruFuState));
    httpServer.post('/admin/enterprise/rufu/add', asyncHandler(addRuFu));
    httpServer.post('/admin/enterprise/rufu/info', asyncHandler(getRuFu));
    httpServer.post('/admin/enterprise/rufu/update', asyncHandler(updateRuFu));

}


/**
 * 注册
 * @param req 
 * @param res 
 */
 async function register(req, res) {
    let {userName, phone, pwd } = req.body
    let result = await userRuFuBiz.enterpriseRegister(userName, phone, pwd);
    res.success(result);
}


/**
 * 登录
 * @param req 
 * @param res 
 */
 async function login(req, res) {
    let {phone, pwd } = req.body
    let result = await userRuFuBiz.enterpriseLogin(phone, pwd);
    res.success(result);
}



/**
 * 登录
 * @param req 
 * @param res 
 */
 async function ruFuState(req, res) {
    let {uId } = req.body
    let result = await userRuFuBiz.getRuFuState(uId);
    res.success(result);
}


/**
 * 添加入孵企业
 * @param req 
 * @param res 
 */
 async function addRuFu(req, res) {
    let { uId, param } = req.body;
    let result = await userRuFuBiz.createRuFu(uId, param);

    res.success(result);
}


/**
 * 企业入孵材料回显
 * @param req 
 * @param res 
 */
 async function getRuFu(req, res) {
    let { eId } = req.body
    let result = await userRuFuBiz.getRuFu(eId);

    res.success(result);
}


/**
 * 管理员编辑企业材料
 * @param req 
 * @param res 
 */
 async function updateRuFu(req, res) {
    let { eId, param } = req.body
    let result = await userRuFuBiz.updateRuFu(eId, param);

    res.success(result);
}





