/**
 * 网页端企业自己申请入孵
 */

import moment = require("moment");
import { eccFormParam } from "../util/verificationParam";
import { AdminRegisterAddConfig, AdminRegisterUpdateConfig, UserRegisterAddConfig } from "../config/eccParam/enterprise";
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import { operationalData, selectData, selectManyTableData } from "../data/operationalData";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/enum/errorEnum";
import { getMySqlMs, getToken, randomId } from "../tools/system";
import { extractData } from "../util/piecemeal";
import { EnterpriseApplyForConfig } from "../config/splitResult/enterprise";
import { FUHUASTATE, RUFUSTATE, STATE } from "../config/enum/enum";


/**
 * 注册
 * @param phone 
 * @param pwd 
 * @returns 
 */
 export async function enterpriseRegister(userName:string, phone:string, pwd:string) {
    /**校验密码 */
    if (pwd.search(/^[A-Za-z0-9]{6,18}$/) < 0) throw new BizError(ERRORENUM.密码只能由6至18位字符和数字组成);

    /**校验去重 */
    let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业用户表, {phone}, ["uId"]);
    if (userInfo && userInfo.uId) throw new BizError(ERRORENUM.手机号码重复);

    let addUInfo = {
        uId:randomId(TABLEID.企业用户表),
        userName,
        phone,
        pwd
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业用户表, addUInfo, {});
    
    return {isSuccess:true};
}


/**
 * 登录
 * @param phone 
 * @param pwd 
 * @returns 
 */
export async function enterpriseLogin(phone:string, pwd:string) {
    let enterpriseUserInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业用户表, {phone}, ["uId", "phone", "pwd", "eId"]);

    if (!enterpriseUserInfo || !enterpriseUserInfo.uId) throw new BizError(ERRORENUM.账号不存在);
    if (enterpriseUserInfo.pwd != pwd) throw new BizError(ERRORENUM.账号或密码错误);

    let updateUserInfo = {
        token : getToken(enterpriseUserInfo.uId),
        tokenMs : getMySqlMs()
    };
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业用户表, updateUserInfo, {uId:enterpriseUserInfo.uId});

    let userInfo = {
        userId:enterpriseUserInfo.uId,
        userName:enterpriseUserInfo.userName,
        phone:enterpriseUserInfo.phone,
        token:updateUserInfo.token,
        eId:enterpriseUserInfo.eId || ""
    };

    return {dataInfo:userInfo};
}


/**
 * 获取入孵流程状态
 * @param uId 
 * @returns 
 */
export async function getRuFuState(uId) {
    let enterpriseUserInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业用户表, {uId}, ["uId", "phone", "pwd", "eId"]);

    let ruFuState = 0;
    if (!enterpriseUserInfo.eId) {
        ruFuState = RUFUSTATE.信息填写;
    } else {
        let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId:enterpriseUserInfo.eId}, ["enterpriseName", "eId", "state", "register"]);
        if (enterpriseInfo.state == STATE.否 && enterpriseInfo.register == STATE.否) ruFuState = RUFUSTATE.信息审核中;
        if (enterpriseInfo.state == STATE.否 && enterpriseInfo.register == STATE.是) {
            let leaseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.租赁信息, {eId:enterpriseUserInfo.eId}, []);
            if (!leaseInfo.leaseContract && !leaseInfo.entryPlan || !leaseInfo.businessLicense || !leaseInfo.agreement) ruFuState = RUFUSTATE.补充材料;
            else ruFuState = RUFUSTATE.材料已提交;
        }
        // if (enterpriseInfo.register == 2) ruFuState = RUFUSTATE.材料审核驳回;
        if (enterpriseInfo.state == STATE.是 && enterpriseInfo.register == STATE.是) ruFuState = RUFUSTATE.材料审核完成;
    }
    
    return {ruFuState};
}


/**
 * 添加信息填写
 */
export async function createRuFu(uId, param) {
    const FuncName = "网页添加信息填写"
    eccFormParam(FuncName, UserRegisterAddConfig, param );

    let filesList = ["eId", "uscc"];
    let enterpriseUserInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc:param.uscc}, filesList);

    if (enterpriseUserInfo && enterpriseUserInfo.eId) {
        throw new BizError(ERRORENUM.企业已存在);
    }
    
    let addEInfo = {
        eId:randomId(TABLEID.企业基础信息表),
        enterpriseName:param.enterpriseName,
        uscc:param.uscc,
        logonTime:getMySqlMs(param.logonTime),
        logonAddress:JSON.stringify(["", "", "", param.logonAddress]),
        mail:param.mail,//邮箱地址
        state:0,
        register:0
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业基础信息表, addEInfo, {});
    console.log("addEInfo", addEInfo);
    

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业用户表, {eId:addEInfo.eId}, {uId});

    let fuHuaInfo = {
        eId:addEInfo.eId,
        fId:randomId(TABLEID.企业孵化信息),
        startTime:getMySqlMs(param.fuHuaTimeStart),
        endTime:getMySqlMs(param.fuHuaTimeEndTime),
        state:0,
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业孵化信息, fuHuaInfo, {});

    let leaseInfo = {
        eId:addEInfo.eId,
        leaseId:randomId(TABLEID.租赁信息),
        // area:param.area,
        area: param.area || null, // 可为空
        unitPrice:param.unitPrice,
        // roomNumber:param.roomNumber,
        buillding: param.building|| null, // 楼号
        roomNumber: param.roomNumber || null,// 室号
        // startTime:getMySqlMs(param.fuHuaTimeStart), //小程序和管理后台没有填写租赁时间的位置，直接使用孵化开始时间
        // endTime:getMySqlMs(param.fuHuaTimeEndTime), //小程序和管理后台没有填写租赁时间的位置，直接使用孵化结束时间
        startTime: getMySqlMs(param.leaseStartTime),  // 租赁开始时间
        endTime: getMySqlMs(param.leaseEndTime),      // 租赁结束时间
        rent:param.rent,
    }
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.租赁信息, leaseInfo, {});

    let addUInfo = {
        eId:addEInfo.eId,
        uId:randomId(TABLEID.企业用户表),
        phone:param.phone,
        pwd:param.pwd,
        userName:param.userName
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业用户表, addUInfo, {});

    return {eId:addEInfo.eId};
    
}


/**
 * 入孵材料回显
 * @param eId 
 * @returns 
 */
export async function getRuFu(eId:string) {
    let filesList = ["eId", "uscc", "enterpriseName", "logonAddress", "logonTime"];
    let enterpriseUserInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);
    if (!enterpriseUserInfo || !enterpriseUserInfo.eId) {
        throw new BizError(ERRORENUM.请先申请入孵);
    }
    let leaseFilesList = ["leaseId", "area", "leaseContract", "entryPlan", "businessLicense", "agreement"];
    let leaseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.租赁信息, {eId}, leaseFilesList);
    enterpriseUserInfo.logonAddress = JSON.parse(enterpriseUserInfo.logonAddress);

    let zaifuList = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业孵化信息, {eId}, ["startTime", "endTime"]);
    let dataInfo:any = extractData(EnterpriseApplyForConfig, enterpriseUserInfo);

    dataInfo.logonTime = moment(enterpriseUserInfo.logonTime).format("YYYY-MM-DD");
    if (zaifuList.startTime) dataInfo.startTime = new Date(zaifuList.startTime).valueOf(); //孵化开始时间
    else dataInfo.startTime = "";
    if (zaifuList.endTime) dataInfo.endTime = new Date(zaifuList.endTime).valueOf(); //孵化结束时间
    else dataInfo.endTime = "";
    // if (zaifuList.startTime || zaifuList.endTime) dataInfo.leaseTime = `${moment(zaifuList.startTime).format("YYYY-MM-DD")}至${moment(zaifuList.endTime).format("YYYY-MM-DD")}`;
    
    dataInfo.area = leaseInfo.area;

    dataInfo.leaseContract = leaseInfo.leaseContract;
    dataInfo.entryPlan = leaseInfo.entryPlan;
    dataInfo.businessLicense = leaseInfo.businessLicense;
    dataInfo.agreement = leaseInfo.agreement;

    dataInfo.leaseContractModelUrl = "/yuyi/files/房屋租赁合同模板.docx";
    dataInfo.entryPlanModelUrl = "/yuyi/files/孵化企业入驻计划.xlsx";
    dataInfo.businessLicenseUrl = "/yuyi/files/营业执照复印件.docx";
    dataInfo.agreementModelUrl = "/yuyi/files/孵化协议模板.docx";

    return {dataInfo};
}


/**
 * 编辑入孵材料
 * @param eId 
 * @param param 
 * @returns 
 */
export async function updateRuFu(eId:string, param) {
    const FuncName = "网页修改入驻信息";
    eccFormParam(FuncName, AdminRegisterUpdateConfig, param );
    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "state"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);
    if (!resInfo || !resInfo.eId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.state == 1) {
        throw new BizError(ERRORENUM.已审核请前往小程序登录)
    }

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.租赁信息, param, {eId});

    return {isSuccess:true};
}






