/**
 * 服务
 */

import { ApplyForUpdateConfig, GardenNoticeUpdateConfig, PolicyUpdateConfig, RegisterUpdateConfig, SettleInForUpdateConfig } from "../config/eccParam/enterprise";
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import * as enumConfig from "../config/enum/enum";
import { operationalData, selectData, selectManyTableData } from "../data/operationalData";
import { BizError } from "../util/bizError";
import { eccFormParam } from "../util/verificationParam";
import { ERRORENUM } from "../config/enum/errorEnum";
import { getMySqlMs, getToken, md5PwdStr, randomCode, randomId } from "../tools/system";
import moment = require("moment");
import { changeAdd, extractData } from "../util/piecemeal";
import { EnterpriseApplyForConfig } from "../config/splitResult/enterprise";
import { changeEnumValue } from "../util/verificationEnum";



export async function enterpriseService(enterpriseName, followUpStatus, page) {
    let selectParam:any = {};
    if (followUpStatus) {
        selectParam.followUpStatus = followUpStatus;
    }
    let filesList = ["esId", "needCategory", "applyTime", "followUpStatus", "resolveTime", "needContent"];
    let manyTableInfo:any = {};
    manyTableInfo[TABLENAME.企业基础信息表] = {column:["eId",  "enterpriseName"], where:{} };
    if (enterpriseName) {
        manyTableInfo[TABLENAME.企业基础信息表].where = {enterpriseName:{"%like%":enterpriseName}}
    }
    let resList = await selectManyTableData(OPERATIONALDATATYPE.多表分页, TABLENAME.企业服务表, selectParam, filesList, manyTableInfo, page );
    let allResList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业服务表, selectParam, ["esId"], manyTableInfo, page );

    
    let dataList = [];
    resList.forEach(info => {
        dataList.push({
            esId:info.esId,
            needCategory:changeEnumValue(enumConfig.NEEDCATEGORY, info.needCategory),
            applyTime:moment(info.applyTime).format("YYYY-MM-DD HH:mm"),
            followUpStatus:changeEnumValue(enumConfig.FOLLOWUPSTATUS, info.followUpStatus),
            resolveTime:info.resolveTime ? moment(info.resolveTime).format("YYYY-MM-DD HH:mm") : '-',
            enterpriseName:info.enterprise.enterpriseName,
            needContent:info.needContent
        });
    });

    return {dataList, dataCount:allResList.length};
}


/**
 * 受理
 * @param esId 
 * @param fangKui 
 * @returns 
 */
export async function enterpriseServiceOption(esId:string, fangKui:string) {
    let selectParam:any = {esId};
    let filesList = ["esId"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业服务表, selectParam, filesList);
    if ( !resInfo || !resInfo.esId) {
        throw new BizError(ERRORENUM.数据不存在);
    }

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业服务表, {fangKui, followUpStatus:enumConfig.FOLLOWUPSTATUS.受理中, shouLiTime:getMySqlMs()}, {esId});

    return {
        isSuccess:true
    };
}


/**
 * 结束
 * @param esId 
 * @param outcome 
 * @param desc 
 * @returns 
 */
export async function enterpriseServiceEnd(esId:string, outcome:number, desc:string) {
    let selectParam:any = {esId};
    let filesList = ["esId"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业服务表, selectParam, filesList);
    if ( !resInfo || !resInfo.esId) {
        throw new BizError(ERRORENUM.数据不存在);
    }

    let updateInfo = {outcome, followUpStatus:enumConfig.FOLLOWUPSTATUS.已完成, desc, resolveTime:getMySqlMs()};
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业服务表,updateInfo, {esId});

    return {
        isSuccess:true
    };
}