//初始化企查查数据

import { systemConfig } from "../config/serverConfig";
import { onceSheetBecomeOfblockData } from "../util/analysisExcel";
const md5 = require("md5");
import moment = require("moment");
import { getQcc } from "../util/request";
const xlsx = require('node-xlsx');
const path = require('path');
const fs = require('fs');


export async function qccData() {
    let 企业名单 = onceSheetBecomeOfblockData('在孵企业导入1210.xlsx', "Sheet1");
    let dataList = 企业名单[0].blockData;
    let titleList = ["企业名称", "注册时间", "注册地址", "注册资本", "实缴资本", "上市类型", "投资人", "联系方式", "行业分类", "标签", "软著", "风险提示", "专利数", "失信核查", "资质数量", "融资信息"];
    let excelList = [titleList];
    for (let i =1; i < dataList.length; i++) {
        
        let uscc = dataList[i][6];
        let res = await 同步数据(uscc);
        excelList.push(res);
        console.log(i);
    }
    
    let data = [
        {
            name:"sheet1",
            data:excelList
        }
    ];
    let buff = xlsx.build(data);
    fs.writeFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", '在孵企业excel.xlsx' ), buff);
    
   console.log();
}


async function 同步数据(uscc:string) {
    const TimeSpan = Math.round(new Date().valueOf()/ 1000);
    let header = {
        Token:md5(`${systemConfig.qccKey}${TimeSpan}${systemConfig.qccSecretKey}`).toUpperCase(),
        TimeSpan
    };
    let query = {
        key:systemConfig.qccKey,
        searchKey:uscc,
        // keyNo:"云合智网（上海）技术有限公司"
    };
    // let 工商信息:any = await getQcc('https://api.qichacha.com/ECIInfoVerify/GetInfo', query, header);//获取工商信息
    await 工商信息(query, header);
    
   
    // //联系信息
    // let TagListStr = "";//企业标签
    // if (工商信息.TagList) {
    //     工商信息.TagList.forEach(item => {
    //         TagListStr += `${item.Name};`
    //     });
    // }
   
    // let 著作权软著:any = await getQcc('https://api.qichacha.com/CopyRight/SearchCopyRight', query, header);
    // let 准入尽职调查:any = await getQcc('https://api.qichacha.com/AcctScan/GetInfo', query, header);
    // let 专利查询:any = await getQcc('https://api.qichacha.com/PatentV4/Search', query, header);
    // let 失信核查:any = await getQcc('https://api.qichacha.com/ShixinCheck/GetList', query, header);
    // let 资质证书:any = await getQcc('https://api.qichacha.com/ECICertification/SearchCertification', query, header);
    // let 融资信息:any = await getQcc('https://api.qichacha.com/CompanyFinancingSearch/GetList', query, header);
    

    return [];
}


async function 工商信息(query, header) {
    let keyDescMap = {
        "Partners":"工商登记股东信息（返回前100条）",
        "Employees":"主要人员（返回前100条）",
        "Branches":"分支机构（返回前100条）",
        "ChangeRecords":"变更信息（返回前100条）",
        "ContactInfo":"联系信息",
        "Industry":"国民行业分类",
        "Area":"行政区域",
        "RevokeInfo":"注销吊销信息",
        "EmergingIndustyList":"新兴行业分类（保留字段）",
        "InsuredCount":"参保人数",
        "EnglishName":"英文名",
        "PersonScope":"人员规模",
        "IXCode":"进出口企业代码",
        "TagList":"企业标签\企业画像",
        "ARContactList":"最新企业年报中的联系方式",
        "EconKindCodeList":"企业类型数组(具体枚举值请查看附件)",
        "KeyNo":"主键",
        "QccCode":"企查查编码（企查查科技股份有限公司推出，为全球各类商业实体提供唯一的识别码）",
        "Name":"企业名称",
        "No":"根据企业性质的不同返回不同的值，具体如下：EntType = 0/1/4/6/7/9/10/11/-1 中国境内企业时：该字段返回工商注册号；EntType = 3 中国香港企业时：该字段返回企业编号；EntType = 5 中国台湾企业时：该字段返回企业编号",
        "BelongOrg":"登记机关",
        "OperId":"法定代表人ID",
        "OperName":"法定代表人名称",
        "StartDate":"成立日期",
        "EndDate":"吊销日期",
        "Status":"登记状态",
        "Province":"省份",
        "UpdatedDate":"更新日期",
        "CreditCode":"根据企业性质的不同返回不同的值，具体如下：EntType = 0/1/4/6/7/9/10/11/-1 中国境内企业时：该字段返回统一社会信用代码；EntType = 3 中国香港企业时：该字段返回商业登记号码",
        "RegistCapi":"注册资本",
        "RegisteredCapital":"注册资本数额",
        "RegisteredCapitalUnit":"注册资本单位",
        "RegisteredCapitalCCY":"注册资本币种",
        "EconKind":"企业类型",
        "Address":"注册地址",
        "Scope":"经营范围",
        "TermStart":"营业期限始",
        "TermEnd":"营业 核准日期",
        "OrgNo":"组织机构代码",
        "IsOnStock":"是否上市（0-未上市，1-上市）",
        "StockNumber":"股票代码（如A股和港股同时存在，优先显示A股代码）",
        "StockType":"上市类型（A股、港股、美股、新三板、新四板）",
        "OriginalName":"曾用名",
        "ImageUrl":"企业Logo地址",
        "EntType":"企业性质，0-大陆企业，1-社会组织 ，3-中国香港公司，4-事业单位，5-中国台湾公司，6-基金会，7-医院，8-海外公司，9-律师事务所，10-学校 ，11-机关单位，-1-其他",
        "RecCap":"实缴资本",
        "PaidUpCapital":"实缴出资额数额",
        "PaidUpCapitalUnit":"实缴出资额单位",
        "PaidUpCapitalCCY":"实缴出资额币种",
        "AreaCode":"行政区划代码"
    };
    let 工商信息:any = await getQcc('https://api.qichacha.com/ECIInfoVerify/GetInfo', query, header);//获取工商信息
    let TagListStr = "";//企业标签

}


async function 企查查数据集(uscc) {
    
    const TimeSpan = Math.round(new Date().valueOf()/ 1000);
    let header = {
        Token:md5(`${systemConfig.qccKey}${TimeSpan}${systemConfig.qccSecretKey}`).toUpperCase(),
        TimeSpan
    };
    let query = {
        key:systemConfig.qccKey,
        searchKey:uscc,
        // keyNo:"云合智网（上海）技术有限公司"
    };
    let 工商信息:any = await getQcc('https://api.qichacha.com/ECIInfoVerify/GetInfo', query, header);//获取工商信息
    
    let keyList = ["Name", "StartDate", "Address", "RegistCapi", "RecCap", "StockType"];

    let dataList = [];
    keyList.forEach(str => {
        dataList.push(工商信息[str] || "-");
    });
    let PartnersStr = "";//投资人
    if (工商信息.Partners) {
        工商信息.Partners.forEach(item => {
            PartnersStr += `${item.StockName}:${item.StockPercent};`
        });
    }
    dataList.push(PartnersStr);
    dataList.push(工商信息.ContactInfo.PhoneNumber||"-");
    dataList.push(工商信息.Industry.Industry||"-");
    //联系信息
    let TagListStr = "";//企业标签
    if (工商信息.TagList) {
        工商信息.TagList.forEach(item => {
            TagListStr += `${item.Name};`
        });
    }
    dataList.push(TagListStr);
   
    let 著作权软著:any = await getQcc('https://api.qichacha.com/CopyRight/SearchCopyRight', query, header);

    let 著作权软著Str = "";
    if(Object.keys(著作权软著).length) {
        著作权软著.forEach(item => {
            著作权软著Str += item.Name;
        });
    }
    dataList.push(著作权软著Str);

    let 准入尽职调查:any = await getQcc('https://api.qichacha.com/AcctScan/GetInfo', query, header);
    let 风险 = "";
    if (准入尽职调查.Data) {
        准入尽职调查.Data.forEach(item => {
            风险 += item.Title;
        });
    }
    dataList.push(风险);

    let 专利查询:any = await getQcc('https://api.qichacha.com/PatentV4/Search', query, header);
    let 专利查询Str = 0;
    if (Object.keys(专利查询).length) {
        专利查询.forEach(item=> {
            专利查询Str += item.items.length;
        })
    }
    dataList.push(专利查询Str);

    let 失信核查:any = await getQcc('https://api.qichacha.com/ShixinCheck/GetList', query, header);
    let 失信核查Str = 失信核查.VerifyResult ?? "-";
    dataList.push(失信核查Str);

    let 资质证书:any = await getQcc('https://api.qichacha.com/ECICertification/SearchCertification', query, header);
    let 资质证书Str = 0;
    if (Object.keys(资质证书).length) {
        资质证书Str = 资质证书.length;
    }
    dataList.push(资质证书Str);

    let 融资信息:any = await getQcc('https://api.qichacha.com/CompanyFinancingSearch/GetList', query, header);
    
    let 融资信息Str = "";
    if (融资信息.Data) {
        融资信息.Data.forEach(item => {
            融资信息Str += `${item.Amount};` 
        })
    }
    dataList.push(融资信息Str);

    return dataList;
}