import { checkUser } from "../middleware/user";
import * as asyncHandler from 'express-async-handler';
import * as fuhuaBiz from '../biz/fuhua';



export function setRouter(httpServer) {
    // httpServer.post('/admin/fuhua/base', checkUser, asyncHandler(baseData));
    httpServer.post('/admin/fuhua/base', checkUser, asyncHandler(baseData));//
    httpServer.post('/admin/fuhua/operate', checkUser, asyncHandler(operateData));
    httpServer.post('/admin/fuhua/risk', checkUser, asyncHandler(riskData));
    httpServer.post('/admin/fuhua/worth', checkUser, asyncHandler(worthDate));
    httpServer.post('/admin/fuhua/rufu/add', checkUser, asyncHandler(addRuFu));
    httpServer.post('/admin/fuhua/rufu/info', checkUser, asyncHandler(getRuFu));
    httpServer.post('/admin/fuhua/rufu/update', checkUser, asyncHandler(updateRuFu));//
    httpServer.post('/admin/fuhua/yuyi/info', checkUser, asyncHandler(yuYiRuFu));
    httpServer.post('/admin/fuhua/yuyi/update', checkUser, asyncHandler(updateYuYi));
}


/**
 * 孵化器看板基本信息
 * @param req 
 * @param res 
 */
async function baseData(req, res) {
    let result = await fuhuaBiz.getBaseData();

    res.success(result);
}


/**
 * 运营分析
 * @param req 
 * @param res 
 */
async function operateData(req, res) {
    let {year} = req.body;
    let result = await fuhuaBiz.getOperateData(year);

    res.success(result);
}


/**
 * 风险预警
 * @param req 
 * @param res 
 */
async function riskData(req, res) {
    let result = await fuhuaBiz.getRiskData();

    res.success(result);
}


/**
 * 价值分析
 * @param req 
 * @param res 
 */
async function worthDate(req, res) {
    let result = await fuhuaBiz.getWorthDate();

    res.success(result);
}


/**
 * 添加入孵企业
 * @param req 
 * @param res 
 */
async function addRuFu(req, res) {
    let { param } = req.body;
    let result = await fuhuaBiz.createRuFu(param);

    res.success(result);
}


/**
 * 企业入孵材料回显
 * @param req 
 * @param res 
 */
async function getRuFu(req, res) {
    let { eId } = req.body
    let result = await fuhuaBiz.getRuFu(eId);

    res.success(result);
}


/**
 * 管理员编辑企业材料
 * @param req 
 * @param res 
 */
async function updateRuFu(req, res) {
    let { eId, param } = req.body
    let result = await fuhuaBiz.updateRuFu(eId, param);

    res.success(result);
}


/**
 * 雨艺孵化器基本信息回显
 */
async function yuYiRuFu(req, res) {
    let result = await fuhuaBiz.getYuYiFuHua();

    res.success(result);
}



async function updateYuYi(req, res) {
    let { yId, param } = req.body
    let result = await fuhuaBiz.updateYuYi(yId, param);

    res.success(result);
}



