/**
 * 小程序端  企业入口  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseInfoBiz from '../biz/admin';
import * as zaiFuBiz from '../biz/zaiFu';
import * as tongZhiBiz from '../biz/tongZhi';
import * as userBiz from '../biz/user';
import * as zhengCeBiz from '../biz/zhengCe';
import * as fuWuBiz from '../biz/fuWu';
import * as ruFuBiz from '../biz/ruFu';
import { checkEnterpriseUser, checkUser } from '../middleware/user';
import { ERRORENUM } from '../config/enum/errorEnum';
import { BizError } from '../util/bizError';

export function setRouter(httpServer) {
    //管理员登录登出
    httpServer.post('/admin/user/login', asyncHandler(login));
    httpServer.post('/admin/user/logout', checkUser, asyncHandler(logout));

    // //新入孵企业
    httpServer.post('/admin/enterprise/settlein/list', checkUser, asyncHandler(settleIn));
    httpServer.post('/admin/enterprise/settlein/pass', checkUser, asyncHandler(settleInPass));
    httpServer.post('/admin/enterprise/settlein/update', checkUser, asyncHandler(settleUpdate));
    httpServer.post('/admin/enterprise/settlein/out', checkUser, asyncHandler(settleInOut));
    //审核
    httpServer.post('/admin/enterprise/settlein/examine/list', checkUser, asyncHandler(examineSettleIn));
    httpServer.post('/admin/enterprise/settlein/examine/pass', checkUser, asyncHandler(examineSettleInPass));
    httpServer.post('/admin/enterprise/settlein/examine/out', checkUser, asyncHandler(examineSettleInOut));
    
    // //通知
    httpServer.post('/admin/notice/list', checkUser, asyncHandler(noticeList));
    httpServer.post('/admin/notice/add', checkUser, asyncHandler(noticeAdd));
    httpServer.post('/admin/notice/info', checkUser, asyncHandler(noticeInfo));
    httpServer.post('/admin/notice/update', checkUser, asyncHandler(noticeUpdate));
    httpServer.post('/admin/notice/delete', checkUser, asyncHandler(noticeDel));

    // //任务填报审核
    httpServer.post('/admin/task/examine/list', checkUser, asyncHandler(examineList));
    httpServer.post('/admin/task/examine/info', checkUser, asyncHandler(examineInfo));
    httpServer.post('/admin/task/examine/update', checkUser, asyncHandler(examineUpdate));
    httpServer.post('/admin/task/examine/submit', checkUser, asyncHandler(examineSub));

    //企业库信息
    httpServer.post('/admin/library/enterprise/list', checkUser, asyncHandler(enterpriseList));
    httpServer.post('/admin/library/enterprise/migrate/out', checkUser, asyncHandler(enterpriseMigrateOut));//在孵企业迁出功能
    httpServer.post('/admin/library/enterprise/migrate/list', checkUser, asyncHandler(enterpriseMigrateList));//新增迁出企业
    httpServer.post('/admin/library/enterprise/details', checkUser, asyncHandler(enterpriseDetails));
    // httpServer.post('/admin/library/enterprise/details', checkUser, asyncHandler(enterpriseById));
    // httpServer.post('/admin/library/manage/details', checkUser, asyncHandler(manageById));
    // httpServer.post('/admin/library/financing/details', checkUser, asyncHandler(financingById));
    // httpServer.post('/admin/library/talent/details', checkUser, asyncHandler(talentById));
    // httpServer.post('/admin/library/service/details', checkUser, asyncHandler(serviceById));
    httpServer.post('/admin/library/dw/enterprise/list', checkUser, asyncHandler(dwEnterpriseList));//下载
    // httpServer.post('/admin/library/dw/enterprise/out/list', checkUser, asyncHandler(dwEnterpriseOutList));//迁出企业下载
    httpServer.post('/admin/library/dw/alloutput/list', checkUser, asyncHandler(getAllDwOutPutData));//在孵企业单企业下载
    httpServer.post('/admin/library/dw/businessdata/list', checkUser, asyncHandler(dwBusinessDataList));//单企业经营数据下载
    httpServer.post('/admin/library/dw/financingsituatione/list', checkUser, asyncHandler(dwFinancingSituationeList));//单企业融资情况下载

    httpServer.post('/admin/library/manage/list', checkUser, asyncHandler(manageList));
    httpServer.post('/admin/library/dw/manage/list', checkUser, asyncHandler(outPutManageList));
    
    httpServer.post('/admin/library/manage/pass', checkUser, asyncHandler(managePass));
    httpServer.post('/admin/library/financing/list', checkUser, asyncHandler(financingList));
    httpServer.post('/admin/library/financing/allyear', checkUser, asyncHandler(financingAllYear));
    httpServer.post('/admin/library/dw/financing/list', checkUser, asyncHandler(outPutFinancingList));
    
    httpServer.post('/admin/library/talent/list', checkUser, asyncHandler(talentList));
    httpServer.post('/admin/library/dw/talent/list', checkUser, asyncHandler(outPutTalentList));
    
    // //政策
    httpServer.post('/admin/policy/list', checkUser, asyncHandler(policyList));
    httpServer.post('/admin/policy/add', checkUser, asyncHandler(policyAdd));
    httpServer.post('/admin/policy/info', checkUser, asyncHandler(policyInfo));
    httpServer.post('/admin/policy/update', checkUser, asyncHandler(policyUpdate));
    httpServer.post('/admin/policy/delete', checkUser, asyncHandler(policyDel));

    //数据同步
    // httpServer.post('/admin/datasync/enterprise/list', checkUser, asyncHandler());
    // httpServer.post('/admin/datasync/enterprise/submit', checkUser, asyncHandler());

    //企业端
    httpServer.post('/admin/enterprise/login', asyncHandler(enterpriseLogin));
    httpServer.post('/admin/enterprise/logout', checkEnterpriseUser, asyncHandler(enterpriseLogout));
    httpServer.post('/admin/enterprise/info', checkEnterpriseUser, asyncHandler(entepriseInfo));
    httpServer.post('/admin/enterprise/update', checkEnterpriseUser, asyncHandler(updateEntepriseInfo));
    //所有企业列表
    httpServer.post('/admin/enterprise/alllist', checkUser, asyncHandler(allList));

    httpServer.post('/admin/service/list', checkUser, asyncHandler(serviceList));
    httpServer.post('/admin/service/fangkui', checkUser, asyncHandler(serviceFangKui));
    httpServer.post('/admin/service/end', checkUser, asyncHandler(serviceEnd));

    httpServer.post('/admin/enterprise/register', asyncHandler(enterpriseLogon));

    httpServer.post('/admin/library/ipr/list', checkUser, asyncHandler(iprList));
    httpServer.post('/admin/library/ipr/details', checkUser, asyncHandler(iprDetails));

    httpServer.post('/admin/library/qualification/list', checkUser, asyncHandler(qualificationList));
    httpServer.post('/admin/library/honor/list', checkUser, asyncHandler(enterpriseHonor));

}

async function iprList(req, res) {
    const UserInfo = req.userInfo;
    let { entepriseName, page } = req.body
    let result = await enterpriseInfoBiz.iprList(entepriseName, page);

    res.success(result);
}

async function iprDetails(req, res) {
    const UserInfo = req.userInfo;
    let { eId } = req.body
    let result = await enterpriseInfoBiz.getiprDetails(eId);

    res.success(result);
}




async function qualificationList(req, res) {
    const UserInfo = req.userInfo;
    let { entepriseName, page } = req.body
    let result = await enterpriseInfoBiz.qiyeRenZheng(entepriseName, page);

    res.success(result);
}

async function enterpriseHonor(req, res) {
    const UserInfo = req.userInfo;
    let { entepriseName, page } = req.body
    let result = await enterpriseInfoBiz.enterpriseHonor(entepriseName, page);

    res.success(result);
}

async function serviceList(req, res) {
    const UserInfo = req.userInfo;
    let { entepriseName, followUpStatus, page } = req.body
    let result = await fuWuBiz.enterpriseService(entepriseName, followUpStatus, page);

    res.success(result);
}
async function serviceFangKui(req, res) {
    const UserInfo = req.userInfo;
    let { fangKui, esId } = req.body
    let result = await fuWuBiz.enterpriseServiceOption(esId, fangKui);

    res.success(result);
}
async function serviceEnd(req, res) {
    const UserInfo = req.userInfo;
    let { esId, outcome, desc } = req.body
    let result = await fuWuBiz.enterpriseServiceEnd(esId, outcome, desc);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function allList(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.allEnterpriseNameList();

    res.success(result);
}



/**
 * 
 * @param req 
 * @param res 
 */
async function entepriseInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.enterpriseApplyFor(UserInfo.eId );

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function updateEntepriseInfo(req, res) {
    const UserInfo = req.userInfo;
    let { param } = req.body
    let result = await enterpriseInfoBiz.updateEnterpriseApplyFor(UserInfo.eId, param );

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function enterpriseLogin(req, res) {
    let {loginId, pwd } = req.body
    let result = await userBiz.enterpriseLogin(loginId, pwd );

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function enterpriseLogout(req, res) {
    let {loginId, pwd } = req.body;
    const UserInfo = req.userInfo;
    let result = await userBiz.enterpriseLogout(UserInfo.eId );

    res.success(result);
}



/**
 * 
 * @param req 
 * @param res 
 */
async function policyList(req, res) {
    const UserInfo = req.userInfo;
    let {keywords, state, page } = req.body
    let result = await zhengCeBiz.enterprisePolicyList(keywords, state, page);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function policyAdd(req, res) {
    const UserInfo = req.userInfo;
    let { param } = req.body
    let result = await zhengCeBiz.enterprisePolicyAdd(param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function policyInfo(req, res) {
    const UserInfo = req.userInfo;
    let { poId } = req.body
    let result = await zhengCeBiz.enterprisePolicyInfo(poId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function policyUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {poId, param } = req.body
    let result = await zhengCeBiz.enterprisePolicyUpdate(poId, param);

    res.success(result);
}



/**
 * 
 * @param req 
 * @param res 
 */
async function policyDel(req, res) {
    const UserInfo = req.userInfo;
    let {poId } = req.body
    let result = await zhengCeBiz.enterprisePolicyDelete(poId);

    res.success(result);
}







/**
 * 
 * @param req 
 * @param res 
 */
async function talentList(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, page } = req.body
    let result = await enterpriseInfoBiz.enterpriseTalentList(entepriseName, page);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function outPutTalentList(req, res) {
    const UserInfo = req.userInfo;
    let {name, type, files } = req.body
    let result = await enterpriseInfoBiz.outPutEnterpriseTalentList(name, type, files);

    res.success(result);
}




/**
 * 
 * @param req 
 * @param res 
 */
async function enterpriseList(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, page } = req.body
    let result = await zaiFuBiz.enterpriseList(entepriseName, page);

    res.success(result);
}


/**
 * 在孵企业迁出功能
 * @param req 
 * @param res 
 */
async function enterpriseMigrateOut(req, res) {
    const UserInfo = req.userInfo;
    let { eId, moveOutType } = req.body
    let result = await zaiFuBiz.enterpriseMoveOut(eId, moveOutType);

    res.success(result);
}

/**
 * 迁出企业列表
 * @param req 
 * @param res 
 */
async function enterpriseMigrateList(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, page } = req.body
    let result = await zaiFuBiz.enterpriseMigrateList(entepriseName, page);

    res.success(result);
}

async function enterpriseDetails(req, res) {
    const UserInfo = req.userInfo;
    let {eId } = req.body
    let result = await zaiFuBiz.getDetails(eId);

    res.success(result);
}


// async function enterpriseById(req, res) {
//     const UserInfo = req.userInfo;
//     let {eId } = req.body
//     let result = await zaiFuBiz.enterpriseById(eId);

//     res.success(result);
// }


// async function manageById(req, res) {
//     const UserInfo = req.userInfo;
//     let {eId } = req.body
//     let result = await zaiFuBiz.enterpriseManageById(eId);

//     res.success(result);
// }


// async function financingById(req, res) {
//     const UserInfo = req.userInfo;
//     let {eId } = req.body
//     let result = await zaiFuBiz.enterpriseFinancingById(eId);

//     res.success(result);
// }


// async function talentById(req, res) {
//     const UserInfo = req.userInfo;
//     let {eId } = req.body
//     let result = await zaiFuBiz.enterpriseTalentById(eId);

//     res.success(result);
// }


// async function serviceById(req, res) {
//     const UserInfo = req.userInfo;
//     let {eId } = req.body
//     let result = await zaiFuBiz.enterpriseServiceById(eId);

//     res.success(result);
// }


/**
 * 下载
 * @param req 
 * @param res 
 */
async function dwEnterpriseList(req, res) {
    let {entepriseName, type, files } = req.body
    let result = await zaiFuBiz.dwEnterpriseTable(entepriseName, type, files);

    res.success(result);
}


/**
 * 迁出企业下载
 * @param req 
 * @param res 
 */
async function dwEnterpriseOutList(req, res) {
    let {entepriseName, type, files } = req.body
    let result = await zaiFuBiz.dwEnterpriseOutTable(entepriseName, type, files);

    res.success(result);
}

/**
 * 在孵企业下载
 * @param req 
 * @param res 
 */
async function getAllDwOutPutData(req, res) {
    let {eId} = req.body

    let result = await zaiFuBiz.getAllDwOutPut(eId);

    res.success(result);
}


// /**
//  * 单企业基本信息下载
//  * @param req 
//  * @param res 
//  */
// async function dwBasicInformationList(req, res) {
//     let {eId} = req.body
//     let result = await zaiFuBiz.dwBasicInformation(eId);//基本信息下载

//     res.success(result);
// }

/**
 * 单企业经营数据下载
 * @param req 
 * @param res 
 */
async function dwBusinessDataList(req, res) {
    let {eId} = req.body
    let result = await zaiFuBiz.dwBusinessData(eId);

    res.success(result);
}

/**
 * 单企业融资情况下载
 * @param req 
 * @param res 
 */
async function dwFinancingSituationeList(req, res) {
    let {eId} = req.body
    let result = await zaiFuBiz.dwFinancingSituatione(eId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function manageList(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, year, page } = req.body
    let result = await enterpriseInfoBiz.enterpriseManageList(entepriseName, year, page);

    res.success(result);
}

async function outPutManageList(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, year, type, files } = req.body
    let result = await enterpriseInfoBiz.outPutEnterpriseManageList(entepriseName, year, type, files);

    res.success(result);
}




async function managePass(req, res) {
    const UserInfo = req.userInfo;
    let {mId } = req.body
    // let result = await enterpriseInfoBiz.enterpriseManagePass(mId);

    // res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function financingList(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, year, page} = req.body
    let result = await enterpriseInfoBiz.enterpriseFinancingList(entepriseName, year, page);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function financingAllYear(req, res) {
    const UserInfo = req.userInfo;
    let {eId } = req.body
    let result = await enterpriseInfoBiz.enterpriseFinancingAllYear(eId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function outPutFinancingList(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, year, type, files } = req.body
    let result = await enterpriseInfoBiz.outPutEnterpriseFinancingList(entepriseName, year, type, files);

    res.success(result);
}




/**
 * 
 * @param req 
 * @param res 
 */
async function examineList(req, res) {
    const UserInfo = req.userInfo;
    let {year, entepriseName, page } = req.body
    let result = await enterpriseInfoBiz.enterpriseExamineList(year, entepriseName, page);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function examineSub(req, res) {
    // const UserInfo = req.userInfo;
    // let { mId } = req.body
    // let result = await enterpriseInfoBiz.enterpriseExaminePass(mId);

    // res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function examineUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {mId, param } = req.body
    let result = await enterpriseInfoBiz.enterpriseExamineUpdate(mId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function examineInfo(req, res) {
    const UserInfo = req.userInfo;
    let { mId } = req.body
    let result = await enterpriseInfoBiz.enterpriseExamineInfo(mId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function noticeList(req, res) {
    const UserInfo = req.userInfo;
    let {keywords, page } = req.body
    let result = await tongZhiBiz.gardenNoticeList(keywords, page);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function noticeInfo(req, res) {
    const UserInfo = req.userInfo;
    let { gnId } = req.body
    let result = await tongZhiBiz.gardenNoticeInfo(gnId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function noticeUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {gnId, param } = req.body
    let result = await tongZhiBiz.gardenNoticeUpdate(gnId, param);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function noticeDel(req, res) {
    const UserInfo = req.userInfo;
    let {gnId } = req.body
    let result = await tongZhiBiz.gardenNoticeDelete(gnId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function noticeAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param } = req.body
    let result = await tongZhiBiz.gardenNoticeAdd(param);

    res.success(result);
}


//----------------------------------------------登录

/**
 * 
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let {loginId, pwd } = req.body
    let result = await userBiz.adminLogin(loginId, pwd );

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function logout(req, res) {
    const UserInfo = req.userInfo;
    let result = await userBiz.adminLogout(UserInfo.uId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function settleIn(req, res) {
    const UserInfo = req.userInfo;
    let {entepriseName, page } = req.body
    let result = await ruFuBiz.settleInEnterpriseList(page, entepriseName);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function settleInPass(req, res) {
    const UserInfo = req.userInfo;
    let { eId } = req.body
    let result = await ruFuBiz.settleInEnterprisePass(eId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function settleInOut(req, res) {
    const UserInfo = req.userInfo;
    let { eId } = req.body
    let result = await ruFuBiz.settleInEnterpriseOut(eId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function settleUpdate(req, res) {
    const UserInfo = req.userInfo;
    let { eId, param } = req.body
    let result = await ruFuBiz.settleInEnterpriseUpdate(eId, param);

    res.success(result);
}


async function enterpriseLogon(req, res) {

    const UserInfo = req.userInfo;
    let { param } = req.body;
    let result = await ruFuBiz.enterpriseRegister(param);

    res.success(result);
}


//===

async function examineSettleIn(req, res) {

    const UserInfo = req.userInfo;
    let {entepriseName, page } = req.body
    let result = await ruFuBiz.enterpriseRegisterExamineList(entepriseName, page);

    res.success(result);
}

async function examineSettleInPass(req, res) {

    const UserInfo = req.userInfo;
    let { eId } = req.body;
    let result = await ruFuBiz.enterpriseRegisterExaminePass(eId);

    res.success(result);
}

async function examineSettleInOut(req, res) {

    const UserInfo = req.userInfo;
    let { eId } = req.body;
    let result = await ruFuBiz.enterpriseRegisterExamineOut(eId);

    res.success(result);
}
