/**
 * 校验表单参数配置 【小程序】
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */

export const GardenNoticeUpdateConfig = {
    title:{type:"String"},// 标题
    content:{type:"String"},// 内容
    isPublished:{type:"Number"},// 是否发布（1：是，0：否）
    publishTime:{type:"Number"},// 发布时间
    relatedEnterprise:{type:"[String]"},// 关联企业
}


export const PolicyUpdateConfig = {
    title:{type:"String"},// 标题
    desc:{type:"String"},// 内容
    source:{type:"String"},// 来源
    coverImg:{type:"[String]"},// 图片
    closeTimeMs:{type:"Number"},// 关闭时间
    isPermanent:{type:"Number"}//是否永久有效
}


export const ApplyForUpdateConfig = {
    leaseContract:{type:"String"},// 房屋租赁合同链接
    entryPlan:{type:"String"},// 入驻计划复印件链接
    businessLicense:{type:"String"},// 营业执照复印件链接
    agreement:{type:"String"},// 孵化协议链接
}

export const SettleInForUpdateConfig = {
    enterpriseName:{type:"String"},
    uscc:{type:"String"},//信用代码
    logonTime:{type:"Number"},//注册时间
    logonAddress:{type:"String"},//注册地址
    fuHuaTimeStart:{type:"Number"},//孵化开始时间
    fuHuaTimeEndTime:{type:"Number"},//孵化结束时间
    area:{type:"Number"},//面积
    // unitPrice:{type:"Number"},//单价
    roomNumber:{type:"String"},//室号
    rent:{type:"Number"},//每月租金
    // totalPrice:{type:"Number"},//总价
    pwd:{type:"String"},
    phone:{type:"String"},
    userName:{type:"String"},
    uId:{type:"String"}
}

export const RegisterUpdateConfig = {
    enterpriseName:{type:"String"},//企业名称
    logonAddress:{type:"String"},//注册地址
    uscc:{type:"String"},//统一信用代码
    leaseTimeStart:{type:"Number"},//租赁开始时间
    leaseTimeEnd:{type:"Number"},//租赁结束时间
    logonTime:{type:"Number"},//注册时间
    area:{type:"Number"},//面积
}

export const AdminRegisterAddConfig = {
    // enterpriseName:{type:"String"},//企业名称
    // uscc:{type:"String"},//统一信用代码
    // logonTime:{type:"Number"},//注册日期
    // logonAddress:{type:"String"},//注册地址
    // fuHuaTimeStart:{type:"Number"},//孵化开始时间
    // fuHuaTimeEndTime:{type:"Number"},//孵化结束时间
    // area:{type:"Number"},//面积
    enterpriseName:{type:"String"},
    uscc:{type:"String"},//信用代码
    logonTime:{type:"Number"},//注册时间
    logonAddress:{type:"String"},//注册地址
    fuHuaTimeStart:{type:"Number"},//孵化开始时间
    fuHuaTimeEndTime:{type:"Number"},//孵化结束时间
    area:{type:"Number"},//面积
    // unitPrice:{type:"Number"},//单价
    roomNumber:{type:"String"},//室号
    rent:{type:"Number"},//每月租金
    // totalPrice:{type:"Number"},//总价
    pwd:{type:"String"},
    phone:{type:"String"},
    userName:{type:"String"}
}


export const AdminRegisterUpdateConfig = {
    leaseContract:{type:"String"},// 房屋租赁合同链接
    entryPlan:{type:"String"},// 入驻计划复印件链接
    businessLicense:{type:"String"},// 营业执照复印件链接
    agreement:{type:"String"},// 孵化协议链接
}


export const YuYiBaseDataUpdateConfig = {
    operateName:{type:"String"},//运营名称
    name:{type:"String"},//孵化器名称
    registerTime:{type:"String"},//注册时间
    incubateLv:{type:"String"},//孵化级别
    incubateTime:{type:"String"},//孵化器认定时间
    incubateField:{type:"String"},//孵化领域
    natureInstitution:{type:"String"},//机构性质
    contacts:{type:"String"},//联系人
    personCharge:{type:"String"},//负责人
    phone:{type:"String"},//手机号码
    synopsis:{type:"String"},//简介
    totalArea:{type:"String"},//总面积
    zaifuArea:{type:"String"},//在孵面积
    ziyonArea:{type:"String"},//自用面积
    parkArea:{type:"String"},//新增
    industrialScale:{type:"String"},
    enterpriseNum:{type:"Number"},
    totalAssetInvestmentAmount:{type:"String"},
    numberOfInstitutionsIntroduced:{type:"String"},
    introduceInstitutionalInvestment:{type:"String"}
}



