/**
 * 新入孵
 */
import { ApplyForUpdateConfig, GardenNoticeUpdateConfig, PolicyUpdateConfig, RegisterUpdateConfig, SettleInForUpdateConfig } from "../config/eccParam/enterprise";
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import * as enumConfig from "../config/enum/enum";
import { operationalData, selectData, selectManyTableData } from "../data/operationalData";
import { BizError } from "../util/bizError";
import { eccFormParam } from "../util/verificationParam";
import { ERRORENUM } from "../config/enum/errorEnum";
import { getMySqlMs, getToken, md5PwdStr, randomCode, randomId } from "../tools/system";
import moment = require("moment");
import { changeAdd, extractData } from "../util/piecemeal";
import { EnterpriseApplyForConfig } from "../config/splitResult/enterprise";
import { changeEnumValue } from "../util/verificationEnum";


//=======================================================新入孵企业

export async function settleInEnterpriseList(page:number, entepriseName:string) {

    let selectParam:any = {state:enumConfig.STATE.否, register:enumConfig.STATE.否};
    if (entepriseName) selectParam.enterpriseName = {"%like%":entepriseName};

    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "logonAddress"];

    let manyTableInfo:any = {}
    manyTableInfo[TABLENAME.租赁信息] = {column:["area", "unitPrice", "roomNumber", "rent", "totalPrice"], where:{} };
    manyTableInfo[TABLENAME.企业孵化信息] = {column:["state", "startTime", "endTime"], where:{} };
    manyTableInfo[TABLENAME.企业用户表] = {column:["userName", "pwd", "phone", "uId"], where:{} };
    let resList = await selectManyTableData(OPERATIONALDATATYPE.多表分页, TABLENAME.企业基础信息表, selectParam, filesList, manyTableInfo, page );
    let allResList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, selectParam, ["eId"], manyTableInfo );

    let dataList = [];
    resList.forEach(info => {
        dataList.push({
            eId:info.eId,
            enterpriseName:info.enterpriseName,
            uscc:info.uscc,
            logonTime:moment(info.logonTime).format("YYYY-MM-DD"),
            leaseTime:`${moment(info.enterprise_leases[0].startTime).format("YYYY-MM-DD")}至${moment(info.enterprise_leases[0].endTime).format("YYYY-MM-DD")}`,
            leaseTimeStart:info.enterprise_leases[0].startTime || 0,
            leaseTimeEnd:info.enterprise_leases[0].endTime || 0,
            fuHuaTimeStart:info.enterprise_fuhuas[0].startTime||0,
            fuHuaTimeEnd:info.enterprise_fuhuas[0].endTime||0,
            area:info.enterprise_leases[0].area,
            unitPrice:info.enterprise_leases[0].unitPrice,
            roomNumber:info.enterprise_leases[0].roomNumber,
            rent:info.enterprise_leases[0].rent,
            logonAddress:changeAdd(JSON.parse(info.logonAddress)),
            userName:info.enterprise_users[0].userName,
            pwd:info.enterprise_users[0].pwd,
            phone:info.enterprise_users[0].phone,
            uId:info.enterprise_users[0].uId,
            totalPrice: info.enterprise_leases[0].totalPrice // 添加年总价字段
        });
    });

    return {dataList, dataCount:allResList.length};
}

export async function settleInEnterprisePass(eId:string) {
    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "state"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);

    if (!resInfo || !resInfo.eId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.state) throw new BizError(ERRORENUM.该企业已通过审核);
    
    let updateInfo = {
        register:enumConfig.STATE.是,
        randomCode:randomCode()
    }
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业基础信息表, updateInfo, {eId});

    return {isSuccess:true};
}

export async function settleInEnterpriseUpdate(eId:string, param) {
    const FuncName = "修改入驻信息";
    eccFormParam(FuncName, SettleInForUpdateConfig, param );

    let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业用户表, {phone:param.phone}, ["uId"]);
    if (userInfo && userInfo.uId &&  userInfo.uId != param.uId) throw new BizError(ERRORENUM.手机号码重复);

    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "state"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);
    if (!resInfo || !resInfo.eId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.state) throw new BizError(ERRORENUM.该企业已通过审核);

    let updateInfo = {
        enterpriseName:param.enterpriseName,
        uscc:param.uscc,
        logonTime:param.logonTime,
        logonAddress:JSON.stringify(["", "", "", param.logonAddress]),
    };
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业基础信息表, updateInfo, {eId});
    
    let fuHuaInfo = {
        startTime:param.fuHuaTimeStart,
        endTime:param.fuHuaTimeEndTime,
        state:enumConfig.FUHUASTATE.实体孵化
    };
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业孵化信息, fuHuaInfo, {eId});

    let leaseInfo = {
        area:param.area,
        // unitPrice:param.unitPrice,
        // unitPrice:param.rent / param.area,// 计算单价

        //如果 param.rent 和 param.area 都存在且不为零，则计算 unitPrice 为 param.rent 除以 param.area；否则，直接使用 param.unitPrice。
        unitPrice: param.rent && param.area ? param.rent / param.area : param.unitPrice, 
        rent:param.rent,
    }
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.租赁信息, leaseInfo, {eId});


    let addUInfo = {
        phone:param.phone,
        pwd:param.pwd,
        userName:param.userName
    };
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业用户表, addUInfo, {eId, uId:param.uId});
    
    return {isSuccess:true};
}


export async function settleInEnterpriseOut(eId:string) {
    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "state"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);

    if (!resInfo || !resInfo.eId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.state) throw new BizError(ERRORENUM.该企业已通过审核);

    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.企业用户表, {}, {eId});//
    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.企业孵化信息, {}, {eId});
    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.租赁信息, {}, {eId});
    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.企业基础信息表, {}, {eId});

    return {isSuccess:true};
}


//入孵信息审核
export async function enterpriseRegisterExamineList(entepriseName, page) {
    
    let selectParam:any = {register:enumConfig.STATE.是, state:enumConfig.STATE.否};
    if (entepriseName) selectParam.enterpriseName = {"%like%":entepriseName};

    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "randomCode"];

    let manyTableInfo:any = {}
    manyTableInfo[TABLENAME.租赁信息] = {column:["leaseContract", "entryPlan", "businessLicense", "agreement"], where:{} };
    manyTableInfo[TABLENAME.企业孵化信息] = {column:["state", "startTime", "endTime"], where:{} };
    let resList = await selectManyTableData(OPERATIONALDATATYPE.多表分页, TABLENAME.企业基础信息表, selectParam, filesList, manyTableInfo, page );
    let allResList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, selectParam, ["eId"], manyTableInfo );

    let dataList = [];
    resList.forEach(info => {
        dataList.push({
            eId:info.eId,
            enterpriseName:info.enterpriseName,
            randomCode:info.randomCode,
            leaseContract:info.enterprise_leases[0].leaseContract || "未提交",
            entryPlan:info.enterprise_leases[0].entryPlan || "未提交",
            businessLicense:info.enterprise_leases[0].businessLicense || "未提交",
            agreement:info.enterprise_leases[0].agreement || "未提交"
        });
    });

    return {dataList, dataCount:allResList.length};
}

export async function enterpriseRegisterExaminePass(eId:string) {
    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "state"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);

    if (!resInfo || !resInfo.eId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.state) throw new BizError(ERRORENUM.该企业已通过审核);


    
    let updateInfo = {
        state:enumConfig.STATE.是
    }
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业基础信息表, updateInfo, {eId});

    return {isSuccess:true};
}


export async function enterpriseRegisterExamineOut(eId:string) {
    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "state"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);

    if (!resInfo || !resInfo.eId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.state) throw new BizError(ERRORENUM.该企业已通过审核);

    let updateInfo = {
        register:2
    }
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业基础信息表, updateInfo, {eId});

    return {isSuccess:true};
}




export async function enterpriseRegister(param) {
    const FuncName = "企业注册"
    eccFormParam(FuncName, RegisterUpdateConfig, param );

    let filesList = ["eId", ];
    let enterpriseUserInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc:param.uscc}, filesList);
    if (enterpriseUserInfo && enterpriseUserInfo.eId) {
        throw new BizError(ERRORENUM.企业已存在);
    }
    
    let addEInfo = {
        eId:randomId(TABLEID.企业基础信息表),
        enterpriseName:param.enterpriseName,
        logonAddress:JSON.stringify(["", "", "", param.logonAddress]),
        uscc:param.uscc,
        logonTime:getMySqlMs(param.logonTime),
        state:0,
        register:0,
        rent: param.rent
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业基础信息表, addEInfo, {});

    let fuHuaInfo = {
        eId:addEInfo.eId,
        fId:randomId(TABLEID.企业孵化信息)
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业孵化信息, fuHuaInfo, {});

    let leaseInfo = {
        eId:addEInfo.eId,
        leaseId:randomId(TABLEID.租赁信息),
        startTime:getMySqlMs(param.leaseTimeStart),
        endTime:getMySqlMs(param.leaseTimeEnd),
        area:param.area

    }
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.租赁信息, leaseInfo, {});
   
    return {isSuccess:true};
}

