/**
 * 孵化器看板
 */

import moment = require("moment");
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import { EMIGRATIONTYPE, FUHUASTATE, INCOME, INDUSTRY, STATE } from "../config/enum/enum";
import { operationalData, selectData, selectManyTableData } from "../data/operationalData";
import { getMySqlMs, randomId } from "../tools/system";
import { changeEnumValue } from "../util/verificationEnum";
import { eccFormParam } from "../util/verificationParam";
import { AdminRegisterAddConfig, AdminRegisterUpdateConfig, YuYiBaseDataUpdateConfig } from "../config/eccParam/enterprise";
import { ERRORENUM } from "../config/enum/errorEnum";
import { BizError } from "../util/bizError";
import { extractData } from "../util/piecemeal";
import { EnterpriseApplyForConfig, YuYiBaseDataConfig } from "../config/splitResult/enterprise";


/**
 * 基本信息
 * @returns 
 */
export async function getBaseData() {
    let nowTime = getMySqlMs(new Date());

    let baseData = {
        fuhuaData:{ //孵化器数据
            "总面积":0, //没有
            "在孵面积":0,
            "自用面积":0,
            "在孵企业":0,
            "迁出企业":0,
            "毕业企业":0,
            "园区面积":0,//新增
            "产业规模": 0,
            "总资产投入金额": 0,
            "引入机构数量": 0,
            "引入机构投资": 0,
        },
        fuhuaPinfen:0, //孵化器评分 没有该字段
        fuhuaInfo:{ //孵化器信息
        }
    };

    let filesList = ["eId", "enterpriseName", "uscc", "logonTime"];
    let selectParam = {state:STATE.是};

    /**在孵企业 当前时间小于孵化结束时间 */
    let araeParam = {column:["area", "unitPrice", "roomNumber", "rent"], where:{} };
    let zaifuTableInfo:any = {};
    zaifuTableInfo[TABLENAME.租赁信息] = araeParam;
    zaifuTableInfo[TABLENAME.企业孵化信息] = {column:["state", "startTime", "endTime"], where:{state:{"%ne%":FUHUASTATE.迁出}} };
    let zaifuResList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, selectParam, ["eId"], zaifuTableInfo );
    
    if (zaifuResList) baseData.fuhuaData["在孵企业"] = zaifuResList.length;
    zaifuResList.forEach( info => {
        info.enterprise_leases.forEach( lease => {
            baseData.fuhuaData["在孵面积"] += parseFloat(lease.area);
        })
    })
    // baseData.fuhuaData["在孵面积占比"] = ((baseData.fuhuaData["在孵面积(㎡)"] / baseData.fuhuaData["总面积(㎡)"])*100).toFixed(2) + "%";

    /**迁出企业 */
    let qianchuList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {state:FUHUASTATE.迁出}, {});
    if (qianchuList) baseData.fuhuaData["迁出企业"] = qianchuList.length;

    /**毕业企业 */
    // let biyeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {graduationTime:{"%ne%":null}}, {});
    let biyeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {moveOutType:EMIGRATIONTYPE.毕业迁出}, {});
    if (biyeList) baseData.fuhuaData["毕业企业"] = biyeList.length;
    
    /**孵化器信息 */
    let yuyiList = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.羽翼孵化器信息, {}, []);
    if (yuyiList) {
        baseData.fuhuaData["总面积"] = yuyiList.totalArea;
        baseData.fuhuaData["在孵面积"] = yuyiList.zaifuArea;
        baseData.fuhuaData["自用面积"] = yuyiList.ziyonArea;   
        baseData.fuhuaData["园区面积"] = yuyiList.parkArea;//新增
        baseData.fuhuaData["产业规模"] = yuyiList.industrialScale;
        baseData.fuhuaData["总资产投入金额"] = yuyiList.totalAssetInvestmentAmount;
        baseData.fuhuaData["引入机构数量"] = yuyiList.numberOfInstitutionsIntroduced;
        baseData.fuhuaData["引入机构投资"] = yuyiList.introduceInstitutionalInvestment;
        
        baseData.fuhuaInfo = {
            "运营名称":yuyiList.operateName,
            "孵化器名称":yuyiList.name,
            "统一社会信用代码":yuyiList.uscc,
            "注册时间":yuyiList.registerTime,
            "孵化级别":yuyiList.incubateLv,
            "孵化器认定时间":yuyiList.incubateTime,
            "孵化领域":yuyiList.incubateField,
            "机构性质":yuyiList.natureInstitution,
            "是否成立投资基金":yuyiList.fundedReserve,
            "联系人":yuyiList.contacts,
            "负责人":yuyiList.personCharge,
            "手机号码":yuyiList.phone,
            "孵化器简介":yuyiList.synopsis,
        }
    }

    return {baseData};
}


/**
 * 运营分析
 * 出租率变化趋势暂未接入数据库数据
 * 孵化器收入暂未接入数据库数据
 */
export async function getOperateData(year) {
    let yearTime = moment(year).format("YYYY");

    let operateData = {
        "当前在孵企业数":0,
        "在孵企业数变化趋势":{
            "实体孵化":[],
            "虚拟孵化":[],
        },
        "毕业企业数变化趋势":{
            "毕业企业":[]
        },
        "出租率变化趋势":[],
        "在孵企业行业领域":[],
        "孵化器收入":[]
    };
    let qushiConf = {"01":0, "02":0, "03":0, "04":0, "05":0, "06":0, "07":0, "08":0, "09":0, "10":0, "11":0, "12":0};
    // let qushiConf = ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];

    /**在孵企业 */
    // let zaifuParam = {state:{"%notIn%":FUHUASTATE.迁出}};
    let zaifuParam = {startTime:{"%lt%":yearTime}, endTime:{"%gt%":yearTime}, state:{"%notIn%":FUHUASTATE.迁出}};
    let zaifuList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, zaifuParam, {});
    operateData.当前在孵企业数 = zaifuList.length;
    let zaifuStateInfo = {
        "实体孵化":qushiConf, 
        "虚拟孵化":qushiConf
    };
    zaifuList.forEach( info => {
        let state = changeEnumValue(FUHUASTATE, info.state);
        let time = moment(info.endTime).format("YYYY-MM");
        let year = moment(info.endTime).format("YYYY");
        let month = moment(info.endTime).format("MM");
        if (!zaifuStateInfo[state]) zaifuStateInfo[state] = {};
        if (year == yearTime) {
            zaifuStateInfo[state][month] += 1;
        }
    })

    for (let key in zaifuStateInfo["实体孵化"]) {
        operateData.在孵企业数变化趋势.实体孵化.push({key, value:zaifuStateInfo["实体孵化"][key].toString()});
    }
    //X轴排序
    operateData.在孵企业数变化趋势.实体孵化.sort( (a, b) => {
        return a.key - b.key;
    })

    for (let key in zaifuStateInfo["虚拟孵化"]) {
        operateData.在孵企业数变化趋势.虚拟孵化.push({key, value:zaifuStateInfo["虚拟孵化"][key].toString()});
    }
    //X轴排序
    operateData.在孵企业数变化趋势.虚拟孵化.sort( (a, b) => {
        return a.key - b.key;
    })


    /**毕业企业 */
    let biyeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {graduationTime:{"%ne%":null}}, {});
    let biyeInfo = qushiConf;
    biyeList.forEach( info => {
        let year = moment(info.graduationTime).format("YYYY");
        let month = moment(info.graduationTime).format("MM");
        if (year == yearTime) {
            biyeInfo[month] += 1;
        }
    })

    for(let key in biyeInfo) {
        operateData.毕业企业数变化趋势.毕业企业.push({key, value:biyeInfo[key].toString()});
    }
    //X轴排序
    operateData.毕业企业数变化趋势.毕业企业.sort( (a, b) => {
        return a.key - b.key;
    })


    /**出租率 */
    let chuzulvParam = {startTime:{"%lt%":yearTime}, endTime:{"%gt%":yearTime}};
    // let chuzulvList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME., chuzulvParam);
    let chuzulvInfo = qushiConf;
    for(let key in chuzulvInfo) {
        operateData.出租率变化趋势.push({key, value:chuzulvInfo[key].toString()});
    }
    //X轴排序
    operateData.出租率变化趋势.sort( (a, b) => {
        return a.key - b.key;
    })


    /**在孵企业行业领域 */
    /**在孵企业 当前时间小于孵化结束时间 */
    let araeParam = {column:["area", "unitPrice", "roomNumber", "rent"], where:{} };
    let zaifuTableInfo:any = {};
    zaifuTableInfo[TABLENAME.租赁信息] = araeParam;
    zaifuTableInfo[TABLENAME.企业孵化信息] = {column:["state", "startTime", "endTime"], where:{startTime:{"%lt%":yearTime}, endTime:{"%gt%":yearTime}, state:{"%notIn%":FUHUASTATE.迁出}} };
    // let zaifuList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {endTime:{"%lt%":nowTime}}, {});
    let zaifuResList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {}, ["eId", "industry"], zaifuTableInfo );
    
    for (let key in INDUSTRY) {
        let industryData:any = {};
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            const EnumValue = parseInt(INDUSTRY[key])
            industryData = {key:anyKey, value:0};
            zaifuResList.forEach( info => {
                if (info.industry == EnumValue) {
                    industryData.value += 1;
                }
            })
            operateData.在孵企业行业领域.push(industryData);
        }
    }


    /**孵化器收入 */
    for (let key in INCOME) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            operateData.孵化器收入.push({key:anyKey, value:0});
        }
    }

    return {operateData};
}


/**
 * 风险预警
 * 暂未接入数据库数据
 */
export async function getRiskData() {
    let riskData = [
        {
            key:"出租率异常",
            value:0
        },
        {
            key:"办公地址冲突",
            value:0
        },
        {
            key:"连续未填报",
            value:0
        },
    ]

    return riskData;
}


/**
 * 价值分析
 */
export async function getWorthDate() {
    let worthData = {
        "countData":[
            {
                key:"国际合作/大企业合作机构",
                value:0
            },
            {
                key:"大学/科研院合作机构",
                value:0
            }
        ],
        "TXP":[], //纳税趋势(万元)
        "financing":[], //融资企业数量趋势
        "jiuye":[] //就业人数趋势
    }
    let qushiConf = {"01":0, "02":0, "03":0, "04":0, "05":0, "06":0, "07":0, "08":0, "09":0, "10":0, "11":0, "12":0};

    /**纳税趋势 */
    let nashuiList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, {}, {});
    let nashuiData = {};
    nashuiList.forEach( info => {
        let year = moment(info.annual).format("YYYY");
        if (!nashuiData[year]) nashuiData[year] = 0;
        nashuiData[year] += parseFloat(info.TXP);
    })
    for (let key in nashuiData) {
        worthData.TXP.push({key, value:nashuiData[key].toString()});
    }
    //X轴排序
    worthData.TXP.sort( (a, b) => {
        return a.key - b.key;
    })


    /**融资企业数量趋势 */
    let rongziList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业融资, {}, {});
    let yearTime = moment(new Date()).format("YYYY");
    let rongziInfo = qushiConf;
    rongziList.forEach( info => {
        let year = moment(info.graduationTime).format("YYYY");
        let month = moment(info.graduationTime).format("MM");
        if (year == yearTime) {
            rongziInfo[month] += 1;
        }
    })
    for(let key in rongziInfo) {
        worthData.financing.push({key, value:rongziInfo[key].toString()});
    }
    //X轴排序
    worthData.financing.sort( (a, b) => {
        return a.key - b.key;
    })


    /**就业人数趋势 */
    let jiuyeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.参保记录, {}, {});
    let jiuyeInfo = {};
    jiuyeList.forEach( info => {
        let year = moment(info.annual).format("YYYY");
        if (!jiuyeInfo[year]) jiuyeInfo[year] = 0;
        jiuyeInfo[year] += 1;
    })
    for(let key in jiuyeInfo) {
        worthData.jiuye.push({key, value:jiuyeInfo[key].toString()});
    }
    //X轴排序
    worthData.jiuye.sort( (a, b) => {
        return a.key - b.key;
    })

    return worthData;
}




// ============================== 管理后台操作 ======================================
/**
 * 添加入孵企业
 */
 export async function createRuFu(param) {
    const FuncName = "管理员添加入孵企业"
    eccFormParam(FuncName, AdminRegisterAddConfig, param );


    let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业用户表, {phone:param.phone}, ["uId"]);
    if (userInfo && userInfo.uId) throw new BizError(ERRORENUM.手机号码重复);


    // let filesList = ["eId"];
    let filesList = ["eId", "uscc"];
    let enterpriseUserInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc:param.uscc}, filesList);
    // console.log("查询结果:", enterpriseUserInfo); // 添加日志

    if (enterpriseUserInfo && enterpriseUserInfo.eId) {
        throw new BizError(ERRORENUM.企业已存在);
    }
    
    let addEInfo = {
        eId:randomId(TABLEID.企业基础信息表),
        enterpriseName:param.enterpriseName,
        uscc:param.uscc,
        logonTime:getMySqlMs(param.logonTime),
        logonAddress:JSON.stringify(["", "", "", param.logonAddress]),
        state:0,
        register:0
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业基础信息表, addEInfo, {});

    let addUInfo = {
        eId:addEInfo.eId,
        uId:randomId(TABLEID.企业用户表),
        phone:param.phone,
        pwd:param.pwd,
        userName:param.userName
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业用户表, addUInfo, {});


    let fuHuaInfo = {
        eId:addEInfo.eId,
        fId:randomId(TABLEID.企业孵化信息),
        startTime:getMySqlMs(param.fuHuaTimeStart),
        endTime:getMySqlMs(param.fuHuaTimeEndTime),
        state:0,
    };
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业孵化信息, fuHuaInfo, {});

    let leaseInfo = {
        eId:addEInfo.eId,
        leaseId:randomId(TABLEID.租赁信息),
        area:param.area,
        unitPrice:param.unitPrice,
        roomNumber:param.roomNumber,
        rent:param.rent,
    }
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.租赁信息, leaseInfo, {});



   
    return {isSuccess:true};
}


/**
 * 入孵材料回显
 * @param eId 
 * @returns 
 */
export async function getRuFu(eId:string) {
    let filesList = ["eId", "uscc", "enterpriseName", "logonAddress", "logonTime"];
    let enterpriseUserInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);
    if (!enterpriseUserInfo || !enterpriseUserInfo.eId) {
        throw new BizError(ERRORENUM.请先申请入孵);
    }
    let leaseFilesList = ["leaseId", "area", "leaseContract", "entryPlan", "businessLicense", "agreement"];
    let leaseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.租赁信息, {eId}, leaseFilesList);
    enterpriseUserInfo.logonAddress = JSON.parse(enterpriseUserInfo.logonAddress);

    let zaifuList = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业孵化信息, {eId}, ["startTime", "endTime"]);
    let dataInfo:any = extractData(EnterpriseApplyForConfig, enterpriseUserInfo);

    dataInfo.logonTime = moment(enterpriseUserInfo.logonTime).format("YYYY-MM-DD");
    if (zaifuList.startTime) dataInfo.startTime = new Date(zaifuList.startTime).valueOf(); //孵化开始时间
    else dataInfo.startTime = "";
    if (zaifuList.endTime) dataInfo.endTime = new Date(zaifuList.endTime).valueOf(); //孵化结束时间
    else dataInfo.endTime = "";
    // if (zaifuList.startTime || zaifuList.endTime) dataInfo.leaseTime = `${moment(zaifuList.startTime).format("YYYY-MM-DD")}至${moment(zaifuList.endTime).format("YYYY-MM-DD")}`;
    
    dataInfo.area = leaseInfo.area;

    dataInfo.leaseContract = leaseInfo.leaseContract;
    dataInfo.entryPlan = leaseInfo.entryPlan;
    dataInfo.businessLicense = leaseInfo.businessLicense;
    dataInfo.agreement = leaseInfo.agreement;

    dataInfo.leaseContractModelUrl = "/yuyi/files/房屋租赁合同模板.docx";
    dataInfo.entryPlanModelUrl = "/yuyi/files/孵化企业入驻计划.xlsx";
    dataInfo.businessLicenseUrl = "/yuyi/files/营业执照复印件.docx";
    dataInfo.agreementModelUrl = "/yuyi/files/孵化协议模板.docx";

    return {dataInfo};
}


/**
 * 编辑入孵材料
 * @param eId 
 * @param param 
 * @returns 
 */
export async function updateRuFu(eId:string, param) {
    const FuncName = "管理员修改入驻信息";
    eccFormParam(FuncName, AdminRegisterUpdateConfig, param );
    let filesList = ["eId", "enterpriseName", "uscc", "logonTime", "state"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);
    if (!resInfo || !resInfo.eId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.state == 1) {
        throw new BizError(ERRORENUM.已审核请前往小程序登录)
    } 

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.租赁信息, param, {eId});

    return {isSuccess:true};
}


/**
 * 雨艺孵化器数据回显
 */
export async function getYuYiFuHua() {
    let yuyiInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.羽翼孵化器信息, {uscc:"91310115069312504K"}, []);
    let dataInfo:any = extractData(YuYiBaseDataConfig, yuyiInfo);
    //兼容一下唯一一个number
    dataInfo.enterpriseNum = dataInfo.enterpriseNum || 0;
    return {dataInfo};
}


/**
 * 雨艺孵化器基本信息修改
 * @param yId 
 */
export async function updateYuYi(yId, param) {
    const FuncName = "雨艺孵化器基本信息修改";
    eccFormParam(FuncName, YuYiBaseDataUpdateConfig, param);
    let yuyiInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.羽翼孵化器信息, {yId}, []);
    if (!yuyiInfo || !yuyiInfo.yId) {
        throw new BizError(ERRORENUM.数据不存在);
    }

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.羽翼孵化器信息, param, {yId});

    return {isSuccess:true};
}







