/**
 * 通知
 */

import moment = require("moment");
import { GardenNoticeUpdateConfig } from "../config/eccParam/enterprise";
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import { ERRORENUM } from "../config/enum/errorEnum";
import { operationalData, selectData } from "../data/operationalData";
import { getMySqlMs, randomId } from "../tools/system";
import { BizError } from "../util/bizError";
import { eccFormParam } from "../util/verificationParam";


export async function gardenNoticeList(keywords:string, page:number) {
    let selectParam:any = {};
    if (keywords) selectParam.content = {"%like%":keywords};
    let filesList = ["gnId", "title", "isPublished", "publishTime", "content"];
    // let resList = await selectData(OPERATIONALDATATYPE.分页查询, TABLENAME.园区通知表, {}, filesList, page);
    let resList = await selectData(OPERATIONALDATATYPE.分页查询, TABLENAME.园区通知表, selectParam, filesList, page);

    let dataList = [];
    resList.forEach(info => {
        
        dataList.push({
            gnId:info.gnId,
            title:info.title,
            content:info.content,
            isPublished:info.isPublished,
            publishTime:moment(info.publishTime).format("YYYY-MM-DD")
        });
    });

    return {dataList};
}


export async function gardenNoticeInfo(gnId:string) {
    let filesList = ["gnId", "title", "isPublished", "content", "publishTime", "relatedEnterprise"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.园区通知表, {gnId}, filesList);

    let dataInfo = {
        gnId:resInfo.gnId,//id
        title:resInfo.title,//标题
        content:resInfo.content,//内容
        isPublished:resInfo.isPublished,//是否发布（1：是，0：否）
        publishTime:resInfo.publishTime,//发布时间
        relatedEnterprise:JSON.parse(resInfo.relatedEnterprise || '[]'),//关联企业
    };
    return {dataInfo}
}


export async function gardenNoticeUpdate(gnId:string, param) {
    const FuncName = "修改园区通知"
    eccFormParam(FuncName, GardenNoticeUpdateConfig, param );
    let filesList = ["gnId", "title", "isPublished", "content", "publishTime", "relatedEnterprise"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.园区通知表, {gnId}, filesList);

    if (!resInfo.gnId) throw new BizError(ERRORENUM.数据不存在);

    param.publishTime = getMySqlMs(param.publishTime);
    param.relatedEnterprise = JSON.stringify(param.relatedEnterprise);
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.园区通知表, param, {gnId});

    return {isSuccess:true};
}

export async function gardenNoticeAdd(param) {
    const FuncName = "新增园区通知"
    eccFormParam(FuncName, GardenNoticeUpdateConfig, param );

    param.gnId = randomId(TABLEID.园区通知表);
    param.publishTime = getMySqlMs(param.publishTime);
    param.relatedEnterprise = JSON.stringify(param.relatedEnterprise);
    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.园区通知表, param, {});

    return {isSuccess:true};
}


export async function gardenNoticeDelete(gnId:string) {
    let filesList = ["gnId", "title"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.园区通知表, {gnId}, filesList)
    if (!resInfo || !resInfo.gnId) throw new BizError(ERRORENUM.当前数据不存在); 

    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.园区通知表, {}, {gnId});
    
    return {isSuccess:true};
}