//初始化企查查数据

import { systemConfig } from "../config/serverConfig";
import { onceSheetBecomeOfblockData } from "../util/analysisExcel";
const md5 = require("md5");
import moment = require("moment");
import { getQcc } from "../util/request";
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import { operationalData, selectData } from "../data/operationalData";
import { getMySqlMs, randomId } from "../tools/system";
import { FINANCINGROUNDS, IPRALLTYPE } from "../config/enum/enum";
import { table } from "console";
import { changeEnumValue } from "../util/verificationEnum";
const xlsx = require('node-xlsx');
const path = require('path');
const fs = require('fs');

/**
 * 获取当个excel文件数据
 * @param filePath 
 * @returns 
 */
function getExcel(filePath) {
    const workSheetsFromFile = xlsx.parse(filePath);
    let sheetMap = {};
    let sheetList = [];

    for (let i = 0; i < workSheetsFromFile.length; i++) {
        let sheetInfo = workSheetsFromFile[i];
        sheetMap[sheetInfo.name] = sheetInfo.data;
        sheetList.push(sheetInfo);
    }

    return {sheetMap, sheetList}  
}


export async function 统计() {
    let iMap = 领域补充();
    let fuhuaqiExcelData = getExcel(path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", '在孵企业导入_孵化器提供1210.xlsx' ));
    let data2List = fuhuaqiExcelData.sheetMap['雨艺孵化器孵化企业明细'];
    let {sheetMap} = getExcel(path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", '在孵企业导入1210.xlsx' ));
    let dataList = sheetMap['Sheet1'];

    let usccMap = {};
    dataList.forEach(subList => {
        usccMap[subList[0]] = subList[6];
    })

    let dataMap = {};
    for (let i = 0; i < data2List.length; i++) {
        let subList= data2List[i];
        if (!i) continue;
        let uscc = usccMap[subList[1]];
        let industry = iMap[uscc];
        let 室号 = subList[3];
        let 楼栋 = 室号.substring(0, 室号.indexOf("-"));
        if (industry) {
            if (industry.indexOf(",") > -1) industry = industry.substring(0, industry.indexOf(","));
            else industry = industry;
            
        } else {
            industry = "";
            console.log(楼栋, subList[1])
        }

        let 规模 = await 获取规模(uscc);
        
        if (!dataMap[楼栋]) dataMap[楼栋] = {};
        if (!dataMap[楼栋][industry]) dataMap[楼栋][industry] = {};
        if (!dataMap[楼栋][industry][规模]) dataMap[楼栋][industry][规模] = 0;
        dataMap[楼栋][industry][规模] += 1;
        console.log();
    }
   
    console.log();
}

export async function test() {
    let uscc = "91310115MADM8EA654";
    await 工商信息(uscc);
    await 软件著作(uscc);
    await 国际专利(uscc);
    await 专利查询(uscc);
    await 融资信息核查(uscc);
    console.log();
}

export async function 获取规模(uscc) {
    let {header, query} = getReqParam(uscc);
    
    let 工商信息:any = await getQcc('https://api.qichacha.com/CustomerDueDiligence/KYC', query, header);//获取工商信息
    
    return 工商信息.Data.Scale;
}

export async function qccData() {
    // test();
    // 统计();
    // return
    let iMap = await 领域补充();
    let 企业名单 = onceSheetBecomeOfblockData('在孵企业导入1210.xlsx', "Sheet1");
    let dataList = 企业名单[0].blockData;
    let titleList = ["企业名称", "注册时间", "注册地址", "注册资本", "实缴资本", "上市类型", "投资人", "联系方式", "行业分类", "标签", "软著", "风险提示", "专利数", "失信核查", "资质数量", "融资信息"];
    let excelList = [titleList];
    for (let i =1; i < dataList.length; i++) {

        let uscc = dataList[i][6];
        if (!iMap[uscc]) console.log(dataList[i][0]);
        // continue;
        await awaitData(uscc);
        console.log(`${dataList[i][1]} 同步成功, 下标 ${i}`);
    }
    let enterpriseList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业基础信息表, {}, ["eId", "uscc", "enterpriseName"]);

}

function getReqParam(uscc) {
    const TimeSpan = Math.round(new Date().valueOf()/ 1000);
    let header = {
        Token:md5(`${systemConfig.qccKey}${TimeSpan}${systemConfig.qccSecretKey}`).toUpperCase(),
        TimeSpan
    };
    let query = {
        key:systemConfig.qccKey,
        searchKey:uscc,
        // keyNo:"云合智网（上海）技术有限公司"
    };
    return {header, query};
}


async function addManyData(tableName, dataList) {
    return;
    for (let i= 0; i < dataList.length; i++) {
        let info = dataList[i];

        await operationalData(OPERATIONALDATATYPE.增加, tableName, info, null); 

    }
    console.log(tableName, "写入成功");
}

async function awaitData(uscc:string) {
    await 工商信息(uscc);
    await 软件著作(uscc);
    await 主要人员(uscc);
    await 分支机构(uscc);
    await 行政许可核查(uscc);
    await 空壳扫描(uscc);
    await 准入尽职调查(uscc);
    await 融资信息核查(uscc);
    await 国际专利(uscc);
    await 科创分(uscc);
    await 资质证书(uscc);
    await 专利查询(uscc);
    await 失信核查(uscc);
    await 严重违法核查(uscc);
    await 企业对外投资核查(uscc);

    console.log("企查查数据同步成功");
}


function 领域补充() {
    let 企业名单 = onceSheetBecomeOfblockData('科学城在孵企业.xlsx', "Sheet1");
    let dataList = 企业名单[0].blockData;

    let map = {};
    dataList.forEach((sub, index) => {
        if (!index) return;
        map[sub[6]] = sub[7];
    });

    return map;
}

async function 工商信息(uscc) {
    let {header, query} = getReqParam(uscc);
    
    let 工商信息:any = await getQcc('https://api.qichacha.com/ECIInfoVerify/GetInfo', query, header);//获取工商信息

    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    //股权结构
    if (工商信息.Partners) {
        let ownershipList = [];
        
        工商信息.Partners.forEach(info => {
            let addInfo:any = {
                owId:randomId(TABLEID.股权结构),
                eId,
                name:info.StockName,
                finalBenefitPercent:info.FinalBenefitPercent,
                stockPercent:info.StockPercent,
                stockType:info.StockType,
                realCapi:info.RealCapi,
                paidUpCapitalUnit:info.PaidUpCapitalUnit,
                subscribedCapital:info.SubscribedCapital,
                subscribedCapitalUnit:info.SubscribedCapitalUnit,
            };
            if (info.CapiDate) addInfo.capiDate = getMySqlMs(info.CapiDate);
            if (info.ShoudDate) addInfo.shoudDate = getMySqlMs(info.ShoudDate);

            ownershipList.push(addInfo);
        });
        
        await addManyData(TABLENAME.股权结构, ownershipList);
    }

    if (工商信息.TagList) {
        let enterpriseLabelList = [];
        
        工商信息.TagList.forEach(info => {
            enterpriseLabelList.push({
                elId:randomId(TABLEID.企业标签表),
                eId,
                type:info.Type,
                labelName:info.Name,
            });
        });
        
        await addManyData(TABLENAME.企业标签表, enterpriseLabelList);
    }

    if (工商信息.Industry) {
        let industryInfo = {
            eiId:randomId(TABLEID.行业信息分类),
            eId,
            industryCode:工商信息.Industry.IndustryCode ,//行业门类code
            industry:工商信息.Industry.Industry ,//行业门类描述
            subIndustryCode:工商信息.Industry.SubIndustryCode ,//行业大类code
            subIndustry:工商信息.Industry.SubIndustry ,//行业大类描述
            middleCategoryCode:工商信息.Industry.MiddleCategoryCode ,//行业中类code
            middleCategory:工商信息.Industry.MiddleCategory ,//行业中类描述
            smallCategoryCode:工商信息.Industry.SmallCategoryCode ,//行业小类code
            smallCategory:工商信息.Industry.SmallCategory ,//行业小类描述
        };
        
        await addManyData(TABLENAME.行业信息分类, [industryInfo]);
    }

    if (工商信息.ChangeRecords) {
        let infoupdateList = [];
        
        工商信息.ChangeRecords.forEach(info => {
            infoupdateList.push({
                updateId:randomId(TABLEID.变更信息表),
                eId,
                afterContent:info.AfterContent, //变更前
                beforeContent:info.BeforeContent, //变更后
                changeDate:getMySqlMs(info.ChangeDate),//变更时间
                projectName:info.ProjectName,//变更类型
            });
        });
        
        await addManyData(TABLENAME.变更信息表, infoupdateList);
    }


    return
}

async function 软件著作(uscc) {
    let {header, query} = getReqParam(uscc);

    let 著作权软著:any = await getQcc('https://api.qichacha.com/CopyRight/SearchCopyRight', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (Array.isArray(著作权软著)) {
        let addList = [];
        著作权软著.forEach(info => {
            addList.push({
                iprId:randomId(TABLEID.知识产权),
                eId,
                year:getMySqlMs(info.RegisterDate),
                number:1,
                iprType:IPRALLTYPE.软件著作权,
                iprName:info.Name,
                category:info.Category,
            });
        });

        await addManyData(TABLENAME.知识产权, addList);
    }

    console.log();
}

async function 主要人员(uscc) {
    let {header, query} = getReqParam(uscc);
    let 主要人员数据:any = await getQcc('https://api.qichacha.com/ECIEmployee/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (Array.isArray(主要人员数据)) {
        let addList = [];
        主要人员数据.forEach(info => {
            addList.push({
                emId:randomId(TABLEID.主要人员),
                eId,
                job:info.Job,
                name:info.Name
            });
        });
        await addManyData(TABLENAME.主要人员, addList);
    }
    
}


async function 分支机构(uscc) {
    let {header, query} = getReqParam(uscc);
    let 分支机构数据:any = await getQcc('https://api.qichacha.com/ECIBranch/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (Array.isArray(分支机构数据)) {
        let addList = [];
        分支机构数据.forEach(info => {
            addList.push({
                brId:randomId(TABLEID.分支机构),
                eId,
                name:info.Name,
                status:info.Status,
                employeesName:info.OperInfo.Name
            });
        });
        await addManyData(TABLENAME.分支机构, addList);
    }
}


async function 行政许可核查(uscc) {
    let {header, query} = getReqParam(uscc);
    let 行政许可核查数据:any = await getQcc('https://api.qichacha.com/AdminLicenseCheck/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (行政许可核查数据.Data) {
        let addList = [];
        行政许可核查数据.Data.forEach(info => {
            let addInfo:any = {
                liId:randomId(TABLEID.行政许可核查),  
                eId,
                source:info.Source,
                licenseNo:info.LicenseNo,
                licenseName:info.LicenseName,
                licensOffice:info.LicensOffice,
                licensContent:info.LicensContent,
                documentNo:info.DocumentNo,
                permissionNo:info.PermissionNo,
            };
            if (info.ValidityFrom) addInfo.validityFrom = getMySqlMs(info.ValidityFrom);
            if (info.ValidityTo) addInfo.validityTo = getMySqlMs(info.ValidityTo);

            addList.push(addInfo);
        });

        await addManyData(TABLENAME.行政许可核查, addList);
    }
}

async function 空壳扫描(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/ShellScan/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addList = [];
        qccselectdata.Data.forEach(info => {
            addList.push({
                emptyId:randomId(TABLEID.空壳扫描),  
                eId,
                title:info.Title,
                description:info.Description,
           });
        });
        await addManyData(TABLENAME.空壳扫描, addList);
    }
}

async function 准入尽职调查(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/AcctScan/GetInfo', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addList = [];
        qccselectdata.Data.forEach(info => {
            addList.push({
                riskId:randomId(TABLEID.风险),  
                eId,
                title:info.Title,
                description:info.Description,
                passage:info.Passage,
                riskType:info.RiskType,
                typeCode:parseInt(info.TypeCode),
           });
        });
        await addManyData(TABLENAME.风险, addList);
    }
}

function getFinancingRounds(str) {
    if (str.indexOf("天使")) return FINANCINGROUNDS.天使投资;
    if (str.indexOf("种子")) return FINANCINGROUNDS.种子轮;
    if (str.indexOf("A")) return FINANCINGROUNDS.A轮;
    if (str.indexOf("B")) return FINANCINGROUNDS.B轮;
    if (str.indexOf("C")) return FINANCINGROUNDS.C轮;
    if (str.indexOf("以上")) return FINANCINGROUNDS.C轮以上;
    return FINANCINGROUNDS.天使投资;
}

async function 融资信息核查(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/CompanyFinancingSearch/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addList = [];
        qccselectdata.Data.forEach(info => {
            addList.push({
                rId:randomId(TABLEID.企业融资),  
                eId,
                financingAmount:isNaN(info.Amoun) ? 0 : parseFloat(info.Amount),
                financingRounds:getFinancingRounds(info.Round),
                investmentDate:getMySqlMs(info.Date),
                investmentInstitutionsName:info.Investment,
           });
        });
        await addManyData(TABLENAME.企业融资, addList);
    }
}

async function 国际专利(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/InternationalPatentCheck/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addList = [];
        qccselectdata.Data.forEach(info => {
            addList.push({
                iprId:randomId(TABLEID.知识产权),
                eId,
                year:getMySqlMs(info.PublicationDate),
                number:1,
                iprType:IPRALLTYPE.海外专利,
                iprName:info.Title,
            });
        });
        await addManyData(TABLENAME.知识产权, addList);
    }
}


async function 科创分(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/TechScore/GetInfo', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addInfo = {
            stemId:randomId(TABLEID.科创分),
            eId,
            industry:qccselectdata.Data.Industry.Industry,
            subIndustry:qccselectdata.Data.Industry.SubIndustry,
            industryRanking:qccselectdata.Data.IndustryRanking,
            score:qccselectdata.Data.Score,
        };
        await addManyData(TABLENAME.科创分, [addInfo]);
    }
}



async function 资质证书(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/ECICertification/SearchCertification', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (Array.isArray(qccselectdata)) {
        let addList = [];
        qccselectdata.forEach(info => {
            let addInfo:any = {
                cerId:randomId(TABLEID.资质证书),
                eId,
                name:info.Name,
                type:info.Type,
                no:info.No,
                typeDesc:info.TypeDesc,
                institutionList:info.InstitutionList ? info.InstitutionList[0] :"",
                status:info.Status,
            };

            if (info.StartDate) addInfo.startDate = getMySqlMs(info.StartDate)
            if (info.EndDate) addInfo.endDate = getMySqlMs(info.EndDate)

            addList.push(addInfo);
        });
        await addManyData(TABLENAME.资质证书, addList);
    }
}


async function 专利查询(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/PatentV4/Search', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (Array.isArray(qccselectdata)) {
        console.log();
        //todo 没有做
        let addList = [];
        qccselectdata.forEach(info => {
            addList.push({
                iprId:randomId(TABLEID.知识产权),
               
            });
        });

    }

    console.log();
}


async function 失信核查(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/ShixinCheck/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addList = [];
        qccselectdata.Data.forEach(info => {
            let addInfo:any = {
                disId:randomId(TABLEID.失信核查),
                eId,   
                anno:info.Anno,
                executegov:info.Executegov,
                executestatus:info.Executestatus,
                executeno:info.Executeno,
                actionRemark:info.ActionRemark,
                amount:info.Amount,
            };

            if (info.Liandate) addInfo.liandate = getMySqlMs(info.Liandate);
            if (info.Publicdate) addInfo.publicdate = getMySqlMs(info.Publicdate);

            addList.push(addInfo);
        });
        await addManyData(TABLENAME.失信核查, addList);
    }
}


async function 严重违法核查(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/SeriousIllegalCheck/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addList = [];
        qccselectdata.Data.forEach(info => {
            let addInfo:any = {
                stemId:randomId(TABLEID.严重违法犯罪),
                eId,
                type:info.Type,
                addReason:info.AddReason,
                addOffice:info.AddOffice,
                removeReason:info.RemoveReason,
                removeOffice:info.RemoveOffice,
            };
            if (info.AddDate) addInfo.addDate = getMySqlMs(info.AddDate);
            if (info.RemoveDate) addInfo.removeDate = getMySqlMs(info.RemoveDate);

            addList.push(addInfo);
        });
        await addManyData(TABLENAME.严重违法犯罪, addList);
    }
}


async function 企业对外投资核查(uscc) {
    let {header, query} = getReqParam(uscc);
    let qccselectdata:any = await getQcc('https://api.qichacha.com/InvestmentCheck/GetList', query, header);
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
    let eId = enterpriseInfo.eId;

    if (qccselectdata.Data) {
        let addList = [];
        qccselectdata.Data.forEach(info => {
            let addInfo:any = {
                oilId:randomId(TABLENAME.对外投资),
                eId,
                name:info.Name,
                registCapi:info.RegistCapi,
                registeredCapital:info.RegisteredCapital,
                registeredCapitalUnit:info.RegisteredCapitalUnit,
                registeredCapitalCCY:info.RegisteredCapitalCCY,
                fundedRatio:info.FundedRatio,
                shouldCapi:info.ShouldCapi,
                subscribedCapital:info.SubscribedCapital,
                subscribedCapitalUnit:info.SubscribedCapitalUnit,
                subscribedCapitalCCY:info.SubscribedCapitalCCY,
                status:info.Status,
                operName:info.Oper.Name
            };
            if (info.StartDate) addInfo.StartDate = getMySqlMs(addInfo.StartDate);
            if (info.investDate) addInfo.InvestDate = getMySqlMs(addInfo.InvestDate);

            addList.push(addInfo);
        });
        await addManyData(TABLENAME.对外投资, addList);
    }
}




// async function 企业年报信息(uscc, query, header) {
//     let qccselectdata:any = await getQcc('https://api.qichacha.com/AR/GetAnnualReport', query, header);
//     let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);
//     let eId = enterpriseInfo.eId;

//     if (qccselectdata.Data) {
//         let addList = [];
//         qccselectdata.Data.forEach(info => {
//             addList.push({
//                 stemId:randomId(TABLENAME.知识产权),
//                 eId,
//                 industry:info.Industry,
//                 subIndustry:info.SubIndustry,
//                 industryRanking:info.IndustryRanking,
//                 score:info.Score,
//             });
//         });

//     }

//     console.log();
// }









async function 企查查数据集(uscc) {
    
    const TimeSpan = Math.round(new Date().valueOf()/ 1000);
    let header = {
        Token:md5(`${systemConfig.qccKey}${TimeSpan}${systemConfig.qccSecretKey}`).toUpperCase(),
        TimeSpan
    };
    let query = {
        key:systemConfig.qccKey,
        searchKey:uscc,
        // keyNo:"云合智网（上海）技术有限公司"
    };
    let 工商信息:any = await getQcc('https://api.qichacha.com/ECIInfoVerify/GetInfo', query, header);//获取工商信息
    
    let keyList = ["Name", "StartDate", "Address", "RegistCapi", "RecCap", "StockType"];

    let dataList = [];
    keyList.forEach(str => {
        dataList.push(工商信息[str] || "-");
    });
    let PartnersStr = "";//投资人
    if (工商信息.Partners) {
        工商信息.Partners.forEach(item => {
            PartnersStr += `${item.StockName}:${item.StockPercent};`
        });
    }
    dataList.push(PartnersStr);
    dataList.push(工商信息.ContactInfo.PhoneNumber||"-");
    dataList.push(工商信息.Industry.Industry||"-");
    //联系信息
    let TagListStr = "";//企业标签
    if (工商信息.TagList) {
        工商信息.TagList.forEach(item => {
            TagListStr += `${item.Name};`
        });
    }
    dataList.push(TagListStr);
   
    let 著作权软著:any = await getQcc('https://api.qichacha.com/CopyRight/SearchCopyRight', query, header);

    let 著作权软著Str = "";
    if(Object.keys(著作权软著).length) {
        著作权软著.forEach(item => {
            著作权软著Str += item.Name;
        });
    }
    dataList.push(著作权软著Str);

    let 准入尽职调查:any = await getQcc('https://api.qichacha.com/AcctScan/GetInfo', query, header);
    let 风险 = "";
    if (准入尽职调查.Data) {
        准入尽职调查.Data.forEach(item => {
            风险 += item.Title;
        });
    }
    dataList.push(风险);

    let 专利查询:any = await getQcc('https://api.qichacha.com/PatentV4/Search', query, header);
    let 专利查询Str = 0;
    if (Object.keys(专利查询).length) {
        专利查询.forEach(item=> {
            专利查询Str += item.items.length;
        })
    }
    dataList.push(专利查询Str);

    let 失信核查:any = await getQcc('https://api.qichacha.com/ShixinCheck/GetList', query, header);
    let 失信核查Str = 失信核查.VerifyResult ?? "-";
    dataList.push(失信核查Str);

    let 资质证书:any = await getQcc('https://api.qichacha.com/ECICertification/SearchCertification', query, header);
    let 资质证书Str = 0;
    if (Object.keys(资质证书).length) {
        资质证书Str = 资质证书.length;
    }
    dataList.push(资质证书Str);

    let 融资信息:any = await getQcc('https://api.qichacha.com/CompanyFinancingSearch/GetList', query, header);
    
    let 融资信息Str = "";
    if (融资信息.Data) {
        融资信息.Data.forEach(item => {
            融资信息Str += `${item.Amount};` 
        })
    }
    dataList.push(融资信息Str);

    return dataList;
}