/**
 * 公共资源路由
 */
import * as asyncHandler from 'express-async-handler';
import * as enumConfig from '../config/enum/enum';
import * as outputEnumConfig from '../config/enum/outputEnum';

const config = {
    "/public/industry":enumConfig.INDUSTRY,
    "/public/zzmm":enumConfig.ZZMM,
    "/public/degree":enumConfig.DEGREE,
    "/public/sex":enumConfig.SEX,
    "/public/enterpriseteam":enumConfig.ENTERPRISETEAM,
    "/public/listingsituation":enumConfig.LISTINGSITUATION,
    "/public/awardlevel":enumConfig.AWARDLEVEL,
    "/public/followupstatus":enumConfig.FOLLOWUPSTATUS,
    "/public/needcategory":enumConfig.NEEDCATEGORY,
    "/public/fuhuaqilnvestmentstyle":enumConfig.FUHUAQILNVESTMENTSTYLE,
    "/public/financingrounds":enumConfig.FINANCINGROUNDS,
    "/public/output/enterprise":outputEnumConfig.ENTERPRISEBASE,
    "/public/output/enterprisemanage":outputEnumConfig.ENTERPRISEMANAGE,
    "/public/output/enterprisefinancing":outputEnumConfig.ENTERPRISEFINANCING,
    "/public/output/enterprisetalent":outputEnumConfig.ENTERPRISETALENT,
    "/public/output/enterpriseservice":outputEnumConfig.ENTERPRISESERVICE,
    "/public/output/enterprisemoveout":outputEnumConfig.ENTERPRISEBASEMOVEOUT,
    "/public/iprtypeclientqt":enumConfig.IPRTYPECLIENTQT,// 新增知识产权类型
    "/public/iprtypeclientzl":enumConfig.IPRTYPECLIENTZL,// 新增知识产权专利
    "/public/policytype":enumConfig.POLICYTYPE,// 政策文件类型
    "/public/clientpolicytype":enumConfig.CLIENTPOLICYTYPE,// 政策文件类型-前端用
    "/public/building":enumConfig.BUILDING,// 园区楼号
    "/public/ipralltype":enumConfig.IPRALLTYPE, //企查查知识产权类型
    "/public/desctypeclient":enumConfig.DESCTYPECLIENT, //入孵申请审批驳回
    "/public/filedesctypeclient":enumConfig.FILEDESCTYPECLIENT, //入孵材料审批驳回
    // "/public/output/basedata":outputEnumConfig.BASEDATA,
    // "/public/output/opreatdata":outputEnumConfig.OPERATIONDATA,
    // "/public/output/financingdata":outputEnumConfig.FINANCINGDATA,
    
}

export function setRouter(httpServer) {
    for (let modelKey in config) {
        httpServer.post(modelKey, asyncHandler(getEnumItf(config[modelKey])));
    }
}


/**
 * 获取行业领域
 * @param req 
 * @param res 
 */
function getEnumItf(enumCof) {
    return async function (req, res) {
        let dataList = [];
        for (let key in enumCof) {
            let anyKey:any = key;
            if (isNaN(anyKey)) {
                dataList.push({key, value:enumCof[key]});
            }
        }
        res.success({dataList});
    }
   
}