/**
 * 管理后台-企业自评
 */

import * as asyncHandler from 'express-async-handler';
import * as answerBiz from '../biz/answer';
import { checkUser } from '../middleware/user';



export function setRouter(httpServer) {
    httpServer.post('/admin/answer/gaoxin/list', checkUser, asyncHandler(enterpriseResults));
    httpServer.post('/admin/answer/gaoxin/details', checkUser, asyncHandler(getAnswerDetails));
    httpServer.post('/admin/answer/zufang/list', checkUser, asyncHandler(getHousingSubsidy));
}


/**
 * 高新-企业自评结果列表
 * @param req 
 * @param res 
 */
 async function enterpriseResults(req, res) {
    const UserInfo = req.userInfo;
    let {enterpriseName, page } = req.body
    let result = await answerBiz.enterpriseResults(enterpriseName, page);

    res.success(result);
}


/**
 * 高新-企业自评结果列表
 * @param req 
 * @param res 
 */
 async function getAnswerDetails(req, res) {
    const UserInfo = req.userInfo;
    let {garId, answerType } = req.body
    let result = await answerBiz.getAnswerDetails(garId, answerType);

    res.success(result);
}


/**
 * 高新-企业自评结果列表
 * @param req 
 * @param res 
 */
 async function getHousingSubsidy(req, res) {
    const UserInfo = req.userInfo;
    let { enterpriseName, page } = req.body
    let result = await answerBiz.getHousingSubsidyEligibilityList(enterpriseName, page);

    res.success(result);
}





