// 使用示例：下载多个图片并打包成ZIP

const { downloadImagesByUrls, downloadImagesWithNames, downloadImagesAndZip } = require('./imgZip');

// 示例1：根据URL数组下载图片并打包
async function example1() {
    const imageUrls = [
        'https://example.com/image1.jpg',
        'https://example.com/image2.png',
        'https://example.com/image3.gif'
    ];
    
    const result = await downloadImagesByUrls(imageUrls, 'my_images');
    
    if (result.isSuccess) {
        console.log('ZIP创建成功:', result.zipPath);
    } else {
        console.error('错误:', result.error);
    }
}

// 示例2：指定自定义文件名
async function example2() {
    const imageUrls = [
        'https://example.com/image1.jpg',
        'https://example.com/image2.png'
    ];
    
    const filenames = [
        '封面图.jpg',
        '详情图.png'
    ];
    
    const result = await downloadImagesWithNames(imageUrls, filenames, 'custom_names');
    
    if (result.isSuccess) {
        console.log('ZIP创建成功:', result.zipPath);
    } else {
        console.error('错误:', result.error);
    }
}

// 示例3：使用完整的图片信息对象
async function example3() {
    const images = [
        { url: 'https://example.com/image1.jpg', filename: '图片1.jpg' },
        { url: 'https://example.com/image2.png' }, // 不指定文件名，会自动生成
        { url: 'https://example.com/image3.gif', filename: '特殊图片.gif' }
    ];
    
    const result = await downloadImagesAndZip(images, 'mixed_images');
    
    if (result.isSuccess) {
        console.log('ZIP创建成功:', result.zipPath);
    } else {
        console.error('错误:', result.error);
    }
}

module.exports = {
    example1,
    example2,
    example3
};
