/**
 * 行业领域
 */
export enum INDUSTRY{
    "信息传输、软件和信息技术服务业" = 1,
    科学研究和技术服务业,
    制造业,
    建筑业,
    租赁和商务服务业,
    批发和零售业

    // 集成电路 = 1,
    // 生物医药,
    // 人工智能及智能制造,
    // 航空航天,
    // 汽车产业,
    // 软件和信息服务业,
    // 低碳环保及新材料,
    // 综合,
    // 文化创意
}


/**
 * 孵化器看板使用
 * 孵化器收入
 */
export enum INCOME {
    综合收入 = 1,
    投资收入,
    房租收入,
    财政补贴,
    其他收入,
}



/**
 * 最高学历
 */
export enum DEGREE {
    专科 = 1,
    本科,
    硕士,
    博士,
    博士以上,
    其他
}

/**
 * 政治面貌
 */
export enum ZZMM {
    中共党员 = 1,
    共青团员,
    民主党派成员,
    无党派人士,
    群众,
    预备党员,
    正式党员,
    党员发展对象,
    入党积极分子,
    少先队员,
    其他
}


/**
 * 孵化状态
 */
export enum FUHUASTATE {
    实体孵化 = 2,
    虚拟孵化 = 3,
    迁出= 4
}

/**
 * 迁出类型
 */
export enum EMIGRATIONTYPE {
    毕业迁出 = 1,
    毕业未迁出, //新加状态
    到期退租,
    违约退租,
    到期未迁出
}


/**
 * 上市情况
 */
export enum LISTINGSITUATION {
    A股 = 1,
    科创板,
    海外,
}


/**
 * 奖项等级
 */
export enum AWARDLEVEL {
    国家级 = 1,
    省级,
    市级,
    区级,
    街道办,
    其他
}

/**
 * 性别
 */
export enum SEX {
    男 = 1,
    女
}


/**
 * 创始团队 
 */
export enum ENTERPRISETEAM {
    海外人才 = 2,
    国内人才
}


//企业服务受理
export enum FOLLOWUPSTATUS {
    未受理 = 1,
    受理中,
    已完成
}


/**
 * 服务类别
 */
export enum NEEDCATEGORY {
    // 物业服务 = 1,
    // 工商税务 = 2,
    代理记账 = 3,
    贷款服务,
    法律服务,
    知识产权,
    工商服务,
    融资服务
}


/**
 * 孵化器投资方式
 */
export enum FUHUAQILNVESTMENTSTYLE {
    自有资金 = 1,
    自有基金,
    参与基金
}

/**
 * 融资轮次
 */
export enum FINANCINGROUNDS {
    种子轮 = 1,
    天使投资,
    A轮,
    B轮,
    C轮,
    C轮以上,
}


/**
 * 政策类型
 */
export  enum POLICYTYPE { 
    财政补贴 = 1,
    资质申报 = 2,
    政策扶持 = 3,
    // 政策宣讲 = 3
}


/**
 * 政策类型前端用
 */
export  enum CLIENTPOLICYTYPE { 
    全部 = 0,
    财政补贴 = 1,
    资质申报 = 2,
    政策扶持 = 3,
    // 政策宣讲 = 3
}


/**
 * 园区楼号
 */
export enum BUILDING {
    "1号楼" = 1,
    "3号楼" = 3,
    "4号楼" = 4,
}


export enum PROMOTIONTYPE {
    线上推广 = 1,
    线下推广,
}


/**
 * 线上推广
 */
export enum ONLINEPROMOTION { 
    视频号 = 1,
    抖音,
    小红书
}


/**
 * 线下推广
 */
export enum OFFLINEPROMOTION { 
    活动宣讲 = 1,
    三方机构合作
}


export enum OUTCOME {
    未解决 = 0,
    已解决
}


export enum STATE {
    否 = 0,
    是,
}


/**
 * 入孵申请审批历史-审批状态
 */
export enum CHANGESTATE {
    未审核 = 0,//未审核
    已驳回 = 1,//已驳回
    // 重新提交 = 2,
    已通过
}


/**
 * 入孵申请审批历史-审批类型
 */
export enum CHANGETYPE {
    入孵申请 = 1,
    入孵材料审批 = 2
}


/**
 * 入孵申请审批驳回类型
 */
export enum DESCTYPE {
    企业信息填写内容有误 = 1,
    企业业务方向与孵化器定位不匹配,
    企业孵化阶段与孵化器不符,
    孵化器资源限制,
    其他 = 999
}


/**
 * 入孵材料审批驳回类型
 */
export enum FILEDESCTYPE {
    "附件材料有误、不完整" = 101,
    附件材料与填报信息不一致,
    附件材料模糊不清,
    其他 = 999
}


/**
 * 入孵申请审批驳回类型
 */
export enum DESCTYPECLIENT {
    企业信息填写内容有误 = 1,
    企业业务方向与孵化器定位不匹配,
    企业孵化阶段与孵化器不符,
    孵化器资源限制,
    // 其他 = 999
}


/**
 * 入孵材料审批驳回类型
 */
export enum FILEDESCTYPECLIENT {
    "附件材料有误、不完整" = 101,
    附件材料与填报信息不一致,
    附件材料模糊不清,
    // 其他 = 999
}


export enum QUARTER {
    第一季度 = 1,
    第二季度,
    第三季度,
    第四季度
}


export enum IPRTYPE {
    软件著作权 = 1,
    专利 = 100,
    其他 = 200
}


/**
 * 知识产权 全类型
 */
export enum IPRALLTYPE {
    商标信息 = 1,
    作品著作权,
    软件著作权,
    外观设计专利,
    实用新型专利,
    发明专利
    // 软件著作权 = 1,
    // 专利 = 100,
    // 发明专利 = 101,
    // 海外专利 = 102,
    // 其他 = 200,
    // 植物新品种 = 201,
    // 集成电路布图 =202
}


/**
 * 专利表属于知识产权类型中的详细分类
 */
 export enum KUNDCODE {
    发明公布 = 1,
    发明授权,
    实用新型,
    外观设计
}


/**
 * 租房补贴题目
 */
export enum ANSWERTYPE {
    是否有研发费用 = 1,
    是否有缴纳社保,
    是否有软著等知识产权,
    是否认定科小或创新型中小企业
}


/**
 * 知识产权类型其他 前端用
 */
export enum IPRTYPECLIENTQT {
    植物新品种 = 201,
    集成电路布图 =202
}

/**
 * 知识产权类型专利 前端用
 */
export enum IPRTYPECLIENTZL {
    发明专利 = 101,
    海外专利 = 102,  
}


export enum RUFUSTATE {
    /**步骤1 */
    入孵申请信息填写 = 1,
    入孵申请信息驳回 = 2,
    入孵申请信息审核中 = 3,
    入孵申请信息审核成功 = 4,
    /**步骤2 */
    入孵材料填写 = 5,
    入孵材料驳回 = 6,
    入孵材料审核中 = 7,
    入孵材料审核成功 = 8
    
    // 信息填写 = 1,
    // 信息审核中 = 2,
    // 信息审核成功 = 3,
    // 信息审核失败 = 4,
    // 补充材料 = 5,
    // 材料已提交 = 6,
    // 材料审核完成 = 7
}

export enum RISKTYPE {
    严重违法失信 = 1510,
    股权冻结 = 1810,
    股权出质 = 2510,
    被列入失信 = 1710,
    被列入经营异常_l未移出_r = 1610,
    法定代表人频繁变更 = 2610,
    大股东频繁变更 = 2710,
    实际控制人频繁变更 = 2810,
    联系方式或注册地址重复 = 2010,
    法定代表人失信 = 3010,
    来自I类高风险 = 1410,
    来自II类_dIII类高风险 = 1411,
    同实际控制人企业众多 = 2310,
    关联企业注册地分散 = 2210,
    简易注销 = 5010,
    税收违法 = 5020,
    抽查检查不合格 = 5030,
    环保处罚 = 5040,
    疑似洗钱风险 = 6101,
    疑似停业_d歇业_d停产或被吊销证照 = 6314,
    控制权分散 = 6803,
    历史经营异常 = 6908,
    同注册地址企业存在异常 = 6599,
    同联系方式企业存在异常 = 6499,
    关联企业存在司法风险 = 6707,
    关联企业存在违法事项 = 6706,
    关联企业涉高风险行业 = 6710,
    分支机构存在关联风险 = 6807,
    分支机构中企业存在异常 = 6899,
    关联企业集中注册 = 6709,
    受益所有人控制企业众多 = 6613,
    所有权与经营权分离 = 6802,
    实控人控制企业司法风险 = 6606,
    实控人控制企业洗钱风险 = 6607,
    实控人控制企业集中注册 = 6609,
    实控人控制企业行业风险 = 6610,
    实控人控制企业地区风险 = 6611,
    实控人控制企业地区风险高 = 6612,
    经营范围频繁变更 = 6904,
    注册地址频繁变更 = 6905,
    企业名称频繁变更 = 6906,
    注册资本降幅过大 = 6907,
    关联方成员企业存在异常 = 7099,
    主要人员存在外部关联风险 = 6999,
    公安通告 = 1311,
    支付许可中止或到期 = 1312,
    被列入被执行人 = 1711,
    注销备案 = 1611,
    负面新闻 = 6318,
    破产重整 = 2520,
    监管处罚 = 5050
}


/**
 * 邮件类型
 */
export enum MAILTYPE {
    通过入孵材料审核 = 1,
    结束企业服务,
    通过入孵申请,
    驳回入孵申请,
    驳回入孵材料申请,
}



