/**
 * 校验表单参数配置 【小程序】
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */

export const GardenNoticeUpdateConfig = {
    title:{type:"String"},// 标题
    content:{type:"String"},// 内容
    isPublished:{type:"Number"},// 是否发布（1：是，0：否）
    // publishTime:{type:"Number"},// 发布时间
    publishStartTime:{type:"Number"}, //发布开始时间
    publishEndTime:{type:"Number"},  //发布结束时间
    relatedEnterprise:{type:"[String]"},// 关联企业
}


export const PolicyUpdateConfig = {
    title:{type:"String"},// 标题
    desc:{type:"String"},// 内容
    source:{type:"String"},// 来源
    coverImg:{type:"[String]"},// 图片
    closeTimeMs:{type:"Number"},// 关闭时间
    isPermanent:{type:"Number"},//是否永久有效
    policyType:{type:"Number"},// 政策类型
}


export const ApplyForUpdateConfig = {
    sanFangXieYi:{type:"String"}, //三方协议链接
    fuHuaXieYi:{type:"String"}, //孵化协议链接
    fangWuZuLing:{type:"String"}, //房屋租赁合同链接
    fuHuaXieYiBuChong:{type:"String"}, //孵化协议补充协议书链接
    chengXinChengNuoHan:{type:"String"}, //诚信承诺函链接
    yingYeZhiZhao:{type:"String"}, //营业执照复印件链接
    ruFuZiLiao:{type:"String"}, //入孵资料明细链接
    ruZhuJiHua:{type:"String"}, //入驻计划复印件链接
    yaJinZhiFu:{type:"String"}, //押金支付凭证链接
    cardCopy:{type:"String"}, //身份证复印件地址链接

    // leaseContract:{type:"String"},// 房屋租赁合同链接
    // entryPlan:{type:"String"},// 入驻计划复印件链接
    // businessLicense:{type:"String"},// 营业执照复印件链接
    // agreement:{type:"String"},// 孵化协议链接
    // tripartiteAgreement:{type:"String"},// 三方协议链接
}

export const SettleInForUpdateConfig = {
    enterpriseName:{type:"String"},
    uscc:{type:"String"},//信用代码
    logonTime:{type:"Number"},//注册时间
    logonAddress:{type:"String"},//注册地址
    fuHuaTimeStart:{type:"Number"},//孵化开始时间
    fuHuaTimeEndTime:{type:"Number"},//孵化结束时间
    leaseStartTime:{type:"Number"},//租赁开始时间
    leaseEndTime:{type:"Number"},//租赁结束时间
    uId:{type:"String"},
    userName:{type:"String"},
    phone:{type:"String"},
    pwd:{type:"String"},
    mail:{type:"String"},//邮箱
    rent:{type:"Number"},//每月租金
    area:{type:"Number", required: false},//面积非必填
    building: { type: 'String', required: false }, // 租赁楼号非必填
    roomNumber:{type:"String", required: false},//室号非必填
    // unitPrice:{type:"Number"},//单价
    // totalPrice:{type:"Number"},//总价
}

export const RegisterUpdateConfig = {
    enterpriseName:{type:"String"},//企业名称
    logonAddress:{type:"String"},//注册地址
    uscc:{type:"String"},//统一信用代码
    // leaseTimeStart:{type:"Number"},//租赁开始时间
    // leaseTimeEnd:{type:"Number"},//租赁结束时间
    logonTime:{type:"Number"},//注册时间
    area:{type:"Number"},//面积
}

export const AdminRegisterAddConfig = {
    // unitPrice:{type:"Number"},//单价
    // totalPrice:{type:"Number"},//总价
    enterpriseName:{type:"String",required: true, message: '企业名称不能为空'},//企业名称
    uscc:{type:"String",required: true, message: '统一信用代码不能为空'},//信用代码
    logonTime:{type:"Number",required: true, message: '注册时间不能为空'},//注册时间
    logonAddress:{type:"String",required: true, message: '注册地址不能为空'},//注册地址
    fuHuaTimeStart:{type:"Number",required: true, message: '孵化开始时间不能为空'},//孵化开始时间
    fuHuaTimeEndTime:{type:"Number",required: true, message: '孵化结束时间不能为空'},//孵化结束时间
    leaseStartTime: { type: 'Number', required: true, message: '租赁开始时间不能为空' },
    leaseEndTime: { type: 'Number', required: true, message: '租赁结束时间不能为空' },
    userName:{type:"String",required: true, message: '用户名不能为空'},
    phone:{type:"String",required: true, message: '手机号码不能为空'},
    pwd:{type:"String",required: true, message: '密码不能为空'},
    mail: { type: 'String', required: true, message: '邮箱地址不能为空' },
    rent:{type:"Number",required: true, message: '每月租金不能为空'},//每月租金
    area:{type:"Number", required: false},//面积非必填
    building: { type: 'String', required: false }, // 租赁楼号非必填
    roomNumber:{type:"String", required: false},//室号非必填
}


export const AdminRegisterUpdateConfig = {
    sanFangXieYi:{type:"String", required:true, message: '三方协议不能为空'}, //三方协议链接
    fuHuaXieYi:{type:"String", required:true, message: '孵化协议不能为空'}, //孵化协议链接
    fangWuZuLing:{type:"String", required:true, message: '房屋租赁合同不能为空'}, //房屋租赁合同链接
    fuHuaXieYiBuChong:{type:"String", required:true, message: '孵化协议补充协议书不能为空'}, //孵化协议补充协议书链接
    chengXinChengNuoHan:{type:"String", required:true, message: '诚信承诺函不能为空'}, //诚信承诺函链接
    yingYeZhiZhao:{type:"String", required:true, message: '营业执照复印件不能为空'}, //营业执照复印件链接
    ruFuZiLiao:{type:"String", required:true, message: '入孵资料明细不能为空'}, //入孵资料明细链接
    ruZhuJiHua:{type:"String", required:true, message: '入驻计划复印件不能为空'}, //入驻计划复印件链接
    cardCopy:{type:"String", required:true, message: '身份证复印件地址不能为空'}, //身份证复印件地址链接
    yaJinZhiFu:{type:"String", required:false}, //押金支付凭证链接

    // leaseContract:{type:"String",required: true, message: '房屋租赁合同不能为空' },// 房屋租赁合同链接
    // entryPlan:{type:"String",required: true, message: '入驻计划复印件不能为空'},// 入驻计划复印件链接
    // businessLicense:{type:"String",required: true, message: '营业执照复印件不能为空'},// 营业执照复印件链接
    // agreement:{type:"String",required: true, message: '孵化协议不能为空'},// 孵化协议链接
    // tripartiteAgreement:{type:"String",required: true, message: '三方协议不能为空'},// 三方协议链接
}


export const YuYiBaseDataUpdateConfig = {
    operateName:{type:"String"},//运营名称
    name:{type:"String"},//孵化器名称
    registerTime:{type:"String"},//注册时间
    incubateLv:{type:"String"},//孵化级别
    incubateTime:{type:"String"},//孵化器认定时间
    incubateField:{type:"String"},//孵化领域
    natureInstitution:{type:"String"},//机构性质
    contacts:{type:"String"},//联系人
    personCharge:{type:"String"},//负责人
    phone:{type:"String"},//手机号码
    synopsis:{type:"String"},//简介
    totalArea:{type:"String"},//孵化器总面积
    zaifuArea:{type:"String"},//在孵面积
    // rentRate:{type:"String"},//出租率
    // uscc:{type:"String"},//统一信用代码

    entryInfo:{type:"object"}, //孵化器入驻信息
    promotionInfo:{type:"object"},//推广信息

    // building:{type:"number"},//楼号
    // occupancyRate:{type:"String"},//入驻率
    // enteredEnterprises:{type:"String"},//入驻企业
    // promotionType:{type:"number"},//推广类型 枚举 线上推广、线下推广
    // promotionApp:{type:"number"},//推广应用 枚举 抖音、小红书、视频号
    // promotionNum:{type:"number"},//推广次数
}



export const UserRegisterAddConfig = {
    enterpriseName:{type:"String", required: true, message: '企业名称不能为空'},
    uscc:{type:"String",required: true, message: '统一信用代码不能为空'},//信用代码
    logonTime:{type:"Number", required: true, message: '注册时间不能为空'},//注册时间
    logonAddress:{type:"String", required: true, message: '注册地址不能为空'},//注册地址
    fuHuaTimeStart:{type:"Number", required: true, message: '孵化开始时间不能为空'},//孵化开始时间
    fuHuaTimeEndTime:{type:"Number", required: true, message: '孵化结束时间不能为空'},//孵化结束时间
    rent:{type:"Number", required: true, message: '每月租金不能为空'},//每月租金
    leaseStartTime: { type: 'Number', required: true, message: '租赁开始时间不能为空' },
    leaseEndTime: { type: 'Number', required: true, message: '租赁结束时间不能为空' },
    mail: { type: 'String', required: true, message: '邮箱地址不能为空' },
    // userName: { type: 'string', required: true, message: '联系人不能为空' },
    // phone: { type: 'string', required: true, message: '登录手机号码不能为空' },
    // pwd: { type: 'string', required: true, message: '登录密码不能为空' },
    building: { type: 'String', required: false }, // 租赁楼号非必填
    roomNumber: { type: 'String', required: false },    // 租赁室号非必填
    area: { type: 'Number', required: false },          // 租赁面积非必填
}

    /**
     * 备份
     */
    // export const UserRegisterAddConfig = {
    //     enterpriseName:{type:"String"},
    //     uscc:{type:"String"},//信用代码
    //     logonTime:{type:"Number"},//注册时间
    //     logonAddress:{type:"String"},//注册地址
    //     fuHuaTimeStart:{type:"Number"},//孵化开始时间
    //     fuHuaTimeEndTime:{type:"Number"},//孵化结束时间
    //     area:{type:"Number"},//面积
    //     roomNumber:{type:"String"},//室号
    //     rent:{type:"Number"},//每月租金
    //     }