import { OPERATIONALDATATYPE, TABLENAME } from "../config/enum/dbEnum";
import { MAILTYPE } from "../config/enum/enum";
import { ERRORENUM } from "../config/enum/errorEnum";
import { selectData } from "../data/operationalData";
import { successResult } from "../tools/system";
import { BizError } from "../util/bizError";

const nodemailer = require('nodemailer');

// 创建发送邮件的传输对象
// host: 'smtp.qq.com', // SMTP 服务器地址
// user: '1685675085@qq.com', // 你的邮箱地址
// pass: 'hppnsfvnzzhlbdfh' // 你的邮箱密码或应用专用密码
let transporter = nodemailer.createTransport({
    // logger: true,
    // host: 'smtp.qq.com', // SMTP 服务器地址
    // port: 465, // SMTP 服务器端口（通常是 465 或 587）
    // secure: true, // 使用 SSL
    // auth: {
    //     user: '1685675085@qq.com', // 你的邮箱地址
    //     pass: 'hppnsfvnzzhlbdfh' // 你的邮箱密码或应用专用密码
    // }

    host: 'smtp.exmail.qq.com', // SMTP 服务器地址
    port: 465, // SMTP 服务器端口（通常是 465 或 587）
    secure: true, // 使用 SSL
    auth: {
        user: 'zhaoyue@tninnopark.cn', // 你的邮箱地址
        pass: 'PrW7ucysg3ubvE7d' // 你的邮箱密码或应用专用密码
    }
});

async function send(toMail, name, type, otherStr?, code?) {
    let {title, mailStr} = getModel(name, type, otherStr, code);
    // 设置邮件选项
    let mailOptions = {
        from: '雨艺 <zhaoyue@tninnopark.cn>', // 发送者地址，需要同步发送邮箱的地址，否则发送邮箱会失败
        // from: '雨艺 <1685675085@qq.com>', // 发送者地址，需要同步发送邮箱的地址，否则发送邮箱会失败
        to: toMail,
        subject: `【雨艺孵化器】${title}`, // 邮件主题
        // text: 'Hello world?', // 邮件正文（纯文本）
        html: mailStr // 邮件正文（HTML 格式）
    };

    // new promises
    return new Promise((resolve, reject) => {
        transporter.sendMail(mailOptions, (error, info) => {
            if (error) {
                throw new BizError(ERRORENUM.邮件发送失败);
            }
            resolve(info);
        });
    });
}


function getModel(name, type, otherStr?, code?) {
    let str = "";
    let title = "";
    switch (type) {
        case MAILTYPE.通过入孵申请:
            str = "<p>感谢贵公司对【雨艺孵化器】的关注与信任。经我们初步审核，贵公司提交的入孵申请已通过<span style='font-weight: 700;'>初审</span>。为推进下一阶段工作，请贵方协助完成以下事项：</p>";
            str += "<p><span style='font-weight: 700;'>*电脑端：</span>通过点击链接上传入孵材料：</p>";
            str += "<p>https://fh.tninnopark.cn/incubatorApply</p>";
            str += "<p><span style='font-weight: 700;'>*手机端：</span>通过扫码上传入孵材料：</p>";
            str += "<p><img src='https://fh.tninnopark.cn/yuyi/files/域名访问.png' /></p>";
            str += "<p><span style='font-weight: 700;'>下一步事项：</span></p>";
            str += "<p>如涉及提交实物材料（如：入驻计划复印件、孵化协议等），携带公司证明材料前往4-1201。</p>";
            str += "<p>我们期待与贵公司的进一步合作，共同推动项目成长与落地</p>";
            str += "<p>再次感谢您的积极参与！</p>";
            str += "<p style='text-align: right;'>祝 商祺！</p>";
            str += "<p style='text-align: right;'>雨艺孵化器</p>";

            title = "贵公司入孵申请初审已通过";
        break;
        case MAILTYPE.驳回入孵申请:
            str = otherStr;
            str += "<p style='text-align: right;'>祝 商祺！</p>";
            str += "<p style='text-align: right;'>雨艺孵化器</p>";

            title = "贵公司入孵申请初审未通过通知";
        break;
        case MAILTYPE.通过入孵材料审核:
            str = "<p>感谢贵公司积极配合入孵流程。经审核，贵公司提交的入孵材料<span style='font-weight: 700;'>已审核通过：</span></p>";
            str += "<p>我们诚挚欢迎贵公司正式入驻，与我们共同开启创新发展新篇章！</p>";
            str += "<p>请搜索小程序“雨艺孵化器”，更多政策动态/消息任务将通过该小程序平台推送，请留心关注。</p>";
            str += "<p><img src='https://fh.tninnopark.cn/yuyi/files/小程序.jpg' /></p>";
            str += "<p style='text-align: right;'>祝 商祺！</p>";
            str += "<p style='text-align: right;'>雨艺孵化器</p>";

            title = "贵公司入孵材料审核已通过";
        break;
        case MAILTYPE.驳回入孵材料申请:
            str = otherStr;
            str += "<p style='text-align: right;'>祝 商祺！</p>";
            str += "<p style='text-align: right;'>雨艺孵化器</p>";

            title = "贵公司入孵材料审核未通过通知";
        break;
        case MAILTYPE.结束企业服务:
            str = otherStr;
            str += "<p style='text-align: right;'>祝 商祺！</p>";
            str += "<p style='text-align: right;'>雨艺孵化器</p>";

            title = "贵公司申请的企业服务已受理完毕";
        break;
    }

    let mailStr = ""
    mailStr +=`<p>尊敬的${name}团队：</p>`;
    mailStr +=`<p>您好！</p>`;
    mailStr +=`${str}`;

    return {mailStr, title};
}


/**
 * 系统发送邮件
 * @param userId 
 * @param type 
 */
 export async function systemSendMail(eId, type, otherStr?) {
    let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, ["eId", "enterpriseName", "uscc", "mail"]);

    if (!userInfo || !userInfo.eId) throw new BizError(ERRORENUM.企业不存在);
    if (!userInfo.mail) {
        new BizError(ERRORENUM.该用户邮箱为空, eId, eId.enterpriseName);
    } else {
        let result = await send(userInfo.mail, userInfo.enterpriseName, type, otherStr);
    }

    return successResult();
}


