/**
 * 服务
 */

import { ApplyForUpdateConfig, GardenNoticeUpdateConfig, PolicyUpdateConfig, RegisterUpdateConfig, SettleInForUpdateConfig } from "../config/eccParam/enterprise";
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import * as enumConfig from "../config/enum/enum";
import { operationalData, selectData, selectManyTableData } from "../data/operationalData";
import { BizError } from "../util/bizError";
import { eccFormParam } from "../util/verificationParam";
import { ERRORENUM } from "../config/enum/errorEnum";
import { getMySqlMs, getToken, md5PwdStr, randomCode, randomId } from "../tools/system";
import moment = require("moment");
import { changeAdd, extractData } from "../util/piecemeal";
import { EnterpriseApplyForConfig } from "../config/splitResult/enterprise";
import { changeEnumValue } from "../util/verificationEnum";
import { systemSendMail } from "./mail";



export async function enterpriseService(enterpriseName, followUpStatus, page) {
    let selectParam:any = {};
    if (followUpStatus) {
        selectParam.followUpStatus = followUpStatus;
    }
    let filesList = ["esId", "needCategory", "applyTime", "followUpStatus", "resolveTime", "needContent"];
    let manyTableInfo:any = {};
    manyTableInfo[TABLENAME.企业基础信息表] = {column:["eId",  "enterpriseName"], where:{} };
    if (enterpriseName) {
        manyTableInfo[TABLENAME.企业基础信息表].where = {enterpriseName:{"%like%":enterpriseName}}
    }
    let resList = await selectManyTableData(OPERATIONALDATATYPE.多表分页, TABLENAME.企业服务表, selectParam, filesList, manyTableInfo, page );
    let allResList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业服务表, selectParam, ["esId"], manyTableInfo, page );

    
    let dataList = [];
    resList.forEach(info => {
        dataList.push({
            esId:info.esId,
            needCategory:changeEnumValue(enumConfig.NEEDCATEGORY, info.needCategory),
            applyTime:moment(info.applyTime).format("YYYY-MM-DD HH:mm"),
            followUpStatus:changeEnumValue(enumConfig.FOLLOWUPSTATUS, info.followUpStatus),
            resolveTime:info.resolveTime ? moment(info.resolveTime).format("YYYY-MM-DD HH:mm") : '-',
            enterpriseName:info.enterprise.enterpriseName,
            needContent:info.needContent
        });
    });

    return {dataList, dataCount:allResList.length};
}


/**
 * 受理
 * @param esId 
 * @param fangKui 
 * @returns 
 */
export async function enterpriseServiceOption(esId:string, fangKui:string) {
    let selectParam:any = {esId};
    let filesList = ["esId"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业服务表, selectParam, filesList);
    if ( !resInfo || !resInfo.esId) {
        throw new BizError(ERRORENUM.数据不存在);
    }

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业服务表, {fangKui, followUpStatus:enumConfig.FOLLOWUPSTATUS.受理中, shouLiTime:getMySqlMs()}, {esId});

    return {
        isSuccess:true
    };
}


/**
 * 结束
 * @param esId 
 * @param outcome 
 * @param desc 
 * @returns 
 */
export async function enterpriseServiceEnd(esId:string, outcome:number, desc:string) {
    let selectParam:any = {esId};
    let filesList = ["esId", "eId", "needCategory", "applyTime"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业服务表, selectParam, filesList);
    if ( !resInfo || !resInfo.esId) {
        throw new BizError(ERRORENUM.数据不存在);
    }

    let resolveTime = getMySqlMs();
    let updateInfo = {outcome, followUpStatus:enumConfig.FOLLOWUPSTATUS.已完成, desc, resolveTime};
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业服务表,updateInfo, {esId});
    let applyTime = moment(resInfo.applyTime).format("YYYY-MM-DD");
    let needCategory = changeEnumValue(enumConfig.NEEDCATEGORY, resInfo.needCategory);
    let resolveTimeStr = moment(resolveTime).format("YYYY-MM-DD");
    //发送邮件
    let mailStr = "";
    mailStr += `<p>贵公司提交的**${needCategory}**申请，已于${resolveTimeStr}办理完毕，相关结果如下：</p>`;
    mailStr += `<p><span style='font-weight: 700;'>📌 办结事项详情：</span></p>`;
    mailStr += `<ul>`;
    mailStr += `<li><span style='font-weight: 700;'>服务事项名称：</span>${needCategory}</li>`;
    mailStr += `<li><span style='font-weight: 700;'>提交时间：</span>${applyTime}</li>`;
    mailStr += `<li><span style='font-weight: 700;'>办结时间：</span>${resolveTimeStr}</li>`;
    mailStr += `<li><span style='font-weight: 700;'>办理结果：</span>${desc}</li>`;
    mailStr += `</ul>`;
    mailStr += `<p>如涉及提交实物材料（如：营业执照等），携带公司证明材料前往4-1201。</p>`;
    mailStr += `<p>如您对上述办理情况有任何疑问或后续服务需求，欢迎随时与我们联系。</p>`;
    mailStr += `<p>感谢贵公司对【羽翼孵化器】的信任与支持！</p>`;
    await systemSendMail(resInfo.eId, enumConfig.MAILTYPE.结束企业服务, mailStr );

    return { isSuccess:true };
}


