//数据同步

import moment = require("moment");
import { OPERATIONALDATATYPE, TABLENAME } from "../config/enum/dbEnum";
import { selectData, selectManyTableData } from "../data/operationalData";


export async function integration() {

    let selectParam:any = {startTime:{"%between%":["2025-07-01", "2025-09-30"]}};

    let enterpriseFilesList = ["eId", "enterpriseName", "uscc", "industry", "logonTime", "logonAddress","operatingAddress", "mainBusiness"];
    let leaseFileList = ["area", "rent", "building", "roomNumber", "startTime", "endTime" ];
    let fuhuaFileList = [ "startTime", "endTime"];
    let manyTableInfo:any = {};
    manyTableInfo[TABLENAME.企业孵化信息] = {column:fuhuaFileList, where:selectParam };
    manyTableInfo[TABLENAME.租赁信息] = {column:leaseFileList, where:{} };
    
    let dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {}, enterpriseFilesList, manyTableInfo);

    let dataList = [];

    let distinctMap = {};

    dbList.forEach(info => {
        let { enterprise_fuhuas, enterprise_leases } = info;
        let enterprise_fuhua = enterprise_fuhuas[0];
        let enterprise_lease = enterprise_leases[0];

        let leaseAddress = "";
        if (enterprise_lease.building ) leaseAddress += `${enterprise_lease.building}号楼`;
        if (enterprise_lease.roomNumber) leaseAddress += `${enterprise_lease.roomNumber}室`;

        if (!leaseAddress) leaseAddress = JSON.parse(info.logonAddress)[JSON.parse(info.logonAddress).length - 1]

        let newindustry = [];
        JSON.parse(info.industry).forEach(key => {
            switch(key) {
                case 1: newindustry.push(6);break;
                case 2: newindustry.push(3);break;
                case 3: newindustry.push(8);break;
                case 4: newindustry.push(8);break;
                case 5: newindustry.push(8);break;
                case 6: newindustry.push(8);break;
            } 
        })
    
        let addInfo = {
            name:info.enterpriseName,
            uscc:info.uscc,
            industry:newindustry,
            logonTime:new Date(info.logonTime).valueOf(),
            // logonTime:info.logonTime,
            firstIncubationTime:new Date(enterprise_fuhua.startTime).valueOf(),
            isNaturalPersonHolding:true,
            logonAddress:JSON.parse(info.logonAddress),
            operatingAddress:info.operatingAddress ? JSON.parse(info.operatingAddress) : JSON.parse(info.logonAddress),
            leasedArea:enterprise_lease.area ? parseFloat(enterprise_lease.area) : 0,
            mainBusiness:info.mainBusiness || "",
            jiaSu:2,
            leaseAddress,
            price:parseFloat(enterprise_lease.rent),
            contractStartTime:new Date(enterprise_fuhua.startTime).valueOf(),
            contractEndTime:new Date(enterprise_fuhua.endTime).valueOf(),
            payStartTime:new Date(enterprise_fuhua.startTime).valueOf(),
            payLong:moment(enterprise_fuhua.endTime).diff(moment(enterprise_fuhua.startTime), 'months'),
            areaUnit:1
        };
        dataList.push(addInfo);

       if (!distinctMap[info.uscc]) distinctMap[info.uscc] = addInfo;
    });

    let outList = Object.values(distinctMap);
    console.log();
    
}

