/**
 * 公共资源路由
 */

import * as asyncHandler from 'express-async-handler';
import * as configEnum from "../config/enum";

export function setRouter(httpServer) {
    httpServer.post('/public/partypositions', asyncHandler(partyPositions));
    httpServer.post('/public/type', asyncHandler(type));
    httpServer.post('/public/entrytype', asyncHandler(entryType));
    httpServer.post('/public/activitytype', asyncHandler(activityType));
    httpServer.post('/public/informationtype', asyncHandler(informationType));
}


/**
 * 党内职务
 * @param req  
 * @param res 
 */
function partyPositions(req, res) {
    let dataList = [];
    for (let key in configEnum.PARTYPOSITIONS) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:configEnum.PARTYPOSITIONS[key]});
        }
    }
    res.success(dataList);
}


/**
 * 组织生活活动类型
 * @param req  
 * @param res 
 */
 function type(req, res) {
    let dataList = [];
    for (let key in configEnum.TYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:configEnum.TYPE[key]});
        }
    }
    res.success(dataList);
}


/**
 * 名册录入类型
 * @param req  
 * @param res 
 */
 function entryType(req, res) {
    let dataList = [];
    for (let key in configEnum.ENTRYTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:configEnum.ENTRYTYPE[key]});
        }
    }
    res.success(dataList);
}


/**
 * 党建活动类型
 * @param req  
 * @param res 
 */
 function activityType(req, res) {
    let dataList = [];
    for (let key in configEnum.ACTIVITYTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:configEnum.ACTIVITYTYPE[key]});
        }
    }
    res.success(dataList);
}


/**
 * 党建资讯类型
 * @param req  
 * @param res 
 */
 function informationType(req, res) {
    let dataList = [];
    for (let key in configEnum.INFORMATIONTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:configEnum.INFORMATIONTYPE[key]});
        }
    }
    res.success(dataList);
}

