/**
 * 小程序端 党员入口 用户基础功能路由
 */

import * as userBiz from '../../biz/applet/user';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkAppletToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/partymember/login', asyncHandler(login));
    httpServer.post('/partymember/changePwd', checkAppletToken, asyncHandler(changePwd));
    httpServer.post('/partymember/login/firstupdate', checkAppletToken, asyncHandler(firstUpdatePwd));
}


/**
 * 党员入口登录
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let userInfo = await userBiz.login(loginId, pwd);
    res.success(userInfo);
}


/**
 * 首次登录 
 * @param req 
 * @param res 
 */
 async function firstUpdatePwd(req, res) {
    let reqConf = {confirmPwd:'String', pwd:'String' };
    let {confirmPwd, pwd} = eccReqParamater(reqConf, req.body);

    const LoginId = req.headers.loginId;
    
    let result = await userBiz.firstLoginChangePwd(LoginId, pwd, confirmPwd);

    res.success(result);
}


/**
 * 修改密码
 * @param req 
 * @param res 
 */
 async function changePwd(req, res) {
    let reqConf = {confirmPwd:'String', newPwd:'String', pwd:'String' };
    let {confirmPwd, newPwd, pwd} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await userBiz.changePassword(Uscc, pwd, newPwd, confirmPwd); 

    res.success(result);
}