/**
 * 小程序端 党员入口 组织生活路由
 */

import * as organizationalLifeBiz from '../../biz/applet/partyMember/organizationalLife';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/partymember/organizationallife/list', asyncHandler(organizationalLifeList));
    httpServer.post('/partymember/organizationallife/create', asyncHandler(createOrganizationalLife));
    httpServer.post('/partymember/organizationallife/details', asyncHandler(detailsList));
    httpServer.post('/partymember/organizationallife/update', asyncHandler(updateOrganizationalLife));
    // httpServer.post('/applet/organizationallife/partymembernamelist', asyncHandler(getPartyMemberNameList));
    httpServer.post('/partymember/organizationallife/partymembernamelist', asyncHandler(getAllPartyMember));
}


/**
 * 组织生活列表
 * @param req 
 * @param res 
 */
async function organizationalLifeList(req, res) {
    let reqConf = {type:'Number', name:'Number'};
    let {type, name} = eccReqParamater(reqConf, req.body, ["name"]);

    let result = await organizationalLifeBiz.getOrganizationalLifeList(type, name);
    res.success(result);
}


/**
 * 创建活动
 * @param req 
 * @param res 
 */
async function createOrganizationalLife(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    
    let result = await organizationalLifeBiz.createOrganizationalLife(form);
    res.success(result);
}


/**
 * 组织生活详情
 * @param req 
 * @param res 
 */
async function detailsList(req, res) {
    let reqConf = {oId: 'Number' };
    let {oId} = eccReqParamater(reqConf, req.body);

    let result = await organizationalLifeBiz.getOrganizationalLifeById(oId);
    res.success(result);
}


/**
 * 修改对应oId的组织生活
 * @param req 
 * @param res 
 */
async function updateOrganizationalLife(req, res) {
    let reqConf = {oId: 'Number', form: 'Object' };
    let { oId, form } = eccReqParamater(reqConf, req.body);

    let result = await organizationalLifeBiz.updateOrganizationalLife(oId, form);
    res.success(result);
}


/**
 * 获取选择类型的党员信息
 * @param req 
 * @param res 
 * 停用
 */
async function getPartyMemberNameList(req, res) {
    let reqConf = {type: "Number", name: "String"};
    let {type, name} = eccReqParamater(reqConf, req.body, ["name"]);

    let result = await organizationalLifeBiz.getPartyMemberNameList(type, name);
    res.success(result);
}


/**
 * 获取全部党员信息
 * @param req 
 * @param res 
 */
async function getAllPartyMember(req, res) {
    let result = await organizationalLifeBiz.getAllPartyMember();
    res.success(result);
}