/**
 * 小程序端 党员入口 党建首页路由
 */

import * as baseBiz from '../../biz/applet/base';
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/partymember/home', asyncHandler(homeBase));
    httpServer.post('/partymember/information', asyncHandler(informationBase));
}


/**
 * 党建首页基础数据
 * @param req 
 * @param res 
 */
async function homeBase(req, res) {
    let baseInfo = await baseBiz.homeData();
    res.success(baseInfo);
}


/**
 * 党建首页党建资讯列表
 * @param req 
 * @param res 
 */
async function informationBase(req, res) {
    let reqConf = {informationType:'Number'};
    let {informationType} = eccReqParamater(reqConf, req.body);

    let informationInfo = await baseBiz.informationData(informationType);
    res.success(informationInfo);
}