import { ERRORENUM } from "../config/errorEnum";
import { findPartyMemberAll } from "../data/partyMember";
import { BizError } from "../util/bizError";


/**
 * 中间件 校验小程序token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkAppletToken(req, res, next) {
    if (!req.headers) req.headers = {};

    const reqToken = req.headers.token;
    const loginId = req.headers.loginId || "";

    if(!loginId) return next(new BizError(ERRORENUM.身份验证失败, `loginId:${loginId} token:${reqToken}`));

    let partyMemberInfo = await findPartyMemberAll({loginId});
    if (!partyMemberInfo) return next(new BizError(ERRORENUM.非法登录, `loginId:${loginId} token:${reqToken}`));

    next();
}