import mongoose = require('mongoose');

let defaultOptions = {
    useNewUrlParser:true,
    auto_reconnect:true,
    // reconnectTries:1000,
    // reconnectInterval:3000,
    keepAlive: 1,
    connectTimeoutMS: 3000,
    useCreateIndex: true,
    useUnifiedTopology: true
};


export async function createDbConnect(connectUrl:string, options?:object) {
  mongoose.set('useFindAndModify', false); //解决mongoose旧版弹出的警告
  if (!options) options = defaultOptions;
  return await mongoose.createConnection(connectUrl, options).catch(
    (err)=>{
      throw err
    });
}
