/**
 * 党员基础信息表
 */

import { Schema } from "mongoose";
import {yfsDB} from '../db/dbInit';
var autoIncrement = require('mongoose-auto-increment');

const partyMemberSchema = new Schema({
    id: {type:Number, index:{unique: true}}, //自增的id
    name: String, //姓名
    sex: Number, //性别 1：男、2：女
    birthDate: Number, //出生年月
    phone: String, //手机号码
    levelOfEducation: String, //文化程度
    partyJoiningTime: Number, //入党时间
    administrativePosition: Number, //行政职务 1：
    remarks: String, //备注
    entryType: Number, //名册录入类型 1：正式党员录入、2：入党积极分子录入、3：入党申请录入
    partyPositions: [Number], //党内职务 多选 --正式党员录入  1：书记、2：副书记、3：纪检委员、4：组织委员、5：宣传委员、6：党员、7：入党积极分子、8：预备党员
    listedAsActivistsTime: Number, //列为积极份子时间 --入党积极份子录入
    talkTime: Number, //谈话时间 --入党申请录入

    /**-----用户相关----- */
    loginId: {type: String, index: true}, //登录账号
    pwd: String, //密码
    token:{type:String, index:true},
    tokenMs:Number,
    firstLoginIsChangePwd:{type:Boolean, default:false}, //首次登录是否修改密码
})

var partyMemberModel;

export function initModel(){
    partyMemberSchema.plugin(autoIncrement.plugin, {
        model: 'partyMemberSchema',
        field: 'id',
        startAt: 1, //初始化id从1开始
        incrementBy: 1 //每次自增1
    });

    partyMemberModel = yfsDB.model('partyMember', partyMemberSchema);
    partyMemberModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await partyMemberModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }

        return selectInfo;
    }
}


export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 获取符合条件的所有党员信息
 * @param param 查询参数
 * @returns 
 */
export async function findPartyMemberAll(param) {
    return await partyMemberModel.find(param);
}


/**
 * 通过登录账号查询党员信息
 * @param loginId 登录账号
 * @returns 
 */
export async function findPartyMemberByLoginId(loginId:string) {
    return await partyMemberModel.selectOnceData({loginId});
}


/**
 * 获取符合条件的党员数量
 * @param param 查询参数
 * @returns number 数据数量
 */
export async function groupFindPartyMemberCount(param:object) {
    return await partyMemberModel.find(param).count();
}


/**
 * 根据党内职务查询在职人员信息
 * @param partyPositions  党内职务 [1, 2]
 * @returns 
 */
export async function getBaseListByPartyPositions(partyPositions) {
    return await partyMemberModel.find({partyPositions:{$in: partyPositions }});
}


/**
 * 
 * @param id 根据id查询党员名称
 * @returns 
 */
export async function getNameById(id:number) {
    return await partyMemberModel.find({id});
}


/**
 * 根据党员类型查询党员信息
 * @param param entryType 党员类型
 * @returns 
 */
export async function getPartyMemberListByEntryType(param) {
    return await partyMemberModel.find(param);
}


/**
 * 创建正式党员信息
 * @param param 所添加表单 需要提前验证
 */
 export async function createPartyMember(param) {
    return await partyMemberModel.create(param);
}
