/**
 * 党建资讯
 * partyInformation
 */

import { Schema } from "mongoose";
import {yfsDB} from '../db/dbInit'
var autoIncrement = require('mongoose-auto-increment');;

const partyInformationSchema = new Schema({
    pId: {type:Number, index:{unique: true}}, //自增的id
    informationType: Number, //党建资讯类型 1：医院文化、2：精神文明、3：科普知识、4、先进典型
    title: String, //资讯标题
    branch: String, //支部
    informationTime: Number, //资讯时间
    detailedInformation: String, //资讯详细
    img: {type:String, data:Buffer}, //图片
})

var partyInformationModel;

export function initModel(){
    partyInformationSchema.plugin(autoIncrement.plugin, {
        model: 'partyInformationSchema',
        field: 'pId',
        startAt: 1, //初始化id从1开始
        incrementBy: 1 //每次自增1
    });

    partyInformationModel = yfsDB.model('partyInformation', partyInformationSchema);
    partyInformationModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await partyInformationModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        
        return selectInfo;
    }
}


export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 根据党建资讯类型查询的党建资讯列表
 * @param informationType 党建资讯类型 1：医院文化、2：精神文明、3：科普知识、4、先进典型
 * @returns 
 */
export async function findPartyInformationListByType(informationType:number) {
   return await partyInformationModel.find({informationType});
}
 

/**
 * 创建党建资讯
 * @param param 所添加表单 需要提前验证
 * @returns 
 */
export async function createPartyInformation(param) {
    return await partyInformationModel.create(param);
}