/**
 * 组织生活表
 * organizationalLife
 */

import { Schema } from "mongoose";
import {yfsDB} from '../db/dbInit';
var autoIncrement = require('mongoose-auto-increment');

const organizationalLifeSchema = new Schema({
    oId: {type:Number, index:{unique: true}}, //自增的活动id
    partyActivityType: Number, //党建活动类型 1：日常教育培训、2：主题党日活动、3：骨干队伍培训、4：支部工作会、5：二十大精神、6：三会一课
    activityStartTime: {type:Number, index:true}, //活动开始时间
    activityEndTime:{type:Number, index:true}, //活动结束时间
    activityAdd: String, //活动地点
    activityHost: {type:[String], default:[]}, //活动主持人
    activityNoteTaker:{type:[String], default:[]}, //活动记录人
    leavePartyMember:[Number], //请假党员 非必填
    participatingPartyMember:[Number], //参与党员
    participationRecord:String, //活动记录

})

var organizationalLifeModel;

export function initModel(){
    organizationalLifeSchema.plugin(autoIncrement.plugin, {
        model: 'organizationalLifeSchema',
        field: 'oId',
        startAt: 1, //初始化id从1开始
        incrementBy: 1 //每次自增1
    });

    organizationalLifeModel = yfsDB.model('organizationalLife', organizationalLifeSchema);

    organizationalLifeModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await organizationalLifeModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }

        return selectInfo;
    }

}


export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}
 

/**
 * 获取符合条件的组织生活列表
 * @param param 查询参数
 * @returns 
 */
export async function findOrganizationalLifeList(param) {
    return await organizationalLifeModel.find(param);
}


/**
 * 获取正在进行的组织生活列表
 * 开始时间小于当前时间，结束时间大于当前时间
 * gt：大于某个值的数据、lt：小于某个值的数据
 * @returns 
 */
export async function findAfootActivityList(partyActivityType:number) {
    let nowTime = new Date().valueOf();
    return await organizationalLifeModel.find({"$and":[ {"activityStartTime":{"$lt":(nowTime)}}, {"activityEndTime":{"$gt":(nowTime)}}, {partyActivityType} ]});
}


/**
 * 获取即将开展的组织生活列表
 * 开始时间大于当前时间
 * @returns 
 */
export async function findBeginInActivityList(partyActivityType:number) {
    let nowTime = new Date().valueOf();
    return await organizationalLifeModel.find({"activityStartTime":{"$gt":(nowTime)}, partyActivityType});
}


/**
 * 获取已经开展的组织生活列表
 * 结束时间小于当前时间
 * @returns 
 */
export async function findStartedActivityList(partyActivityType:number) {
    let nowTime = new Date().valueOf();
    return await organizationalLifeModel.find({"activityEndTime":{"$lt":(nowTime)}, partyActivityType});
}


/**
 * 创建活动
 * @param param 所添加表单 需要提前验证
 */
export async function createActivity(param) {
    await organizationalLifeModel.create(param);
}


/**
 * 获取活动详情
 * @param id id 唯一标识
 * @returns 
 */
export async function findEventDetails(oId) {
    return await organizationalLifeModel.findOne({oId});
}


/**
 * 删除组织生活活动
 * @param oId 活动id
 * @returns 
 */
export async function deleteActivity(oId:number) {
    return await organizationalLifeModel.deleteOne({oId}).exec();
}