
export enum ERRORENUM {
    未找到数据,
    账号不存在,
    密码错误,
    密码不一致,
    密码只能由6至18位字符和数字组成,
    不能重复修改密码,
    表单校验失败,
    参数错误,
    数据无更新,
    地址数据不完整,
    身份验证失败,
    非法登录
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403,
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}