/**
 * 校验表单参数配置
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */


/**
 * 使用端: 小程序端_党员入口
 *   场景: 创建组织生活活动表单
 *   备注: 全部非必填
 */
export const CreateActivityConfig = {
    partyActivityType:{type:"Number", notMustHave:true},//党建活动类型
    activityStartTime:{type:"Number", notMustHave:true},//活动开始时间
    activityEndTime:{type:"Number", notMustHave:true},//活动结束时间
    activityAdd:{type:"String", notMustHave:true},//活动地点
    activityHost:{type:"[String]", notMustHave:true},//活动主持人
    activityNoteTaker:{type:"[String]", notMustHave:true},//活动记录人
    leavePartyMember:{type:"[Number]", notMustHave:true},//请假党员
    participatingPartyMember:{type:"[Number]", notMustHave:true},//参与党员
    participationRecord:{type:"String", notMustHave:true},//活动记录
};


/**
 * 使用端: 小程序端_党员入口
 *   场景: 修改组织生活活动表单
 *   备注: 全部非必填
 */
export const UpdateActivityFormConfig = {
    partyActivityType:{type:"Number", notMustHave:true},//党建活动类型
    activityStartTime:{type:"Number", notMustHave:true},//活动开始时间
    activityEndTime:{type:"Number", notMustHave:true},//活动结束时间
    activityAdd:{type:"String", notMustHave:true},//活动地点
    activityHost:{type:"[String]", notMustHave:true},//活动主持人
    activityNoteTaker:{type:"[String]", notMustHave:true},//活动记录人
    leavePartyMember:{type:"[Number]", notMustHave:true},//请假党员
    participatingPartyMember:{type:"[Number]", notMustHave:true},//参与党员
    participationRecord:{type:"String", notMustHave:true},//活动记录
}



/**
 * 使用端: 小程序端_党员入口
 *   场景: 创建正式党员录入表单
 *   备注: 全部非必填
 */
 export const CreatePartyMemberFormConfig = {
    name:{type:"String"},//姓名
    sex:{type:"Number"},//性别
    birthDate:{type:"Number"},//出生年月
    phone:{type:"String"},//手机号码
    levelOfEducation:{type:"String"},//文化程度
    partyJoiningTime:{type:"Number"},//入党时间
    administrativePosition:{type:"Number"},//行政职务
    remarks:{type:"String", notMustHave:true},//备注
    entryType:{type:"Number"},//名册录入类型
    partyPositions:{type:"[Number]"},//党内职务
    listedAsActivistsTime:{type:"Number", notMustHave:true},//列为积极份子时间
    talkTime:{type:"Number", notMustHave:true},//谈话时间
    loginId:{type:"String", notMustHave:true},//登录账号
    pwd:{type:"String", notMustHave:true},//密码
}


/**
 *  使用端: 小程序端_党员入口
 *   场景: 创建党建资讯录入表单
 *   备注: 全部非必填
 */
export const createPartyInformation = {
    pid:{type:"Number", notMustHave:true},
    informationType:{type:"Number", notMustHave:true},
    title:{type:"String", notMustHave:true},
    branch:{type:"String", notMustHave:true},
    inforMationTime:{type:"Number", notMustHave:true},
    detailedInformation:{type:"String", notMustHave:true},
    img:{type:"String", notMustHave:true}
}