/**
 * 小程序
 * 党员基本信息
 */

import * as partyMemberData from "../../../data/partyMember";
import * as configEnum from "../../../config/enum";
import { extractData } from "../../../util/piecemeal";
import * as splitResultConfig from "../../../config/splitResultConfig";
import * as verificationEnumTools from "../../../util/verificationEnum";
import { eccFormParam } from "../../../util/verificationParam";
import * as eccFormParamConfig from "../../../config/eccFormParamConfig";
import { getPwdMd5, getToken } from "../../../tools/system";


/**
 * 创建党员基础信息
 * @param param  {name: "姓名", sex: 性别, birthDate: 出生年月, phone: "手机号码", levelOfEducation: "文化程度", partyJoiningTime: 入党时间, administrativePosition: 行政职务, 
 *                remarks: "备注", entryType: 名册录入类型, partyPositions: [党内职务, ...], listedAsActivistsTime: 列为积极份子时间, talkTime: 谈话时间, loginId: "登录账号"}
 * @return {isSuccess: true}
 */
 export async function createPartyMember(param) {
    eccFormParam("创建正式党员录入", eccFormParamConfig.CreatePartyMemberFormConfig, param);
    verificationEnumTools.eccEnumValue('正式党员录入性别', 'partyActivityType', configEnum.SEX, param.partyActivityType);
    verificationEnumTools.eccEnumValue('正式党员录入党内职务', 'partyPositions', configEnum.PARTYPOSITIONS, param.partyPositions);
    verificationEnumTools.eccEnumValue('正式党员名册录入类型', 'entryType', configEnum.ENTRYTYPE, param.entryType);

    let partyMemberInfo:any = await partyMemberData.createPartyMember(param);
    partyMemberInfo.pwd = getPwdMd5(param.phone, param.phone.slice(5, 11));
    partyMemberInfo.token = getToken(param.phone);
    partyMemberInfo.tokenMs = new Date().valueOf();

    await partyMemberInfo.save();

    return {isSuccess: true};
}