/**
 * 小程序
 * 党建资讯
 */

import * as partyInformationData from "../../../data/partyInformation";
import { eccFormParam } from "../../../util/verificationParam";
import * as eccFormParamConfig from "../../../config/eccFormParamConfig";
import * as verificationEnumTools from "../../../util/verificationEnum";
import * as configEnum from "../../../config/enum";


/**
 * 创建党建资讯
 * @param param {informationType: 党建资讯类型, title: "资讯标题", branch: "支部名称", informationTime: 资讯时间, detailedInformation: "资讯详细", img: "资讯图片"}
 * @return {isSuccess: true}
 */
export async function createPartyInformation(param) {
    eccFormParam("创建党建资讯", eccFormParamConfig.CreatePartyMemberFormConfig, param)
    let partyInformation = await partyInformationData.createPartyInformation(param);
    verificationEnumTools.eccEnumValue('党建资讯类型', 'informationType', configEnum.INFORMATIONTYPE, param.informationType);

    await partyInformation.save();

    return {isSuccess: true};
}