/**
 * 小程序
 * 首页基础数据
 */

import * as partyMemberData from '../../data/partyMember';
import * as partyInformationData from '../../data/partyInformation';
import * as configEnum from "../../config/enum";
import * as splitResultConfig from "../../config/splitResultConfig";
import { extractData } from '../../util/piecemeal';
import { changeEnumValue, eccEnumValue } from '../../util/verificationEnum';
import moment = require('moment');


/**
 * 主页基础数据
 */
export async function homeData() {
    let partyMemberNum = await partyMemberData.groupFindPartyMemberCount({}); //党员总数
    let massIndex = 87.6; //党建指令指数

    let partyPositions = []; //党内职务人员
    for (let key in configEnum.PARTYPOSITIONS) {
        let anyKey:any = key;
        if (key != "党员" && key != "入党积极分子" && key != "预备党员") {
            if (isNaN(anyKey)) { //枚举key  key = string
                const EnumValue = parseInt(configEnum.PARTYPOSITIONS[key])
                let dataBaseList = await partyMemberData.getBaseListByPartyPositions( [EnumValue] );
        
                let nameList = [];
                dataBaseList.forEach( info => {
                    nameList.push(info.name);
                });
    
                partyPositions.push({
                    key,
                    list:nameList
                });
    
            }
        }
        
    }

    return { partyMemberNum, massIndex, partyPositions };
}


/**
 * 根据资讯类型查询党建资讯列表
 * @param informationType 党建资讯类型
 * @returns 
 */
export async function informationData(informationType:number) {
    if (informationType) eccEnumValue("党建资讯列表查询", "资讯类型", configEnum.INFORMATIONTYPE, informationType);

    let partyInformationInfo = await partyInformationData.findPartyInformationListByType(informationType);

    let dataList = [];
    partyInformationInfo.forEach( info => {
        let changeData:any = extractData(splitResultConfig.partyInformationConfig, info, false);
        changeData.informationType = changeEnumValue(configEnum.INFORMATIONTYPE, changeData.informationType);
        changeData.informationTime = moment(changeData.informationTime).format("YYYY.MM.DD HH:mm");

        dataList.push(changeData);
    })

    return dataList;
}



